/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.core.symtable;

import docking.ActionContext;
import docking.ComponentProvider;
import docking.WindowPosition;
import ghidra.app.context.ProgramActionContext;
import ghidra.app.plugin.core.symtable.ReferencePanel;
import ghidra.app.plugin.core.symtable.SymbolReferenceModel;
import ghidra.app.plugin.core.symtable.SymbolRenderer;
import ghidra.app.plugin.core.symtable.SymbolTablePlugin;
import ghidra.app.util.SymbolInspector;
import ghidra.framework.plugintool.ComponentProviderAdapter;
import ghidra.program.model.listing.Program;
import ghidra.program.model.symbol.Symbol;
import ghidra.util.HelpLocation;
import ghidra.util.Swing;
import ghidra.util.table.GhidraTable;
import java.awt.event.MouseEvent;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import resources.ResourceManager;

class ReferenceProvider
extends ComponentProviderAdapter {
    private static final ImageIcon ICON = ResourceManager.loadImage((String)"images/table_go.png");
    private SymbolTablePlugin plugin;
    private SymbolReferenceModel referenceKeyModel;
    private ReferencePanel referencePanel;
    private SymbolRenderer renderer;

    ReferenceProvider(SymbolTablePlugin plugin) {
        super(plugin.getTool(), "Symbol References", plugin.getName(), ProgramActionContext.class);
        this.plugin = plugin;
        this.setIcon(ICON);
        this.addToToolbar();
        this.setHelpLocation(new HelpLocation(plugin.getName(), "Symbol_References"));
        this.setWindowGroup("symbolTable");
        this.setIntraGroupPosition(WindowPosition.RIGHT);
        this.renderer = new SymbolRenderer();
        this.referenceKeyModel = new SymbolReferenceModel(plugin.getBlockModelService(), plugin.getTool());
        this.referencePanel = new ReferencePanel(this, this.referenceKeyModel, this.renderer, plugin.getGoToService());
        this.addToTool();
    }

    void dispose() {
        this.referencePanel.dispose();
        this.plugin = null;
    }

    public ActionContext getActionContext(MouseEvent event) {
        Program program = this.plugin.getProgram();
        if (program == null) {
            return null;
        }
        return new ProgramActionContext((ComponentProvider)this, program);
    }

    void setCurrentSymbol(Symbol symbol) {
        this.referenceKeyModel.setCurrentSymbol(symbol);
    }

    void symbolChanged(Symbol symbol) {
        if (this.isVisible()) {
            this.referenceKeyModel.symbolChanged(symbol);
        }
    }

    void symbolRemoved(long symbolID) {
        if (this.isVisible()) {
            this.referenceKeyModel.symbolRemoved(symbolID);
        }
    }

    void symbolAdded(Symbol sym) {
        if (this.isVisible()) {
            this.referenceKeyModel.symbolAdded(sym);
        }
    }

    void setProgram(Program program, SymbolInspector inspector) {
        this.renderer.setSymbolInspector(inspector);
        if (this.isVisible()) {
            this.referenceKeyModel.setProgram(program);
        }
    }

    void reload() {
        if (this.isVisible()) {
            this.referenceKeyModel.reload();
        }
    }

    void showReferencesTo() {
        this.referenceKeyModel.showReferencesTo();
    }

    void showInstructionsFrom() {
        this.referenceKeyModel.showInstructionReferencesFrom();
    }

    void showDataFrom() {
        this.referenceKeyModel.showDataReferencesFrom();
    }

    public GhidraTable getTable() {
        return this.referencePanel.getTable();
    }

    private String generateSubTitle() {
        return "(" + this.referenceKeyModel.getDescription() + ")";
    }

    void open() {
        this.setVisible(true);
    }

    public void componentHidden() {
        this.referenceKeyModel.setProgram(null);
    }

    public void componentShown() {
        this.referenceKeyModel.setProgram(this.plugin.getProgram());
        Swing.runLater(this.plugin::openSymbolProvider);
    }

    public JComponent getComponent() {
        return this.referencePanel;
    }

    public void updateTitle() {
        this.setSubTitle(this.generateSubTitle());
    }
}

