/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin;

import ghidra.util.Msg;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class GhidraRandomAccessFile {
    private static final byte[] EMPTY = new byte[0];
    private static final int BUFFER_SIZE = 0x100000;
    private File file;
    private RandomAccessFile randomAccessFile;
    private byte[] buffer = EMPTY;
    private long bufferOffset = 0L;
    private long bufferFileStartIndex = 0L;
    private byte[] lastbuffer = EMPTY;
    private long lastbufferOffset = 0L;
    private long lastbufferFileStartIndex = 0L;
    private boolean open = false;

    private void checkOpen() throws IOException {
        if (!this.open) {
            throw new IOException("GhidraRandomAccessFile is closed");
        }
    }

    public GhidraRandomAccessFile(File file, String mode) throws IOException {
        this.file = file;
        this.randomAccessFile = new RandomAccessFile(file, mode);
        this.open = true;
    }

    protected void finalize() {
        if (this.open) {
            Msg.warn((Object)this, (Object)("FAIL TO CLOSE " + this.file));
        }
    }

    public void close() throws IOException {
        this.checkOpen();
        this.open = false;
        this.randomAccessFile.close();
        this.buffer = EMPTY;
        this.lastbuffer = EMPTY;
    }

    public long length() throws IOException {
        this.checkOpen();
        return this.randomAccessFile.length();
    }

    public void seek(long pos) throws IOException {
        this.checkOpen();
        if (pos < 0L) {
            throw new IOException("pos cannot be less than zero");
        }
        if (pos < this.bufferFileStartIndex || pos >= this.bufferFileStartIndex + 0x100000L) {
            this.swapInLast();
            if (pos < this.bufferFileStartIndex || pos >= this.bufferFileStartIndex + 0x100000L) {
                this.buffer = EMPTY;
                this.bufferOffset = 0L;
                this.bufferFileStartIndex = pos;
            }
        }
        this.bufferOffset = pos - this.bufferFileStartIndex;
    }

    public byte readByte() throws IOException {
        this.checkOpen();
        this.ensure(1);
        return this.buffer[(int)this.bufferOffset];
    }

    public int read(byte[] b) throws IOException {
        this.checkOpen();
        return this.read(b, 0, b.length);
    }

    public int read(byte[] b, int offset, int length) throws IOException {
        this.checkOpen();
        int readLen = length;
        do {
            int blocklength = readLen;
            if ((long)readLen > 0x100000L - this.bufferOffset && (blocklength = 0x100000 - (int)this.bufferOffset) <= 0) {
                blocklength = 0x100000;
            }
            this.ensure(blocklength);
            System.arraycopy(this.buffer, (int)this.bufferOffset, b, offset, blocklength);
            offset += blocklength;
            if ((readLen -= blocklength) <= 0) continue;
            this.seek(this.bufferFileStartIndex + this.bufferOffset + (long)blocklength);
        } while (readLen > 0);
        return length;
    }

    public void write(byte b) throws IOException {
        this.checkOpen();
        this.write(new byte[]{b}, 0, 1);
    }

    public void write(byte[] b) throws IOException {
        this.checkOpen();
        this.write(b, 0, b.length);
    }

    public void write(byte[] b, int offset, int length) throws IOException {
        this.checkOpen();
        this.randomAccessFile.write(b, offset, length);
        this.buffer = EMPTY;
        this.bufferOffset = 0L;
        this.lastbuffer = EMPTY;
        this.lastbufferOffset = 0L;
    }

    private void ensure(int bytesNeeded) throws IOException {
        this.checkOpen();
        long oldFileStartIndex = this.bufferFileStartIndex;
        long oldBufferOffset = this.bufferOffset;
        long oldSeekPos = oldFileStartIndex + oldBufferOffset;
        if (this.bufferOffset + (long)bytesNeeded > (long)this.buffer.length) {
            this.swapInLast();
            long newBufferOffset = oldSeekPos - this.bufferFileStartIndex;
            if (oldSeekPos < this.bufferFileStartIndex || oldSeekPos >= this.bufferFileStartIndex + 0x100000L || newBufferOffset + (long)bytesNeeded > (long)this.buffer.length) {
                this.bufferFileStartIndex = oldFileStartIndex + oldBufferOffset;
                this.buffer = new byte[0x100000];
                this.randomAccessFile.seek(this.bufferFileStartIndex);
                this.randomAccessFile.read(this.buffer);
                this.bufferOffset = 0L;
            } else {
                this.bufferOffset = newBufferOffset;
            }
        }
    }

    private void swapInLast() throws IOException {
        this.checkOpen();
        if (this.buffer == EMPTY) {
            return;
        }
        byte[] swapbuffer = this.buffer;
        long swapbufferOffset = this.bufferOffset;
        long swapbufferFileStartIndex = this.bufferFileStartIndex;
        this.buffer = this.lastbuffer;
        this.bufferOffset = this.lastbufferOffset;
        this.bufferFileStartIndex = this.lastbufferFileStartIndex;
        this.lastbuffer = swapbuffer;
        this.lastbufferOffset = swapbufferOffset;
        this.lastbufferFileStartIndex = swapbufferFileStartIndex;
    }
}

