/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.bin.format.pe.resource;

import ghidra.app.util.bin.StructConverter;
import ghidra.app.util.bin.format.FactoryBundledWithBinaryReader;
import ghidra.app.util.bin.format.pe.NTHeader;
import ghidra.app.util.bin.format.pe.ResourceDataDirectory;
import ghidra.app.util.bin.format.pe.resource.ResourceDirectoryEntry;
import ghidra.program.model.data.CategoryPath;
import ghidra.program.model.data.DataType;
import ghidra.program.model.data.StructureDataType;
import ghidra.util.Msg;
import ghidra.util.exception.DuplicateNameException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ResourceDirectory
implements StructConverter {
    public static final String NAME = "IMAGE_RESOURCE_DIRECTORY";
    public static final int SIZEOF = 16;
    private int characteristics;
    private int timeDataStamp;
    private short majorVersion;
    private short minorVersion;
    private short numberOfNamedEntries;
    private short numberOfIdEntries;
    private ArrayList<ResourceDirectoryEntry> entries = new ArrayList();

    public ResourceDirectory(FactoryBundledWithBinaryReader reader, int index, int resourceBase, boolean isFirstLevel, NTHeader ntHeader) throws IOException {
        ResourceDirectoryEntry entry;
        int i;
        if (!ntHeader.checkPointer(index)) {
            Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(index)));
            return;
        }
        if (ResourceDataDirectory.directoryMap.contains(index)) {
            Msg.error((Object)this, (Object)("Duplicate ResourceDirectory at " + index + " ignored."));
            return;
        }
        ResourceDataDirectory.directoryMap.add(index);
        this.characteristics = reader.readInt(index);
        this.timeDataStamp = reader.readInt(index += 4);
        this.majorVersion = reader.readShort(index += 4);
        this.minorVersion = reader.readShort(index += 2);
        this.numberOfNamedEntries = reader.readShort(index += 2);
        this.numberOfIdEntries = reader.readShort(index += 2);
        long rva = (index += 2) + (this.numberOfNamedEntries + this.numberOfIdEntries) * 8;
        if (!ntHeader.checkRVA(rva) || 0L > rva || rva > reader.length()) {
            Msg.error((Object)this, (Object)("Too many resource entries " + Integer.toHexString(this.numberOfNamedEntries + this.numberOfIdEntries)));
            this.numberOfIdEntries = 0;
            this.numberOfNamedEntries = 0;
        }
        for (i = 0; i < this.numberOfNamedEntries; ++i) {
            if (!ntHeader.checkPointer(index)) {
                Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(index)));
                return;
            }
            entry = new ResourceDirectoryEntry(reader, index, resourceBase, true, isFirstLevel, ntHeader);
            if (!entry.isValid()) {
                return;
            }
            this.entries.add(entry);
            index += 8;
        }
        for (i = 0; i < this.numberOfIdEntries; ++i) {
            if (!ntHeader.checkPointer(index)) {
                Msg.error((Object)this, (Object)("Invalid file index " + Integer.toHexString(index)));
                return;
            }
            entry = new ResourceDirectoryEntry(reader, index, resourceBase, false, isFirstLevel, ntHeader);
            if (!entry.isValid()) {
                return;
            }
            this.entries.add(entry);
            index += 8;
        }
    }

    public List<ResourceDirectoryEntry> getEntries() {
        return new ArrayList<ResourceDirectoryEntry>(this.entries);
    }

    public int getCharacteristics() {
        return this.characteristics;
    }

    public int getTimeDataStamp() {
        return this.timeDataStamp;
    }

    public int getNumberOfNamedEntries() {
        return this.numberOfNamedEntries;
    }

    public int getNumberOfIdEntries() {
        return this.numberOfIdEntries;
    }

    public short getMajorVersion() {
        return this.majorVersion;
    }

    public short getMinorVersion() {
        return this.minorVersion;
    }

    @Override
    public DataType toDataType() throws DuplicateNameException, IOException {
        StructureDataType struct = new StructureDataType(NAME, 0);
        struct.add(DWORD, "Characteristics", null);
        struct.add(DWORD, "TimeDateStamp", null);
        struct.add(WORD, "MajorVersion", null);
        struct.add(WORD, "MinorVersion", null);
        struct.add(WORD, "NumberOfNamedEntries", null);
        struct.add(WORD, "NumberOfIdEntries", null);
        struct.setCategoryPath(new CategoryPath("/PE"));
        return struct;
    }
}

