/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.util.opinion;

import docking.DialogComponentProvider;
import docking.widgets.filechooser.GhidraFileChooserMode;
import docking.widgets.pathmanager.PathnameTablePanel;
import ghidra.app.util.importer.LibrarySearchPathManager;
import javax.swing.JComponent;

public class LibraryPathsDialog
extends DialogComponentProvider {
    private PathnameTablePanel tablePanel;

    public LibraryPathsDialog() {
        super("Edit Library Paths");
        this.addWorkPanel(this.buildWorkPanel());
        this.addOKButton();
        this.addCancelButton();
        this.setPreferredSize(600, 400);
        this.setRememberSize(false);
    }

    private JComponent buildWorkPanel() {
        String[] libraryPaths = LibrarySearchPathManager.getLibraryPaths();
        this.tablePanel = new PathnameTablePanel(libraryPaths, false, true, () -> this.reset());
        this.tablePanel.setFileChooserProperties("Select Directory", "LibrarySearchDirectory", GhidraFileChooserMode.DIRECTORIES_ONLY, false, null);
        return this.tablePanel;
    }

    private void reset() {
        LibrarySearchPathManager.reset();
        this.tablePanel.setPaths(LibrarySearchPathManager.getLibraryPaths());
    }

    protected void okCallback() {
        String[] paths = this.tablePanel.getPaths();
        LibrarySearchPathManager.setLibraryPaths(paths);
        this.close();
    }
}

