/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jackrabbit.core.data;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.WeakReference;
import java.security.DigestOutputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import org.apache.commons.io.IOUtils;
import org.apache.jackrabbit.core.data.DataIdentifier;
import org.apache.jackrabbit.core.data.DataRecord;
import org.apache.jackrabbit.core.data.DataStore;
import org.apache.jackrabbit.core.data.DataStoreException;
import org.apache.jackrabbit.core.data.FileDataRecord;

public class FileDataStore
implements DataStore {
    private static final String DIGEST = "SHA-1";
    private static final int DEFAULT_MIN_RECORD_LENGTH = 100;
    private static final int ACCESS_TIME_RESOLUTION = 2000;
    private static final String TMP = "tmp";
    private long minModifiedDate;
    private File directory;
    private String path;
    private int minRecordLength = 100;
    protected Map inUse = Collections.synchronizedMap(new WeakHashMap());

    public void init(String homeDir) {
        if (this.path == null) {
            this.path = homeDir + "/repository/datastore";
        }
        this.directory = new File(this.path);
        this.directory.mkdirs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord getRecord(DataIdentifier identifier) {
        File file = this.getFile(identifier);
        FileDataStore fileDataStore = this;
        synchronized (fileDataStore) {
            if (this.minModifiedDate != 0L && file.exists() && file.canWrite() && file.lastModified() < this.minModifiedDate) {
                file.setLastModified(System.currentTimeMillis() + 2000L);
            }
            this.usesIdentifier(identifier);
        }
        return new FileDataRecord(identifier, file);
    }

    private void usesIdentifier(DataIdentifier identifier) {
        this.inUse.put(identifier, new WeakReference<DataIdentifier>(identifier));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataRecord addRecord(InputStream input) throws DataStoreException {
        File temporary = null;
        try {
            File file;
            temporary = this.newTemporaryFile();
            DataIdentifier tempId = new DataIdentifier(temporary.getName());
            this.usesIdentifier(tempId);
            long length = 0L;
            MessageDigest digest = MessageDigest.getInstance(DIGEST);
            DigestOutputStream output = new DigestOutputStream(new FileOutputStream(temporary), digest);
            try {
                length = IOUtils.copyLarge((InputStream)input, (OutputStream)output);
            }
            finally {
                ((OutputStream)output).close();
            }
            DataIdentifier identifier = new DataIdentifier(digest.digest());
            Object object = this;
            synchronized (object) {
                this.usesIdentifier(identifier);
                file = this.getFile(identifier);
                File parent = file.getParentFile();
                if (!parent.isDirectory()) {
                    parent.mkdirs();
                }
                if (!file.exists()) {
                    temporary.renameTo(file);
                    if (!file.exists()) {
                        throw new IOException("Can not rename " + temporary.getAbsolutePath() + " to " + file.getAbsolutePath() + " (media read only?)");
                    }
                } else {
                    long now = System.currentTimeMillis();
                    if (file.lastModified() < now) {
                        file.setLastModified(now);
                    }
                }
                if (!file.isFile()) {
                    throw new IOException("Not a file: " + file);
                }
                if (file.length() != length) {
                    throw new IOException("SHA-1 collision: " + file);
                }
            }
            this.inUse.remove(tempId);
            object = new FileDataRecord(identifier, file);
            return object;
        }
        catch (NoSuchAlgorithmException e) {
            throw new DataStoreException("SHA-1 not available", e);
        }
        catch (IOException e) {
            throw new DataStoreException("Could not add record", e);
        }
        finally {
            if (temporary != null) {
                temporary.delete();
            }
        }
    }

    private File getFile(DataIdentifier identifier) {
        this.usesIdentifier(identifier);
        String string = identifier.toString();
        File file = this.directory;
        file = new File(file, string.substring(0, 2));
        file = new File(file, string.substring(2, 4));
        file = new File(file, string.substring(4, 6));
        return new File(file, string);
    }

    private File newTemporaryFile() throws IOException {
        if (!this.directory.isDirectory()) {
            this.directory.mkdirs();
        }
        return File.createTempFile(TMP, null, this.directory);
    }

    public void updateModifiedDateOnAccess(long before) {
        this.minModifiedDate = before;
    }

    public int deleteAllOlderThan(long min) {
        return this.deleteOlderRecursive(this.directory, min);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int deleteOlderRecursive(File file, long min) {
        int count = 0;
        if (file.isFile() && file.exists() && file.canWrite()) {
            FileDataStore fileDataStore = this;
            synchronized (fileDataStore) {
                DataIdentifier id;
                String fileName = file.getName();
                if (file.lastModified() < min && !this.inUse.containsKey(id = new DataIdentifier(fileName))) {
                    file.delete();
                    ++count;
                }
            }
        }
        if (file.isDirectory()) {
            File[] list = file.listFiles();
            for (int i = 0; i < list.length; ++i) {
                count += this.deleteOlderRecursive(list[i], min);
            }
            FileDataStore fileDataStore = this;
            synchronized (fileDataStore) {
                if (file != this.directory && file.list().length == 0) {
                    file.delete();
                }
            }
        }
        return count;
    }

    private void listRecursive(List list, File file) {
        File[] l = file.listFiles();
        for (int i = 0; l != null && i < l.length; ++i) {
            File f = l[i];
            if (f.isDirectory()) {
                this.listRecursive(list, f);
                continue;
            }
            list.add(f);
        }
    }

    public Iterator getAllIdentifiers() {
        ArrayList files = new ArrayList();
        this.listRecursive(files, this.directory);
        ArrayList<DataIdentifier> identifiers = new ArrayList<DataIdentifier>();
        for (int i = 0; i < files.size(); ++i) {
            File f = (File)files.get(i);
            String name = f.getName();
            if (name.startsWith(TMP)) continue;
            DataIdentifier id = new DataIdentifier(name);
            identifiers.add(id);
        }
        return identifiers.iterator();
    }

    public void clearInUse() {
        this.inUse.clear();
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String directoryName) {
        this.path = directoryName;
    }

    public int getMinRecordLength() {
        return this.minRecordLength;
    }

    public void setMinRecordLength(int minRecordLength) {
        this.minRecordLength = minRecordLength;
    }

    public void close() {
    }
}

