/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.store.AbstractJETAPersistable;
import com.jeta.forms.store.JETAObjectInput;
import com.jeta.forms.store.JETAObjectOutput;
import com.jgoodies.forms.layout.CellConstraints;
import java.awt.Insets;
import java.io.IOException;

public class CellConstraintsMemento
extends AbstractJETAPersistable {
    static final long serialVersionUID = 7894081609390290274L;
    public static final int VERSION = 1;
    private int m_column;
    private int m_row;
    private int m_colspan;
    private int m_rowspan;
    private Insets m_insets;
    private String m_valign;
    private String m_halign;

    public CellConstraintsMemento() {
    }

    public CellConstraintsMemento(CellConstraints cellConstraints) {
        this.m_column = cellConstraints.gridX;
        this.m_row = cellConstraints.gridY;
        this.m_colspan = cellConstraints.gridWidth;
        this.m_rowspan = cellConstraints.gridHeight;
        this.m_halign = cellConstraints.hAlign.toString();
        this.m_valign = cellConstraints.vAlign.toString();
        this.m_insets = cellConstraints.insets;
    }

    public CellConstraints createCellConstraints() {
        try {
            return new CellConstraints(this.m_column, this.m_row, this.m_colspan, this.m_rowspan, FormUtils.toAlignment(this.m_halign), FormUtils.toAlignment(this.m_valign), this.m_insets);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return new CellConstraints();
        }
    }

    public int getRow() {
        return this.m_row;
    }

    public int getColumn() {
        return this.m_column;
    }

    public void read(JETAObjectInput jETAObjectInput) throws ClassNotFoundException, IOException {
        int n = jETAObjectInput.readVersion();
        this.m_column = jETAObjectInput.readInt("column");
        this.m_row = jETAObjectInput.readInt("row");
        this.m_colspan = jETAObjectInput.readInt("colspan");
        this.m_rowspan = jETAObjectInput.readInt("rowspan");
        this.m_halign = (String)jETAObjectInput.readObject("halign");
        this.m_valign = (String)jETAObjectInput.readObject("valign");
        this.m_insets = (Insets)jETAObjectInput.readObject("insets");
    }

    public void write(JETAObjectOutput jETAObjectOutput) throws IOException {
        jETAObjectOutput.writeVersion(1);
        jETAObjectOutput.writeInt("column", this.m_column);
        jETAObjectOutput.writeInt("row", this.m_row);
        jETAObjectOutput.writeInt("colspan", this.m_colspan);
        jETAObjectOutput.writeInt("rowspan", this.m_rowspan);
        jETAObjectOutput.writeObject("halign", this.m_halign);
        jETAObjectOutput.writeObject("valign", this.m_valign);
        jETAObjectOutput.writeObject("insets", this.m_insets);
    }
}

