/*
 * Decompiled with CFR 0.152.
 */
package util.demangler;

import java.util.regex.Matcher;
import util.demangler.GenericDemangledDataType;
import util.demangler.GenericDemangledVariable;

public class GenericDemangledArray
extends GenericDemangledDataType {
    private String dataType;

    public GenericDemangledArray(String name) {
        super(name);
        this.setArray();
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String getDataType() {
        return this.dataType;
    }

    @Override
    public void copyInto(GenericDemangledVariable destination) {
        super.copyInto(destination);
        if (this.dataType != null) {
            GenericDemangledDataType dt = new GenericDemangledDataType(this.dataType);
            destination.setDatatype(dt);
        }
    }

    @Override
    public String toSignature() {
        Matcher matcher;
        StringBuffer buffer = new StringBuffer();
        if (this.isUnion) {
            buffer.append("union").append(' ');
        }
        if (this.isStruct) {
            buffer.append("struct").append(' ');
        }
        if (this.isEnum) {
            buffer.append("enum").append(' ');
        }
        if (this.isClass) {
            buffer.append("class").append(' ');
        }
        if (this.isComplex) {
            buffer.append("complex").append(' ');
        }
        if (this.isVolatile) {
            buffer.append("volatile").append(' ');
        }
        if (this.isSigned) {
            buffer.append("signed").append(' ');
        }
        if (this.isUnsigned) {
            buffer.append("unsigned").append(' ');
        }
        String space = "";
        if (this.dataType != null) {
            buffer.append(space).append(this.dataType);
            space = String.valueOf(' ');
        }
        if (this.isConst()) {
            buffer.append(space).append("const");
            space = String.valueOf(' ');
        }
        if (this.getNamespace() != null) {
            buffer.append(this.getNamespace().toNamespace());
        }
        if (this.getName() != null) {
            buffer.append(this.getName());
            space = String.valueOf(' ');
        }
        if (this.getTemplate() != null) {
            buffer.append(this.getTemplate().toTemplate());
            space = String.valueOf(' ');
        }
        if (this.isUnaligned) {
            buffer.append(space).append("__unaligned");
            space = String.valueOf(' ');
        }
        if (this.isFar) {
            buffer.append(space).append("far");
            space = String.valueOf(' ');
        }
        if (this.isRestrict) {
            buffer.append(space).append("restrict");
            space = String.valueOf(' ');
        }
        this.handlePointer(buffer, space);
        if (this.isReference) {
            boolean hasPointers;
            boolean bl = hasPointers = this.pointerLevels >= 1;
            if (this.isConst() && hasPointers) {
                buffer.append(space).append("const");
                space = String.valueOf(' ');
            }
            buffer.append(space).append("&");
            space = String.valueOf(' ');
        }
        this.handleTrailingPointer(buffer, space);
        if (this.isArray && !(matcher = ARRAY_SUBSCRIPT_PATTERN.matcher(this.getName())).find()) {
            buffer.append("[]");
        }
        return buffer.toString();
    }

    private void handlePointer(StringBuffer buffer, String space) {
        boolean hasPointers;
        String myName = this.getName();
        if (myName.contains("*")) {
            return;
        }
        boolean bl = hasPointers = this.pointerLevels >= 1;
        if (hasPointers) {
            buffer.append(space + "*");
            space = String.valueOf(' ');
        }
    }

    private void handleTrailingPointer(StringBuffer buffer, String space) {
        if (this.isPointer64) {
            buffer.append(space).append("__ptr64");
            space = String.valueOf(' ');
        }
        for (int i = 1; i < this.pointerLevels; ++i) {
            if (this.isConst()) {
                buffer.append(space).append("const");
                space = String.valueOf(' ');
            }
            buffer.append(space).append("*");
            space = String.valueOf(' ');
            if (!this.isPointer64) continue;
            buffer.append(space).append("__ptr64");
            space = String.valueOf(' ');
        }
    }
}

