/*
 * Decompiled with CFR 0.152.
 */
package help.validator.model;

import help.HelpBuildUtils;
import help.ImageLocation;
import help.validator.location.HelpModuleLocation;
import java.net.URISyntaxException;
import java.nio.file.Path;

public class IMG
implements Comparable<IMG> {
    private HelpModuleLocation help;
    private final Path sourceFile;
    private final Path relativePath;
    private final String imgSrc;
    private final Path imgFile;
    private final ImageLocation imageLocation;
    private final int lineNumber;

    public IMG(HelpModuleLocation help, Path sourceFile, String imgSrc, int lineNumber) throws URISyntaxException {
        this.help = help;
        this.sourceFile = sourceFile;
        this.relativePath = HelpBuildUtils.relativizeWithHelpTopics(sourceFile);
        this.imgSrc = imgSrc;
        this.lineNumber = lineNumber;
        this.imageLocation = HelpBuildUtils.locateImageReference(sourceFile, imgSrc);
        this.imgFile = this.imageLocation.getResolvedPath();
    }

    public Path getSourceFile() {
        return this.sourceFile;
    }

    public String getSrcAttribute() {
        return this.imgSrc;
    }

    public boolean isRemote() {
        return this.imageLocation.isRemote();
    }

    public boolean isRuntime() {
        return this.imageLocation.isRuntime();
    }

    public boolean isInvalid() {
        return this.imageLocation.isInvalidRuntimeImage();
    }

    public Path getImageFile() {
        return this.imgFile;
    }

    public Path getHelpPath() {
        return this.imgFile;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    @Override
    public int compareTo(IMG other) {
        HelpModuleLocation otherHelp = other.help;
        Path otherHelpLoc = otherHelp.getHelpLocation();
        Path myHelpLoc = this.help.getHelpLocation();
        if (!myHelpLoc.equals(otherHelpLoc)) {
            return myHelpLoc.compareTo(otherHelpLoc);
        }
        Path otherSourceFile = other.getSourceFile();
        if (!this.sourceFile.equals(otherSourceFile)) {
            return this.sourceFile.toUri().compareTo(otherSourceFile.toUri());
        }
        if (this.lineNumber != other.lineNumber) {
            return this.lineNumber - other.lineNumber;
        }
        Path myHelpPath = this.getHelpPath();
        Path otherHelpPath = other.getHelpPath();
        if (myHelpPath != null && otherHelpPath != null) {
            int result = myHelpPath.compareTo(otherHelpPath);
            if (result != 0) {
                return result;
            }
        } else {
            if (myHelpPath == null && otherHelpPath != null) {
                return -1;
            }
            if (myHelpPath != null && otherHelpPath == null) {
                return 1;
            }
        }
        int identityHashCode = System.identityHashCode(this);
        int otherIdentityHashCode = System.identityHashCode(other);
        return identityHashCode - otherIdentityHashCode;
    }

    public String toString() {
        return "<img src=\"" + this.imgSrc + "\">  [\n\t\tFrom: " + this.relativePath + ",\n\t\tResolved: " + this.imgFile + "\n\t]";
    }
}

