/*
 * Decompiled with CFR 0.152.
 */
package ghidra.app.plugin.processors.sleigh.symbol;

import ghidra.app.plugin.processors.sleigh.FixedHandle;
import ghidra.app.plugin.processors.sleigh.ParserWalker;
import ghidra.app.plugin.processors.sleigh.SleighLanguage;
import ghidra.app.plugin.processors.sleigh.expression.PatternExpression;
import ghidra.app.plugin.processors.sleigh.expression.PatternValue;
import ghidra.app.plugin.processors.sleigh.symbol.FamilySymbol;
import ghidra.program.model.mem.MemoryAccessException;
import ghidra.xml.XmlElement;
import ghidra.xml.XmlPullParser;
import java.util.ArrayList;

public class ValueSymbol
extends FamilySymbol {
    protected PatternValue patval;

    @Override
    public PatternValue getPatternValue() {
        return this.patval;
    }

    @Override
    public PatternExpression getPatternExpression() {
        return this.patval;
    }

    @Override
    public void getFixedHandle(FixedHandle hand, ParserWalker walker) throws MemoryAccessException {
        hand.space = walker.getConstSpace();
        hand.offset_space = null;
        hand.offset_offset = this.patval.getValue(walker);
        hand.size = 0;
    }

    @Override
    public String print(ParserWalker walker) throws MemoryAccessException {
        long val = this.patval.getValue(walker);
        String res = val >= 0L ? "0x" + Long.toHexString(val) : "-0x" + Long.toHexString(-val);
        return res;
    }

    @Override
    public void printList(ParserWalker walker, ArrayList<Object> list) throws MemoryAccessException {
        list.add(walker.getParentHandle());
    }

    @Override
    public void restoreXml(XmlPullParser parser, SleighLanguage sleigh) {
        XmlElement el = parser.start(new String[]{"value_sym"});
        this.patval = (PatternValue)PatternExpression.restoreExpression(parser, sleigh);
        parser.end(el);
    }
}

