/*
 * Decompiled with CFR 0.152.
 */
package ghidra.program.model.data;

import docking.dnd.GenericDataFlavor;
import ghidra.program.model.data.DataType;
import ghidra.util.Msg;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.ClipboardOwner;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class DataTypeTransferable
implements Transferable,
ClipboardOwner {
    public static final DataFlavor localDataTypeFlavor = DataTypeTransferable.createLocalDataTypeFlavor();
    public static final DataFlavor localBuiltinDataTypeFlavor = DataTypeTransferable.createLocalBuiltinDataTypeFlavor();
    private static DataFlavor[] flavors = new DataFlavor[]{localDataTypeFlavor, localBuiltinDataTypeFlavor};
    private static List<DataFlavor> flavorList = Arrays.asList(flavors);
    private DataType dataType;

    private static DataFlavor createLocalDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=ghidra.program.model.data.DataTypeImpl", "Local data type object");
        }
        catch (Exception e) {
            Msg.showError(DataTypeTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    private static DataFlavor createLocalBuiltinDataTypeFlavor() {
        try {
            return new GenericDataFlavor("application/x-java-jvm-local-objectref; class=ghidra.program.model.data.DataTypeImpl", "Local BuiltIn data type object");
        }
        catch (Exception e) {
            Msg.showError(DataTypeTransferable.class, null, null, null, (Throwable)e);
            return null;
        }
    }

    public DataTypeTransferable(DataType dt) {
        this.dataType = dt;
    }

    @Override
    public synchronized DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor f) {
        return flavorList.contains(f);
    }

    @Override
    public synchronized Object getTransferData(DataFlavor f) throws UnsupportedFlavorException, IOException {
        if (f.equals(localDataTypeFlavor) || f.equals(localBuiltinDataTypeFlavor)) {
            return this.dataType;
        }
        throw new UnsupportedFlavorException(f);
    }

    public String toString() {
        return "DataTypeTransferable";
    }

    @Override
    public void lostOwnership(Clipboard clipboard, Transferable contents) {
    }
}

