/*
 * Decompiled with CFR 0.152.
 */
package ghidra.framework.options;

import ghidra.framework.options.OptionType;
import ghidra.util.HelpLocation;
import ghidra.util.SystemUtilities;
import java.beans.PropertyEditor;

public abstract class Option {
    private final String name;
    private final Object defaultValue;
    private boolean isRegistered;
    private final String description;
    private final HelpLocation helpLocation;
    private final OptionType optionType;
    private final PropertyEditor propertyEditor;
    private String inceptionInformation;

    protected Option(String name, OptionType optionType, String description, HelpLocation helpLocation, Object defaultValue, boolean isRegistered, PropertyEditor editor) {
        this.name = name;
        this.optionType = optionType;
        this.description = description;
        this.helpLocation = helpLocation;
        this.defaultValue = defaultValue;
        this.isRegistered = isRegistered;
        this.propertyEditor = editor;
        if (!isRegistered) {
            this.recordInception();
        }
    }

    public abstract Object getCurrentValue();

    public abstract void doSetCurrentValue(Object var1);

    public void setCurrentValue(Object value) {
        this.isRegistered = true;
        this.doSetCurrentValue(value);
    }

    public String getName() {
        return this.name;
    }

    public PropertyEditor getPropertyEditor() {
        return this.propertyEditor;
    }

    public HelpLocation getHelpLocation() {
        return this.helpLocation;
    }

    public boolean hasValue() {
        return this.defaultValue != null || this.getCurrentValue() != null;
    }

    public String getDescription() {
        return this.description == null ? "Unregistered Option" : this.description;
    }

    public Object getValue(Object passedInDefaultValue) {
        Object value = this.getCurrentValue();
        if (value != null) {
            return value;
        }
        if (this.defaultValue != null) {
            return this.defaultValue;
        }
        return passedInDefaultValue;
    }

    public boolean isRegistered() {
        return this.isRegistered;
    }

    public void restoreDefault() {
        this.setCurrentValue(this.defaultValue);
    }

    public boolean isDefault() {
        Object value = this.getCurrentValue();
        if (value == null) {
            return true;
        }
        return value.equals(this.defaultValue);
    }

    public String toString() {
        return "[current value=" + this.getCurrentValue() + ", default value=" + this.defaultValue + ", isRegistered=" + this.isRegistered + "]";
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public String getInceptionInformation() {
        return this.inceptionInformation;
    }

    private void recordInception() {
        String information;
        if (!SystemUtilities.isInDevelopmentMode()) {
            return;
        }
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTrace = throwable.getStackTrace();
        this.inceptionInformation = information = this.getInceptionInformationFromTheFirstClassThatIsNotUs(stackTrace);
    }

    private String getInceptionInformationFromTheFirstClassThatIsNotUs(StackTraceElement[] stackTrace) {
        String myClassName = this.getClass().getName();
        int myClassNameStartIndex = -1;
        for (int i = 1; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (!myClassName.equals(elementClassName)) continue;
            myClassNameStartIndex = i;
            break;
        }
        int creatorIndex = myClassNameStartIndex;
        for (int i = myClassNameStartIndex; i < stackTrace.length; ++i) {
            StackTraceElement stackTraceElement = stackTrace[i];
            String elementClassName = stackTraceElement.getClassName();
            if (elementClassName.toLowerCase().indexOf("option") != -1) continue;
            creatorIndex = i;
            break;
        }
        return stackTrace[creatorIndex].toString();
    }

    public OptionType getOptionType() {
        return this.optionType;
    }
}

