/*
 * Decompiled with CFR 0.152.
 */
package ghidra.util.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;

public class TwoColumnPairLayout
implements LayoutManager {
    private int verticalGap;
    private int columnGap;
    private int pairGap;
    private int preferredColumnWidth;

    public TwoColumnPairLayout() {
        this(0, 0, 0, 0);
    }

    public TwoColumnPairLayout(int verticalGap, int columnGap, int pairGap, int preferredValueColumnWidth) {
        this.verticalGap = verticalGap;
        this.columnGap = columnGap;
        this.pairGap = pairGap;
        this.preferredColumnWidth = preferredValueColumnWidth;
    }

    @Override
    public void addLayoutComponent(String name, Component comp) {
    }

    @Override
    public void removeLayoutComponent(Component comp) {
    }

    @Override
    public Dimension preferredLayoutSize(Container parent) {
        int rowHeight = this.getPreferredRowHeight(parent);
        int[] widths = this.getPreferredWidths(parent);
        int nRows = (parent.getComponentCount() + 3) / 4;
        Insets insets = parent.getInsets();
        Dimension d = new Dimension(0, 0);
        if (this.preferredColumnWidth > 0) {
            widths[1] = widths[3] = this.preferredColumnWidth;
        }
        d.width = widths[0] + widths[1] + widths[2] + widths[3] + this.columnGap + 2 * this.pairGap + insets.left + insets.right;
        d.height = rowHeight * nRows + this.verticalGap * (nRows - 1) + insets.top + insets.bottom;
        return d;
    }

    @Override
    public Dimension minimumLayoutSize(Container parent) {
        return this.preferredLayoutSize(parent);
    }

    @Override
    public void layoutContainer(Container parent) {
        int rowHeight = this.getPreferredRowHeight(parent);
        int[] widths = this.getPreferredWidths(parent);
        Dimension d = parent.getSize();
        Insets insets = parent.getInsets();
        int width = d.width - (insets.left + insets.right);
        int x = insets.left;
        int y = insets.top;
        int totalLabelWidth = widths[0] + widths[2];
        int padding = 2 * this.pairGap + this.columnGap;
        int totalValueWidth = width - totalLabelWidth - padding;
        widths[1] = totalValueWidth * widths[1] / (widths[1] + widths[3]);
        widths[3] = totalValueWidth - widths[1];
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            int index = i % 4;
            Component c = parent.getComponent(i);
            c.setBounds(x, y, widths[index], rowHeight);
            x += widths[index];
            x += index == 1 ? this.columnGap : this.pairGap;
            if (i % 4 != 3) continue;
            y += rowHeight + this.verticalGap;
            x = insets.left;
        }
    }

    int getPreferredRowHeight(Container parent) {
        int height = 0;
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            height = Math.max(height, c.getPreferredSize().height);
        }
        return height;
    }

    int[] getPreferredWidths(Container parent) {
        int[] widths = new int[4];
        int n = parent.getComponentCount();
        for (int i = 0; i < n; ++i) {
            Component c = parent.getComponent(i);
            Dimension d = c.getPreferredSize();
            int index = i % 4;
            widths[index] = Math.max(widths[index], d.width);
        }
        return widths;
    }
}

