/*
 * Decompiled with CFR 0.152.
 */
package docking.widgets.tree.tasks;

import docking.widgets.tree.GTree;
import docking.widgets.tree.GTreeNode;
import docking.widgets.tree.GTreeTask;
import ghidra.util.task.TaskMonitor;
import java.util.List;
import javax.swing.JTree;
import javax.swing.tree.TreePath;

public class GTreeExpandPathsTask
extends GTreeTask {
    private final List<TreePath> paths;
    private final JTree jTree;

    public GTreeExpandPathsTask(GTree gTree, JTree tree, List<TreePath> paths) {
        super(gTree);
        this.jTree = tree;
        this.paths = paths;
    }

    public void run(TaskMonitor monitor) {
        monitor.setMessage("Expanding Paths");
        monitor.initialize((long)this.paths.size());
        for (TreePath path : this.paths) {
            this.ensurePathLoaded(path, monitor);
            this.expandPath(path, monitor);
            monitor.incrementProgress(1L);
        }
    }

    private void ensurePathLoaded(TreePath path, TaskMonitor monitor) {
        GTreeNode parent = this.tree.getRootNode();
        if (parent == null) {
            return;
        }
        List<GTreeNode> allChildren = parent.getAllChildren();
        Object[] nodeList = path.getPath();
        for (int i = 1; i < nodeList.length; ++i) {
            if (monitor.isCancelled()) {
                return;
            }
            GTreeNode node = this.findNode(allChildren, (GTreeNode)nodeList[i]);
            if (node == null) {
                return;
            }
            allChildren = node.getAllChildren();
            parent = node;
        }
    }

    private GTreeNode findNode(List<GTreeNode> children, GTreeNode node) {
        for (GTreeNode childNode : children) {
            if (!childNode.equals(node)) continue;
            return childNode;
        }
        return null;
    }

    private void expandPath(TreePath treePath, TaskMonitor monitor) {
        this.runOnSwingThread(() -> {
            if (monitor.isCancelled()) {
                return;
            }
            TreePath validatedPath = treePath;
            GTreeNode node = (GTreeNode)treePath.getLastPathComponent();
            if (node.isLeaf()) {
                Object[] path = treePath.getPath();
                if (path.length <= 1) {
                    return;
                }
                Object[] newPath = new Object[path.length - 1];
                System.arraycopy(path, 0, newPath, 0, path.length - 1);
                validatedPath = new TreePath(newPath);
            }
            this.jTree.expandPath(validatedPath);
        });
    }
}

