/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.importing.workspaceModel;

import com.intellij.ide.util.projectWizard.importSources.JavaModuleSourceRoot;
import com.intellij.ide.util.projectWizard.importSources.JavaSourceRootDetectionUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ExternalProjectSystemRegistry;
import com.intellij.openapi.roots.ProjectModelExternalSource;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.workspaceModel.ide.impl.JpsEntitySourceFactory;
import com.intellij.workspaceModel.ide.impl.legacyBridge.module.roots.SourceRootPropertiesHelper;
import com.intellij.workspaceModel.storage.EntitySource;
import com.intellij.workspaceModel.storage.MutableEntityStorage;
import com.intellij.workspaceModel.storage.PersistentEntityId;
import com.intellij.workspaceModel.storage.WorkspaceEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.ExtensionsKt;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ContentRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ExternalSystemModuleOptionsEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaResourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.JavaSourceRootEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryRoot;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryRootTypeId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.LibraryTableId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleDependencyItem;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleEntity;
import com.intellij.workspaceModel.storage.bridgeEntities.api.ModuleId;
import com.intellij.workspaceModel.storage.bridgeEntities.api.SourceRootEntity;
import com.intellij.workspaceModel.storage.url.VirtualFileUrl;
import com.intellij.workspaceModel.storage.url.VirtualFileUrlManager;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.importing.MavenFoldersImporter;
import org.jetbrains.idea.maven.importing.MavenModelUtil;
import org.jetbrains.idea.maven.importing.MavenModuleImporter;
import org.jetbrains.idea.maven.importing.workspaceModel.WorkspaceModuleImporter$WhenMappings;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.project.MavenImportingSettings;
import org.jetbrains.idea.maven.project.MavenProject;
import org.jetbrains.idea.maven.project.MavenProjectsTree;
import org.jetbrains.idea.maven.project.SupportedRequestType;
import org.jetbrains.idea.maven.utils.MavenUtil;
import org.jetbrains.idea.maven.utils.Path;
import org.jetbrains.jps.model.java.JavaResourceRootType;
import org.jetbrains.jps.model.java.JavaSourceRootType;
import org.jetbrains.jps.model.module.JpsModuleSourceRootType;
import org.jetbrains.jps.model.serialization.JpsModelSerializerExtension;
import org.jetbrains.jps.model.serialization.module.JpsModuleSourceRootPropertiesSerializer;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u00a6\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u001f\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 D2\u00020\u0001:\u0001DBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\"\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J \u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J \u0010#\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010$\u001a\u00020%2\u0006\u0010&\u001a\u00020\u0018H\u0002J \u0010'\u001a\u00020\u001c2\u0006\u0010(\u001a\u00020\u000e2\u0006\u0010)\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010*\u001a\u00020+2\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0016\u0010,\u001a\b\u0012\u0004\u0012\u00020%0-2\u0006\u0010.\u001a\u00020/H\u0002J \u00100\u001a\u00020\u001c2\u0006\u00101\u001a\u00020\u001e2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\"H\u0002J\u001a\u00102\u001a\u0004\u0018\u00010%2\u0006\u0010&\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002J\u0010\u00103\u001a\u0002042\u0006\u0010&\u001a\u00020\u0018H\u0002J\u0018\u00105\u001a\u00020%2\u0006\u0010&\u001a\u00020\u00182\u0006\u00106\u001a\u00020\u000eH\u0002J\u0018\u00107\u001a\u0002042\u0006\u0010&\u001a\u00020\u00182\u0006\u0010.\u001a\u00020/H\u0002J\u0016\u00108\u001a\u00020\u001c2\f\u00109\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0010\u0010<\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u001e\u0010=\u001a\u00020\u001c2\u0006\u0010>\u001a\u00020?2\f\u0010@\u001a\b\u0012\u0004\u0012\u00020;0:H\u0002J\u0006\u0010A\u001a\u00020?J\u0010\u0010B\u001a\u00020\u001c2\u0006\u0010!\u001a\u00020\"H\u0002J\u0015\u0010C\u001a\u00070\u000e\u00a2\u0006\u0002\b\u00152\u0006\u0010(\u001a\u00020\u000eH\u0002R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0013\u001a\u00070\u0014\u00a2\u0006\u0002\b\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\f\u001a\u001e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e0\rj\u000e\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u000e`\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\u0016\u001a\u00020\u0017*\u00020\u00188BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001a\u00a8\u0006E"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceModuleImporter;", "", "mavenProject", "Lorg/jetbrains/idea/maven/project/MavenProject;", "virtualFileUrlManager", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;", "projectsTree", "Lorg/jetbrains/idea/maven/project/MavenProjectsTree;", "builder", "Lcom/intellij/workspaceModel/storage/MutableEntityStorage;", "importingSettings", "Lorg/jetbrains/idea/maven/project/MavenImportingSettings;", "mavenProjectToModuleName", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "project", "Lcom/intellij/openapi/project/Project;", "(Lorg/jetbrains/idea/maven/project/MavenProject;Lcom/intellij/workspaceModel/storage/url/VirtualFileUrlManager;Lorg/jetbrains/idea/maven/project/MavenProjectsTree;Lcom/intellij/workspaceModel/storage/MutableEntityStorage;Lorg/jetbrains/idea/maven/project/MavenImportingSettings;Ljava/util/HashMap;Lcom/intellij/openapi/project/Project;)V", "externalSource", "Lcom/intellij/openapi/roots/ProjectModelExternalSource;", "Lorg/jetbrains/annotations/NotNull;", "dependencyScope", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleDependencyItem$DependencyScope;", "Lorg/jetbrains/idea/maven/model/MavenArtifact;", "getDependencyScope", "(Lorg/jetbrains/idea/maven/model/MavenArtifact;)Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleDependencyItem$DependencyScope;", "addAllSubDirsAsGeneratedSources", "", "dir", "Ljava/io/File;", "rootType", "Lorg/jetbrains/jps/model/java/JavaSourceRootType;", "contentRootEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ContentRootEntity;", "addAsGeneratedSourceFolder", "addBundleDependency", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleDependencyItem;", "artifact", "addGeneratedJavaSourceFolder", "path", "type", "addLibraryToProjectTable", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryEntity;", "collectDependencies", "", "moduleEntitySource", "Lcom/intellij/workspaceModel/storage/EntitySource;", "configGeneratedSourceFolder", "targetDir", "createDependency", "createLibraryDependency", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleDependencyItem$Exportable$LibraryDependency;", "createModuleDependency", "moduleName", "createSystemDependency", "importExcludedFolders", "excludedFolders", "", "Lcom/intellij/workspaceModel/storage/url/VirtualFileUrl;", "importGeneratedSourceFolders", "importJavaSettings", "moduleEntity", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/ModuleEntity;", "excludedUrls", "importModule", "importSourceFolders", "toAbsolutePath", "Companion", "intellij.maven"})
public final class WorkspaceModuleImporter {
    private final ProjectModelExternalSource externalSource;
    private final MavenProject mavenProject;
    private final VirtualFileUrlManager virtualFileUrlManager;
    private final MavenProjectsTree projectsTree;
    private final MutableEntityStorage builder;
    private final MavenImportingSettings importingSettings;
    private final HashMap<MavenProject, String> mavenProjectToModuleName;
    private final Project project;
    @NotNull
    private static final LibraryRootTypeId JAVADOC_TYPE;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final ModuleEntity importModule() {
        String string;
        CharSequence charSequence;
        CharSequence charSequence2 = this.importingSettings.getDedicatedModuleDir();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            boolean bl = false;
            charSequence = null;
        } else {
            charSequence = charSequence2;
        }
        if ((string = (String)charSequence) == null) {
            string = this.mavenProject.getDirectory();
        }
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"importingSettings.dedica\u2026?: mavenProject.directory");
        String baseModuleDirPath = string;
        EntitySource entitySource = JpsEntitySourceFactory.INSTANCE.createEntitySourceForModule(this.project, this.virtualFileUrlManager.fromPath(baseModuleDirPath), this.externalSource);
        List<ModuleDependencyItem> dependencies = this.collectDependencies(entitySource);
        String moduleName = (String)MapsKt.getValue((Map)this.mavenProjectToModuleName, (Object)this.mavenProject);
        ModuleEntity moduleEntity2 = ExtensionsKt.addModuleEntity((MutableEntityStorage)this.builder, (String)moduleName, dependencies, (EntitySource)entitySource, (String)"JAVA_MODULE");
        ExternalSystemModuleOptionsEntity externalSystemModuleOptionsEntity2 = ExternalSystemModuleOptionsEntity.Companion.invoke(entitySource, (Function1)new Function1<ExternalSystemModuleOptionsEntity.Builder, Unit>(this, moduleEntity2){
            final /* synthetic */ WorkspaceModuleImporter this$0;
            final /* synthetic */ ModuleEntity $moduleEntity;

            public final void invoke(@NotNull ExternalSystemModuleOptionsEntity.Builder $this$invoke) {
                Intrinsics.checkNotNullParameter((Object)$this$invoke, (String)"$receiver");
                $this$invoke.setModule(this.$moduleEntity);
                $this$invoke.setExternalSystem(WorkspaceModuleImporter.access$getExternalSource$p(this.this$0).getId());
            }
            {
                this.this$0 = workspaceModuleImporter;
                this.$moduleEntity = moduleEntity2;
                super(1);
            }
        });
        this.builder.addEntity((WorkspaceEntity)externalSystemModuleOptionsEntity2);
        LinkedHashSet excludedFolders = new LinkedHashSet();
        this.importJavaSettings(moduleEntity2, excludedFolders);
        this.importExcludedFolders(excludedFolders);
        String string2 = this.mavenProject.getDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.directory");
        ContentRootEntity contentRootEntity = ExtensionsKt.addContentRootEntity((MutableEntityStorage)this.builder, (VirtualFileUrl)this.virtualFileUrlManager.fromPath(string2), (List)CollectionsKt.toList((Iterable)excludedFolders), (List)CollectionsKt.emptyList(), (ModuleEntity)moduleEntity2);
        this.importSourceFolders(contentRootEntity);
        return moduleEntity2;
    }

    private final void importExcludedFolders(Collection<VirtualFileUrl> excludedFolders) {
        String string = this.mavenProject.getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.buildDirectory");
        File targetDir = new File(this.toAbsolutePath(string));
        if (this.importingSettings.isExcludeTargetFolder()) {
            String string2 = targetDir.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"targetDir.path");
            excludedFolders.add(this.virtualFileUrlManager.fromPath(string2));
        }
    }

    private final void importJavaSettings(ModuleEntity moduleEntity2, Collection<VirtualFileUrl> excludedUrls) {
        LanguageLevel languageLevel2 = MavenModuleImporter.getLanguageLevel(this.mavenProject);
        Intrinsics.checkNotNullExpressionValue((Object)languageLevel2, (String)"MavenModuleImporter.getLanguageLevel(mavenProject)");
        LanguageLevel languageLevel3 = languageLevel2;
        boolean inheritCompilerOutput = false;
        VirtualFileUrl compilerOutputUrl = null;
        VirtualFileUrl compilerOutputUrlForTests = null;
        String string = this.mavenProject.getOutputDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.outputDirectory");
        String outputPath = this.toAbsolutePath(string);
        String string2 = this.mavenProject.getTestOutputDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.testOutputDirectory");
        String testOutputPath = this.toAbsolutePath(string2);
        if (this.importingSettings.isUseMavenOutput()) {
            inheritCompilerOutput = false;
            compilerOutputUrl = this.virtualFileUrlManager.fromPath(outputPath);
            compilerOutputUrlForTests = this.virtualFileUrlManager.fromPath(testOutputPath);
        } else {
            inheritCompilerOutput = true;
            compilerOutputUrl = null;
            compilerOutputUrlForTests = null;
        }
        boolean excludeOutput = false;
        ExtensionsKt.addJavaModuleSettingsEntity((MutableEntityStorage)this.builder, (boolean)inheritCompilerOutput, (boolean)excludeOutput, (VirtualFileUrl)compilerOutputUrl, (VirtualFileUrl)compilerOutputUrlForTests, (String)languageLevel3.name(), (ModuleEntity)moduleEntity2, (EntitySource)moduleEntity2.getEntitySource());
        String string3 = this.mavenProject.getBuildDirectory();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mavenProject.buildDirectory");
        String buildDirPath = this.toAbsolutePath(string3);
        if (!FileUtil.isAncestor((String)buildDirPath, (String)outputPath, (boolean)false)) {
            excludedUrls.add(this.virtualFileUrlManager.fromPath(outputPath));
        }
        if (!FileUtil.isAncestor((String)buildDirPath, (String)testOutputPath, (boolean)false)) {
            excludedUrls.add(this.virtualFileUrlManager.fromPath(testOutputPath));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final List<ModuleDependencyItem> collectDependencies(EntitySource moduleEntitySource) {
        void $this$mapNotNullTo$iv$iv;
        void $this$mapNotNull$iv;
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        Set<String> set = this.importingSettings.getDependencyTypesAsSet();
        Intrinsics.checkNotNullExpressionValue(set, (String)"importingSettings.dependencyTypesAsSet");
        Set<String> dependencyTypes = set;
        Set<String> set2 = this.mavenProject.getDependencyTypesFromImporters(SupportedRequestType.FOR_IMPORT);
        Intrinsics.checkNotNullExpressionValue(set2, (String)"mavenProject.getDependen\u2026edRequestType.FOR_IMPORT)");
        dependencyTypes.addAll((Collection<String>)set2);
        Collection collection = CollectionsKt.listOf((Object[])new ModuleDependencyItem[]{(ModuleDependencyItem)ModuleDependencyItem.InheritedSdkDependency.INSTANCE, (ModuleDependencyItem)ModuleDependencyItem.ModuleSourceDependency.INSTANCE});
        List<MavenArtifact> list = this.mavenProject.getDependencies();
        Intrinsics.checkNotNullExpressionValue(list, (String)"mavenProject.dependencies");
        Iterable iterable = list;
        Collection collection2 = collection;
        boolean $i$f$filter = false;
        void var5_6 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
            if (!dependencyTypes.contains(mavenArtifact.getType())) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List list2 = (List)destination$iv$iv;
        $this$filter$iv = list2;
        boolean $i$f$mapNotNull = false;
        $this$filterTo$iv$iv = $this$mapNotNull$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            ModuleDependencyItem moduleDependencyItem;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            MavenArtifact it = (MavenArtifact)element$iv$iv;
            boolean bl2 = false;
            MavenArtifact mavenArtifact = it;
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"it");
            if (this.createDependency(mavenArtifact, moduleEntitySource) == null) continue;
            ModuleDependencyItem it$iv$iv = moduleDependencyItem;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        list2 = (List)destination$iv$iv;
        return CollectionsKt.plus((Collection)collection2, (Iterable)list2);
    }

    private final ModuleDependencyItem createDependency(MavenArtifact artifact, EntitySource moduleEntitySource) {
        MavenProject depProject = this.projectsTree.findProject(artifact.getMavenId());
        if (depProject == null) {
            if (Intrinsics.areEqual((Object)artifact.getScope(), (Object)"system")) {
                return (ModuleDependencyItem)this.createSystemDependency(artifact, moduleEntitySource);
            }
            if (Intrinsics.areEqual((Object)artifact.getType(), (Object)"bundle")) {
                return this.addBundleDependency(artifact);
            }
            return (ModuleDependencyItem)this.createLibraryDependency(artifact);
        }
        if (depProject == this.mavenProject) {
            return null;
        }
        String depModuleName = this.mavenProjectToModuleName.get(depProject);
        if (depModuleName == null || this.projectsTree.isIgnored(depProject)) {
            MavenArtifact mavenArtifact = MavenModuleImporter.createCopyForLocalRepo(artifact, this.mavenProject);
            Intrinsics.checkNotNullExpressionValue((Object)mavenArtifact, (String)"MavenModuleImporter.crea\u2026o(artifact, mavenProject)");
            return (ModuleDependencyItem)this.createLibraryDependency(mavenArtifact);
        }
        return this.createModuleDependency(artifact, depModuleName);
    }

    private final ModuleDependencyItem addBundleDependency(MavenArtifact artifact) {
        MavenArtifact newArtifact = new MavenArtifact(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion(), artifact.getBaseVersion(), "jar", artifact.getClassifier(), artifact.getScope(), artifact.isOptional(), "jar", null, this.mavenProject.getLocalRepository(), false, false);
        return (ModuleDependencyItem)this.createLibraryDependency(newArtifact);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createSystemDependency(MavenArtifact artifact, EntitySource moduleEntitySource) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope());
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(this.virtualFileUrlManager.fromUrl(string), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        String string2 = this.mavenProject.getDisplayName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.displayName");
        LibraryTableId.ModuleLibraryTableId libraryTableId = new LibraryTableId.ModuleLibraryTableId(new ModuleId(string2));
        String string3 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"artifact.libraryName");
        ExtensionsKt.addLibraryEntity((MutableEntityStorage)this.builder, (String)string3, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)moduleEntitySource);
        String string4 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"artifact.libraryName");
        return new ModuleDependencyItem.Exportable.LibraryDependency(new LibraryId(string4, (LibraryTableId)libraryTableId), false, this.getDependencyScope(artifact));
    }

    private final ModuleDependencyItem createModuleDependency(MavenArtifact artifact, String moduleName) {
        boolean isTestJar = Intrinsics.areEqual((Object)"test-jar", (Object)artifact.getType()) || Intrinsics.areEqual((Object)"tests", (Object)artifact.getClassifier());
        return (ModuleDependencyItem)new ModuleDependencyItem.Exportable.ModuleDependency(new ModuleId(moduleName), false, this.getDependencyScope(artifact), isTestJar);
    }

    private final ModuleDependencyItem.Exportable.LibraryDependency createLibraryDependency(MavenArtifact artifact) {
        boolean bl = Intrinsics.areEqual((Object)"system", (Object)artifact.getScope()) ^ true;
        if (_Assertions.ENABLED && !bl) {
            String string = "Assertion failed";
            throw new AssertionError((Object)string);
        }
        String string = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"artifact.libraryName");
        LibraryId libraryId = new LibraryId(string, (LibraryTableId)LibraryTableId.ProjectLibraryTableId.INSTANCE);
        if (this.builder.resolve((PersistentEntityId)libraryId) == null) {
            this.addLibraryToProjectTable(artifact);
        }
        return new ModuleDependencyItem.Exportable.LibraryDependency(libraryId, false, this.getDependencyScope(artifact));
    }

    private final LibraryEntity addLibraryToProjectTable(MavenArtifact artifact) {
        ArrayList<LibraryRoot> roots = new ArrayList<LibraryRoot>();
        String string = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, null, null);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenModelUtil.getArtifa\u2026ion(artifact, null, null)");
        roots.add(new LibraryRoot(this.virtualFileUrlManager.fromUrl(string), LibraryRootTypeId.Companion.getCOMPILED(), null, 4, null));
        String string2 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "javadoc", "jar");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"MavenModelUtil.getArtifa\u2026tifact, \"javadoc\", \"jar\")");
        roots.add(new LibraryRoot(this.virtualFileUrlManager.fromUrl(string2), JAVADOC_TYPE, null, 4, null));
        String string3 = MavenModelUtil.getArtifactUrlForClassifierAndExtension(artifact, "sources", "jar");
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"MavenModelUtil.getArtifa\u2026tifact, \"sources\", \"jar\")");
        roots.add(new LibraryRoot(this.virtualFileUrlManager.fromUrl(string3), LibraryRootTypeId.Companion.getSOURCES(), null, 4, null));
        LibraryTableId.ProjectLibraryTableId libraryTableId = LibraryTableId.ProjectLibraryTableId.INSTANCE;
        String string4 = artifact.getLibraryName();
        Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"artifact.libraryName");
        return ExtensionsKt.addLibraryEntity((MutableEntityStorage)this.builder, (String)string4, (LibraryTableId)((LibraryTableId)libraryTableId), (List)roots, (List)CollectionsKt.emptyList(), (EntitySource)JpsEntitySourceFactory.INSTANCE.createEntitySourceForProjectLibrary(this.project, this.externalSource));
    }

    /*
     * WARNING - void declaration
     */
    private final void importSourceFolders(ContentRootEntity contentRootEntity) {
        Map<String, JpsModuleSourceRootType<?>> map2 = MavenFoldersImporter.getSourceFolders(this.mavenProject);
        Intrinsics.checkNotNullExpressionValue(map2, (String)"MavenFoldersImporter.get\u2026urceFolders(mavenProject)");
        Map<String, JpsModuleSourceRootType<?>> $this$forEach$iv = map2;
        boolean $i$f$forEach = false;
        Iterator<Map.Entry<String, JpsModuleSourceRootType<?>>> iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            JpsModuleSourceRootPropertiesSerializer serializer;
            Object v3;
            String $this$firstOrNull$iv;
            String path;
            Map.Entry<String, JpsModuleSourceRootType<?>> entry;
            block6: {
                void $this$flatMapTo$iv$iv;
                Iterable $this$flatMap$iv;
                Map.Entry<String, JpsModuleSourceRootType<?>> element$iv;
                entry = element$iv = iterator.next();
                boolean bl = false;
                path = entry.getKey();
                if (!new File(path).exists()) continue;
                Intrinsics.checkNotNullExpressionValue((Object)JpsModelSerializerExtension.getExtensions(), (String)"JpsModelSerializerExtension.getExtensions()");
                boolean $i$f$flatMap = false;
                Iterator iterator2 = $this$flatMap$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$flatMapTo = false;
                for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                    JpsModelSerializerExtension it = (JpsModelSerializerExtension)element$iv$iv;
                    boolean bl2 = false;
                    JpsModelSerializerExtension jpsModelSerializerExtension = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModelSerializerExtension, (String)"it");
                    Iterable list$iv$iv = jpsModelSerializerExtension.getModuleSourceRootPropertiesSerializers();
                    CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
                }
                $this$flatMap$iv = (List)destination$iv$iv;
                boolean $i$f$firstOrNull = false;
                iterator2 = $this$firstOrNull$iv.iterator();
                while (iterator2.hasNext()) {
                    Object element$iv2 = iterator2.next();
                    JpsModuleSourceRootPropertiesSerializer it = (JpsModuleSourceRootPropertiesSerializer)element$iv2;
                    boolean bl3 = false;
                    JpsModuleSourceRootPropertiesSerializer jpsModuleSourceRootPropertiesSerializer = it;
                    Intrinsics.checkNotNullExpressionValue((Object)jpsModuleSourceRootPropertiesSerializer, (String)"it");
                    if (!Intrinsics.areEqual((Object)((JpsModuleSourceRootType)jpsModuleSourceRootPropertiesSerializer.getType()), entry.getValue())) continue;
                    v3 = element$iv2;
                    break block6;
                }
                v3 = null;
            }
            if ((JpsModuleSourceRootPropertiesSerializer)v3 == null) {
                $this$firstOrNull$iv = "Module source root type " + entry + ".value is not registered as JpsModelSerializerExtension";
                throw new IllegalStateException($this$firstOrNull$iv.toString());
            }
            String string = VfsUtilCore.pathToUrl((String)path);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.pathToUrl(path)");
            VirtualFileUrl virtualFileUrl = this.virtualFileUrlManager.fromUrl(string);
            String string2 = serializer.getTypeId();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"serializer.typeId");
            SourceRootEntity sourceRootEntity = ExtensionsKt.addSourceRootEntity((MutableEntityStorage)this.builder, (ContentRootEntity)contentRootEntity, (VirtualFileUrl)virtualFileUrl, (String)string2, (EntitySource)contentRootEntity.getEntitySource());
            JpsModuleSourceRootType<?> jpsModuleSourceRootType = entry.getValue();
            if (jpsModuleSourceRootType instanceof JavaSourceRootType) {
                ExtensionsKt.addJavaSourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
                continue;
            }
            if (jpsModuleSourceRootType instanceof JavaResourceRootType) {
                ExtensionsKt.addJavaResourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)false, (String)"");
                continue;
            }
            throw new NotImplementedError(null, 1, null);
        }
        this.importGeneratedSourceFolders(contentRootEntity);
    }

    private final void importGeneratedSourceFolders(ContentRootEntity contentRootEntity) {
        File[] targetChildren;
        File targetDir = new File(this.mavenProject.getBuildDirectory());
        String string = this.mavenProject.getGeneratedSourcesDirectory(false);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"mavenProject.getGeneratedSourcesDirectory(false)");
        String generatedDir = string;
        String string2 = this.mavenProject.getGeneratedSourcesDirectory(true);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"mavenProject.getGeneratedSourcesDirectory(true)");
        String generatedDirTest = string2;
        if (this.importingSettings.getGeneratedSourcesFolder() != MavenImportingSettings.GeneratedSourcesFolder.IGNORE) {
            String string3 = this.mavenProject.getAnnotationProcessorDirectory(true);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"mavenProject.getAnnotationProcessorDirectory(true)");
            JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
            this.addGeneratedJavaSourceFolder(string3, javaSourceRootType, contentRootEntity);
            String string4 = this.mavenProject.getAnnotationProcessorDirectory(false);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"mavenProject.getAnnotati\u2026ProcessorDirectory(false)");
            JavaSourceRootType javaSourceRootType2 = JavaSourceRootType.SOURCE;
            Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType2, (String)"JavaSourceRootType.SOURCE");
            this.addGeneratedJavaSourceFolder(string4, javaSourceRootType2, contentRootEntity);
        }
        if ((targetChildren = targetDir.listFiles()) != null) {
            File[] fileArray = targetChildren;
            int n = fileArray.length;
            for (int i = 0; i < n; ++i) {
                File f;
                File file = f = fileArray[i];
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"f");
                if (!file.isDirectory()) continue;
                if (FileUtil.pathsEqual((String)generatedDir, (String)f.getPath())) {
                    JavaSourceRootType javaSourceRootType = JavaSourceRootType.SOURCE;
                    Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.SOURCE");
                    this.configGeneratedSourceFolder(f, javaSourceRootType, contentRootEntity);
                    continue;
                }
                if (!FileUtil.pathsEqual((String)generatedDirTest, (String)f.getPath())) continue;
                JavaSourceRootType javaSourceRootType = JavaSourceRootType.TEST_SOURCE;
                Intrinsics.checkNotNullExpressionValue((Object)javaSourceRootType, (String)"JavaSourceRootType.TEST_SOURCE");
                this.configGeneratedSourceFolder(f, javaSourceRootType, contentRootEntity);
            }
        }
    }

    private final void addGeneratedJavaSourceFolder(String path, JavaSourceRootType type2, ContentRootEntity contentRootEntity) {
        boolean bl;
        VirtualFileUrl url;
        block5: {
            String[] stringArray = new File(path).list();
            if (stringArray == null || stringArray.length == 0) {
                return;
            }
            url = this.virtualFileUrlManager.fromPath(path);
            Iterable $this$any$iv = contentRootEntity.getSourceRoots();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    SourceRootEntity it = (SourceRootEntity)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getUrl(), (Object)url)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            return;
        }
        JpsModuleSourceRootPropertiesSerializer jpsModuleSourceRootPropertiesSerializer = SourceRootPropertiesHelper.INSTANCE.findSerializer((JpsModuleSourceRootType)type2);
        String string = jpsModuleSourceRootPropertiesSerializer != null ? jpsModuleSourceRootPropertiesSerializer.getTypeId() : null;
        Intrinsics.checkNotNull((Object)string);
        SourceRootEntity sourceRootEntity = ExtensionsKt.addSourceRootEntity((MutableEntityStorage)this.builder, (ContentRootEntity)contentRootEntity, (VirtualFileUrl)url, (String)string, (EntitySource)contentRootEntity.getEntitySource());
        ExtensionsKt.addJavaSourceRootEntity((MutableEntityStorage)this.builder, (SourceRootEntity)sourceRootEntity, (boolean)true, (String)"");
    }

    private final void configGeneratedSourceFolder(File targetDir, JavaSourceRootType rootType, ContentRootEntity contentRootEntity) {
        switch (WorkspaceModuleImporter$WhenMappings.$EnumSwitchMapping$0[this.importingSettings.getGeneratedSourcesFolder().ordinal()]) {
            case 1: {
                String string = targetDir.getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetDir.path");
                this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
                break;
            }
            case 2: {
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType, contentRootEntity);
                break;
            }
            case 3: {
                Collection collection = JavaSourceRootDetectionUtil.suggestRoots((File)targetDir);
                Intrinsics.checkNotNullExpressionValue((Object)collection, (String)"JavaSourceRootDetectionU\u2026l.suggestRoots(targetDir)");
                Collection sourceRoots = collection;
                Iterator iterator = sourceRoots.iterator();
                while (iterator.hasNext()) {
                    JavaModuleSourceRoot root;
                    JavaModuleSourceRoot javaModuleSourceRoot = root = (JavaModuleSourceRoot)iterator.next();
                    Intrinsics.checkNotNullExpressionValue((Object)javaModuleSourceRoot, (String)"root");
                    if (FileUtil.filesEqual((File)targetDir, (File)javaModuleSourceRoot.getDirectory())) {
                        String string = targetDir.getPath();
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"targetDir.path");
                        this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
                        return;
                    }
                    File file = root.getDirectory();
                    Intrinsics.checkNotNullExpressionValue((Object)file, (String)"root.directory");
                    this.addAsGeneratedSourceFolder(file, rootType, contentRootEntity);
                }
                this.addAllSubDirsAsGeneratedSources(targetDir, rootType, contentRootEntity);
                break;
            }
            case 4: {
                break;
            }
        }
    }

    private final void addAsGeneratedSourceFolder(File dir2, JavaSourceRootType rootType, ContentRootEntity contentRootEntity) {
        block9: {
            block8: {
                boolean hasRegisteredSubfolder;
                SourceRootEntity folder;
                block7: {
                    boolean bl;
                    Object v1;
                    String url;
                    block6: {
                        Iterable iterable;
                        String string = VfsUtilCore.fileToUrl((File)dir2);
                        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"VfsUtilCore.fileToUrl(dir)");
                        url = string;
                        Iterable iterable2 = iterable = (Iterable)contentRootEntity.getSourceRoots();
                        for (Object object : iterable2) {
                            SourceRootEntity it = (SourceRootEntity)object;
                            boolean bl2 = false;
                            if (!Intrinsics.areEqual((Object)it.getUrl().getUrl(), (Object)url)) continue;
                            v1 = object;
                            break block6;
                        }
                        v1 = null;
                    }
                    folder = v1;
                    Iterable $this$any$iv = contentRootEntity.getSourceRoots();
                    boolean $i$f$any = false;
                    if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                        bl = false;
                    } else {
                        for (Object element$iv : $this$any$iv) {
                            SourceRootEntity it = (SourceRootEntity)element$iv;
                            boolean bl3 = false;
                            if (!VfsUtilCore.isEqualOrAncestor((String)url, (String)it.getUrl().getUrl())) continue;
                            bl = true;
                            break block7;
                        }
                        bl = hasRegisteredSubfolder = false;
                    }
                }
                if (!hasRegisteredSubfolder) break block8;
                if (folder == null) break block9;
                JavaSourceRootEntity javaSourceRootEntity = ExtensionsKt.asJavaSourceRoot((SourceRootEntity)folder);
                if (javaSourceRootEntity != null && javaSourceRootEntity.getGenerated()) break block8;
                JavaResourceRootEntity javaResourceRootEntity = ExtensionsKt.asJavaResourceRoot((SourceRootEntity)folder);
                if (javaResourceRootEntity == null) break block9;
                if (!javaResourceRootEntity.getGenerated()) break block9;
            }
            String string = dir2.getPath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"dir.path");
            this.addGeneratedJavaSourceFolder(string, rootType, contentRootEntity);
        }
    }

    private final void addAllSubDirsAsGeneratedSources(File dir2, JavaSourceRootType rootType, ContentRootEntity contentRootEntity) {
        File[] fileArray = dir2.listFiles();
        if (fileArray != null) {
            File[] $this$forEach$iv = fileArray;
            boolean $i$f$forEach = false;
            int n = $this$forEach$iv.length;
            for (int i = 0; i < n; ++i) {
                File element$iv;
                File f = element$iv = $this$forEach$iv[i];
                boolean bl = false;
                File file = f;
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"f");
                if (!file.isDirectory()) continue;
                this.addAsGeneratedSourceFolder(f, rootType, contentRootEntity);
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private final ModuleDependencyItem.DependencyScope getDependencyScope(MavenArtifact $this$dependencyScope) {
        block7: {
            block5: {
                block6: {
                    v0 = $this$dependencyScope.getScope();
                    if (v0 == null) break block5;
                    var2_2 = v0;
                    switch (var2_2.hashCode()) {
                        case 3556498: {
                            if (!var2_2.equals("test")) ** break;
                            break;
                        }
                        case -987494941: {
                            if (!var2_2.equals("provided")) ** break;
                            break block6;
                        }
                        case 1550962648: {
                            if (!var2_2.equals("runtime")) ** break;
                            v1 = ModuleDependencyItem.DependencyScope.RUNTIME;
                            break block7;
                        }
                    }
                    v1 = ModuleDependencyItem.DependencyScope.TEST;
                    break block7;
                }
                v1 = ModuleDependencyItem.DependencyScope.PROVIDED;
                break block7;
            }
            v1 = ModuleDependencyItem.DependencyScope.COMPILE;
        }
        return v1;
    }

    private final String toAbsolutePath(String path) {
        Path path2 = MavenUtil.toPath(this.mavenProject, path);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"MavenUtil.toPath(mavenProject, path)");
        String string = path2.getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"MavenUtil.toPath(mavenProject, path).path");
        return string;
    }

    public WorkspaceModuleImporter(@NotNull MavenProject mavenProject2, @NotNull VirtualFileUrlManager virtualFileUrlManager, @NotNull MavenProjectsTree projectsTree, @NotNull MutableEntityStorage builder, @NotNull MavenImportingSettings importingSettings, @NotNull HashMap<MavenProject, String> mavenProjectToModuleName, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)mavenProject2, (String)"mavenProject");
        Intrinsics.checkNotNullParameter((Object)virtualFileUrlManager, (String)"virtualFileUrlManager");
        Intrinsics.checkNotNullParameter((Object)projectsTree, (String)"projectsTree");
        Intrinsics.checkNotNullParameter((Object)builder, (String)"builder");
        Intrinsics.checkNotNullParameter((Object)importingSettings, (String)"importingSettings");
        Intrinsics.checkNotNullParameter(mavenProjectToModuleName, (String)"mavenProjectToModuleName");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.mavenProject = mavenProject2;
        this.virtualFileUrlManager = virtualFileUrlManager;
        this.projectsTree = projectsTree;
        this.builder = builder;
        this.importingSettings = importingSettings;
        this.mavenProjectToModuleName = mavenProjectToModuleName;
        this.project = project2;
        ProjectModelExternalSource projectModelExternalSource = ExternalProjectSystemRegistry.getInstance().getSourceById("Maven");
        Intrinsics.checkNotNullExpressionValue((Object)projectModelExternalSource, (String)"ExternalProjectSystemReg\u2026MAVEN_EXTERNAL_SOURCE_ID)");
        this.externalSource = projectModelExternalSource;
    }

    static {
        Companion = new Companion(null);
        JAVADOC_TYPE = new LibraryRootTypeId("JAVADOC");
    }

    public static final /* synthetic */ ProjectModelExternalSource access$getExternalSource$p(WorkspaceModuleImporter $this) {
        return $this.externalSource;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0014\u0010\u0003\u001a\u00020\u0004X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lorg/jetbrains/idea/maven/importing/workspaceModel/WorkspaceModuleImporter$Companion;", "", "()V", "JAVADOC_TYPE", "Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryRootTypeId;", "getJAVADOC_TYPE$intellij_maven", "()Lcom/intellij/workspaceModel/storage/bridgeEntities/api/LibraryRootTypeId;", "intellij.maven"})
    public static final class Companion {
        @NotNull
        public final LibraryRootTypeId getJAVADOC_TYPE$intellij_maven() {
            return JAVADOC_TYPE;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

