/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.navigator;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.pom.NavigatableAdapter;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.Processor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.idea.maven.dom.MavenDomProjectProcessorUtils;
import org.jetbrains.idea.maven.dom.MavenDomUtil;
import org.jetbrains.idea.maven.dom.model.MavenDomDependencies;
import org.jetbrains.idea.maven.dom.model.MavenDomDependency;
import org.jetbrains.idea.maven.dom.model.MavenDomProjectModel;
import org.jetbrains.idea.maven.model.MavenArtifact;
import org.jetbrains.idea.maven.model.MavenId;
import org.jetbrains.idea.maven.project.MavenProjectsManager;
import org.jetbrains.idea.maven.utils.MavenArtifactUtil;

public final class MavenNavigationUtil {
    private static final String ARTIFACT_ID = "artifactId";

    private MavenNavigationUtil() {
    }

    @Nullable
    public static Navigatable createNavigatableForPom(final Project project2, final VirtualFile file) {
        if (file == null || !file.isValid()) {
            return null;
        }
        final PsiFile result = PsiManager.getInstance((Project)project2).findFile(file);
        return result == null ? null : new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                XmlTag[] id;
                XmlTag rootTag;
                XmlDocument xml;
                int offset = 0;
                if (result instanceof XmlFile && (xml = ((XmlFile)result).getDocument()) != null && (rootTag = xml.getRootTag()) != null && (id = rootTag.findSubTags(MavenNavigationUtil.ARTIFACT_ID, rootTag.getNamespace())).length > 0) {
                    offset = id[0].getValue().getTextRange().getStartOffset();
                }
                1.navigate((Project)project2, (VirtualFile)file, (int)offset, (boolean)requestFocus);
            }
        };
    }

    @NotNull
    public static Navigatable createNavigatableForDependency(@NotNull Project project2, @NotNull VirtualFile file, @NotNull MavenArtifact artifact) {
        if (project2 == null) {
            MavenNavigationUtil.$$$reportNull$$$0(0);
        }
        if (file == null) {
            MavenNavigationUtil.$$$reportNull$$$0(1);
        }
        if (artifact == null) {
            MavenNavigationUtil.$$$reportNull$$$0(2);
        }
        return MavenNavigationUtil.createNavigatableForDependency(project2, file, artifact.getGroupId(), artifact.getArtifactId());
    }

    @NotNull
    public static Navigatable createNavigatableForDependency(final @NotNull Project project2, final @NotNull VirtualFile file, final @NotNull String groupId, final @NotNull String artifactId) {
        if (project2 == null) {
            MavenNavigationUtil.$$$reportNull$$$0(3);
        }
        if (file == null) {
            MavenNavigationUtil.$$$reportNull$$$0(4);
        }
        if (groupId == null) {
            MavenNavigationUtil.$$$reportNull$$$0(5);
        }
        if (artifactId == null) {
            MavenNavigationUtil.$$$reportNull$$$0(6);
        }
        return new NavigatableAdapter(){

            public void navigate(boolean requestFocus) {
                if (!file.isValid()) {
                    return;
                }
                MavenDomProjectModel projectModel = MavenDomUtil.getMavenDomProjectModel(project2, file);
                if (projectModel == null) {
                    return;
                }
                MavenDomDependency dependency = MavenNavigationUtil.findDependency(projectModel, groupId, artifactId);
                if (dependency == null) {
                    return;
                }
                XmlTag artifactId2 = dependency.getArtifactId().getXmlTag();
                if (artifactId2 == null) {
                    return;
                }
                2.navigate((Project)project2, (VirtualFile)artifactId2.getContainingFile().getVirtualFile(), (int)(artifactId2.getTextOffset() + artifactId2.getName().length() + 2), (boolean)requestFocus);
            }
        };
    }

    @Nullable
    public static VirtualFile getArtifactFile(Project project2, MavenId id) {
        Path path = MavenArtifactUtil.getArtifactFile(MavenProjectsManager.getInstance(project2).getLocalRepository(), id);
        return Files.exists(path, new LinkOption[0]) ? LocalFileSystem.getInstance().findFileByNioFile(path) : null;
    }

    @Nullable
    public static MavenDomDependency findDependency(@NotNull MavenDomProjectModel projectDom, final String groupId, final String artifactId) {
        if (projectDom == null) {
            MavenNavigationUtil.$$$reportNull$$$0(7);
        }
        MavenDomProjectProcessorUtils.SearchProcessor<MavenDomDependency, MavenDomDependencies> processor = new MavenDomProjectProcessorUtils.SearchProcessor<MavenDomDependency, MavenDomDependencies>(){

            @Override
            @Nullable
            protected MavenDomDependency find(MavenDomDependencies element) {
                for (MavenDomDependency dependency : element.getDependencies()) {
                    if (!Objects.equals(groupId, dependency.getGroupId().getStringValue()) || !Objects.equals(artifactId, dependency.getArtifactId().getStringValue())) continue;
                    return dependency;
                }
                return null;
            }
        };
        MavenDomProjectProcessorUtils.processDependencies(projectDom, (Processor<MavenDomDependencies>)processor);
        return (MavenDomDependency)processor.getResult();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "artifact";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "groupId";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = ARTIFACT_ID;
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "projectDom";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/idea/maven/navigator/MavenNavigationUtil";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "createNavigatableForDependency";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "findDependency";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

