/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.idea.maven.project;

import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.SmartList;
import java.text.MessageFormat;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.idea.maven.execution.MavenExecutionOptions;
import org.jetbrains.idea.maven.execution.RunnerBundle;

public abstract class MavenConsole {
    private static final String LINE_SEPARATOR = System.lineSeparator();
    private final List<ProcessListener> myProcessListeners = new SmartList();
    private final List<AttachProcessListener> myAttachProcessListeners = new SmartList();
    private final int myOutputLevel;
    private boolean isFinished;
    private static final BiMap<String, Integer> PREFIX_TO_LEVEL = ImmutableBiMap.of((Object)"DEBUG", (Object)0, (Object)"INFO", (Object)1, (Object)"WARNING", (Object)2, (Object)"ERROR", (Object)3, (Object)"FATAL_ERROR", (Object)4);

    public MavenConsole(MavenExecutionOptions.LoggingLevel outputLevel, boolean printStackTrace) {
        this.myOutputLevel = outputLevel.getLevel();
    }

    public boolean isSuppressed(int level) {
        return level < this.myOutputLevel;
    }

    public void addProcessListener(ProcessListener processListener) {
        this.myProcessListeners.add(processListener);
    }

    public void addAttachProcessListener(AttachProcessListener listener2) {
        this.myAttachProcessListeners.add(listener2);
    }

    public boolean isSuppressed(String line) {
        return this.isSuppressed(MavenConsole.getLevel(line));
    }

    public abstract boolean canPause();

    public abstract boolean isOutputPaused();

    public abstract void setOutputPaused(boolean var1);

    public boolean isFinished() {
        return this.isFinished;
    }

    public void finish() {
        this.isFinished = true;
    }

    public void attachToProcess(ProcessHandler processHandler) {
        for (ProcessListener processListener : this.myProcessListeners) {
            processHandler.addProcessListener(processListener);
        }
        for (AttachProcessListener attachProcessListener : this.myAttachProcessListeners) {
            attachProcessListener.beforeProcessAttached(processHandler);
        }
    }

    public void printException(Throwable throwable) {
        this.systemMessage(3, RunnerBundle.message("embedded.build.failed", new Object[0]), throwable);
    }

    public void systemMessage(int level, String string, Throwable throwable) {
        this.printMessage(level, string, throwable);
    }

    public void printMessage(int level, String string, Throwable throwable) {
        if (this.isSuppressed(level)) {
            return;
        }
        OutputType type2 = OutputType.NORMAL;
        if (throwable != null || level == 2 || level == 3 || level == 4) {
            type2 = OutputType.ERROR;
        }
        this.doPrint(MavenConsole.composeLine(level, string), type2);
        if (level == 4) {
            this.setOutputPaused(false);
        }
        if (throwable != null) {
            String throwableText = ExceptionUtil.getThrowableText((Throwable)throwable);
            if (Registry.is((String)"maven.print.import.stacktraces") || ApplicationManager.getApplication().isUnitTestMode()) {
                this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, throwableText), type2);
            } else {
                this.doPrint(LINE_SEPARATOR + MavenConsole.composeLine(3, throwable.getMessage()), type2);
            }
        }
    }

    private static String appendExecutionFailureMessage(String message, String newMessage) {
        if (message == null) {
            return newMessage;
        }
        if (newMessage == null) {
            return message;
        }
        return message + LINE_SEPARATOR + LINE_SEPARATOR + newMessage;
    }

    protected abstract void doPrint(String var1, OutputType var2);

    private static int getLevel(String line) {
        return MavenConsole.getLevelByPrefix(MavenConsole.extractPrefix(line));
    }

    private static String extractPrefix(String line) {
        int closing;
        if (line.startsWith("[") && (closing = line.indexOf("] ", 1)) > 1) {
            return line.substring(1, closing);
        }
        return "";
    }

    private static int getLevelByPrefix(String prefix) {
        Integer level = (Integer)PREFIX_TO_LEVEL.get((Object)prefix);
        return level != null ? level : 2;
    }

    private static String composeLine(int level, String message) {
        return MessageFormat.format("[{0}] {1}", MavenConsole.getPrefixByLevel(level), message);
    }

    private static String getPrefixByLevel(int level) {
        return (String)PREFIX_TO_LEVEL.inverse().get((Object)level);
    }

    public static interface AttachProcessListener {
        public void beforeProcessAttached(@NotNull ProcessHandler var1);
    }

    public static enum OutputType {
        NORMAL,
        SYSTEM,
        ERROR;

    }
}

