/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.junit4;

import com.intellij.junit4.IdeaSuite;
import java.lang.reflect.Method;
import org.junit.internal.AssumptionViolatedException;
import org.junit.internal.builders.AllDefaultPossibilitiesBuilder;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.internal.builders.IgnoredBuilder;
import org.junit.internal.builders.JUnit4Builder;
import org.junit.internal.runners.model.EachTestNotifier;
import org.junit.runner.Description;
import org.junit.runner.Request;
import org.junit.runner.Runner;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.RunnerBuilder;

public final class JUnit45ClassesRequestBuilder {
    public static Request getClassesRequest(String suiteName, Class<?>[] classes) {
        try {
            return Request.runner((Runner)new IdeaSuite((RunnerBuilder)new AllDefaultPossibilitiesBuilder(true), classes, suiteName));
        }
        catch (Exception initializationError) {
            initializationError.printStackTrace();
            return null;
        }
    }

    static Request createIgnoreIgnoredClassRequest(final Class<?> clazz, final boolean recursively) throws ClassNotFoundException {
        Class.forName("org.junit.runners.BlockJUnit4ClassRunner");
        return new Request(){

            public Runner getRunner() {
                try {
                    return new AllDefaultPossibilitiesBuilder(true){

                        protected IgnoredBuilder ignoredBuilder() {
                            return new IgnoredBuilder(){

                                public Runner runnerForClass(Class testClass) {
                                    return null;
                                }
                            };
                        }

                        protected JUnit4Builder junit4Builder() {
                            return new JUnit4Builder(){

                                public Runner runnerForClass(Class testClass) throws Throwable {
                                    if (!recursively) {
                                        return super.runnerForClass(testClass);
                                    }
                                    try {
                                        Method ignored = BlockJUnit4ClassRunner.class.getDeclaredMethod("isIgnored", FrameworkMethod.class);
                                        if (ignored != null) {
                                            return new BlockJUnit4ClassRunner(testClass){

                                                protected boolean isIgnored(FrameworkMethod child) {
                                                    return false;
                                                }
                                            };
                                        }
                                    }
                                    catch (NoSuchMethodException noSuchMethodException) {
                                        // empty catch block
                                    }
                                    return new BlockJUnit4ClassRunner(testClass){

                                        /*
                                         * WARNING - Removed try catching itself - possible behaviour change.
                                         */
                                        protected void runChild(FrameworkMethod method, RunNotifier notifier) {
                                            Description description = this.describeChild(method);
                                            EachTestNotifier eachNotifier = new EachTestNotifier(notifier, description);
                                            eachNotifier.fireTestStarted();
                                            try {
                                                this.methodBlock(method).evaluate();
                                            }
                                            catch (AssumptionViolatedException e) {
                                                eachNotifier.addFailedAssumption(e);
                                            }
                                            catch (Throwable e) {
                                                eachNotifier.addFailure(e);
                                            }
                                            finally {
                                                eachNotifier.fireTestFinished();
                                            }
                                        }
                                    };
                                }
                            };
                        }
                    }.runnerForClass(clazz);
                }
                catch (Throwable throwable) {
                    return Request.aClass((Class)clazz).getRunner();
                }
            }
        };
    }

    static Runner createIgnoreAnnotationAndJUnit4ClassRunner(Class<?> clazz) throws Throwable {
        return new AllDefaultPossibilitiesBuilder(true){

            protected AnnotatedBuilder annotatedBuilder() {
                return new AnnotatedBuilder((RunnerBuilder)this){

                    public Runner runnerForClass(Class testClass) {
                        return null;
                    }
                };
            }

            protected JUnit4Builder junit4Builder() {
                return new JUnit4Builder(){

                    public Runner runnerForClass(Class testClass) {
                        return null;
                    }
                };
            }
        }.runnerForClass(clazz);
    }
}

