/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.config.impl;

import com.intellij.icons.AllIcons;
import com.intellij.lang.ant.AntBundle;
import com.intellij.lang.ant.config.AntBuildFile;
import com.intellij.lang.ant.config.AntConfiguration;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionManagerEx;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapExtension;
import com.intellij.openapi.keymap.KeymapGroup;
import com.intellij.openapi.keymap.KeymapGroupFactory;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import java.util.HashMap;
import java.util.List;

final class AntKeymapExtension
implements KeymapExtension {
    private static final Logger LOG = Logger.getInstance(AntKeymapExtension.class);

    AntKeymapExtension() {
    }

    public KeymapGroup createGroup(Condition<? super AnAction> filtered, Project project) {
        HashMap buildFileToGroup = new HashMap();
        KeymapGroup result = KeymapGroupFactory.getInstance().createGroup(AntBundle.message("ant.targets.group.title", new Object[0]), AllIcons.Nodes.KeymapAnt);
        ActionManagerEx actionManager = ActionManagerEx.getInstanceEx();
        List ids = actionManager.getActionIdList(project != null ? AntConfiguration.getActionIdPrefix(project) : "Ant_");
        ids.sort(null);
        if (project != null) {
            AntConfiguration antConfiguration = AntConfiguration.getInstance(project);
            ApplicationManager.getApplication().runReadAction(() -> {
                for (String id : ids) {
                    if (filtered != null && !filtered.value((Object)actionManager.getActionOrStub(id))) continue;
                    AntBuildFile buildFile = antConfiguration.findBuildFileByActionId(id);
                    if (buildFile != null) {
                        KeymapGroup subGroup = (KeymapGroup)buildFileToGroup.get(buildFile);
                        if (subGroup == null) {
                            subGroup = KeymapGroupFactory.getInstance().createGroup(buildFile.getPresentableName());
                            buildFileToGroup.put(buildFile, subGroup);
                            result.addGroup(subGroup);
                        }
                        subGroup.addActionId(id);
                        continue;
                    }
                    LOG.info("no buildfile found for actionId=" + id);
                }
            });
        }
        return result;
    }
}

