/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.lang.ant.dom;

import com.intellij.ide.highlighter.XmlFileType;
import com.intellij.lang.ant.AntFilesProvider;
import com.intellij.lang.ant.AntSupport;
import com.intellij.lang.ant.ReflectedProject;
import com.intellij.lang.ant.config.impl.AntResourcesClassLoader;
import com.intellij.lang.ant.dom.AntDomAntlib;
import com.intellij.lang.ant.dom.AntDomClasspathElement;
import com.intellij.lang.ant.dom.AntDomCustomClasspathComponent;
import com.intellij.lang.ant.dom.AntDomCustomElement;
import com.intellij.lang.ant.dom.AntDomElement;
import com.intellij.lang.ant.dom.AntDomImport;
import com.intellij.lang.ant.dom.AntDomInclude;
import com.intellij.lang.ant.dom.AntDomIncludingDirective;
import com.intellij.lang.ant.dom.AntDomMacroDef;
import com.intellij.lang.ant.dom.AntDomMacrodefElement;
import com.intellij.lang.ant.dom.AntDomNamedElement;
import com.intellij.lang.ant.dom.AntDomPresetDef;
import com.intellij.lang.ant.dom.AntDomProject;
import com.intellij.lang.ant.dom.AntDomRecursiveVisitor;
import com.intellij.lang.ant.dom.AntDomScriptDef;
import com.intellij.lang.ant.dom.AntDomScriptdefElement;
import com.intellij.lang.ant.dom.AntDomTaskdef;
import com.intellij.lang.ant.dom.AntDomTypeDef;
import com.intellij.lang.ant.dom.ClassProvider;
import com.intellij.lang.properties.IProperty;
import com.intellij.lang.properties.PropertiesFileType;
import com.intellij.lang.properties.psi.PropertiesFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.util.text.StringUtilRt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.LocalTimeCounter;
import com.intellij.util.xml.XmlName;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.InvalidPathException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CustomAntElementsRegistry {
    public static final ThreadLocal<Boolean> ourIsBuildingClasspathForCustomTagLoading = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private static final Logger LOG = Logger.getInstance(CustomAntElementsRegistry.class);
    private static final Key<CustomAntElementsRegistry> REGISTRY_KEY = Key.create((String)"_custom_element_registry_");
    private final Map<XmlName, ClassProvider> myCustomElements = new HashMap<XmlName, ClassProvider>();
    private final Map<AntDomNamedElement, String> myTypeDefErrors = new HashMap<AntDomNamedElement, String>();
    private final Map<XmlName, AntDomNamedElement> myDeclarations = new HashMap<XmlName, AntDomNamedElement>();
    private final Map<String, ClassLoader> myNamedLoaders = new HashMap<String, ClassLoader>();
    private final boolean myIsComplete;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private CustomAntElementsRegistry(AntDomProject antProject) {
        boolean isComplete = false;
        try {
            antProject.accept(new CustomTagDefinitionFinder(antProject));
            isComplete = true;
        }
        catch (ProcessCanceledException processCanceledException) {
        }
        finally {
            this.myIsComplete = isComplete;
        }
    }

    public boolean isComplete() {
        return this.myIsComplete;
    }

    public static CustomAntElementsRegistry getInstance(AntDomProject antProject) {
        CustomAntElementsRegistry registry;
        AntDomProject contextProject = antProject.getContextAntProject();
        CustomAntElementsRegistry customAntElementsRegistry = registry = contextProject != null ? (CustomAntElementsRegistry)contextProject.getUserData(REGISTRY_KEY) : null;
        if (registry == null && (registry = new CustomAntElementsRegistry(antProject)).isComplete()) {
            antProject.putUserData(REGISTRY_KEY, registry);
        }
        return registry;
    }

    @NotNull
    public Set<XmlName> getCompletionVariants(AntDomElement parentElement) {
        if (parentElement instanceof AntDomCustomElement) {
            Set<XmlName> set = Collections.emptySet();
            if (set == null) {
                CustomAntElementsRegistry.$$$reportNull$$$0(0);
            }
            return set;
        }
        HashSet<XmlName> result = new HashSet<XmlName>();
        Pair<AntDomMacroDef, AntDomScriptDef> contextMacroOrScriptDef = this.getContextMacroOrScriptDef(parentElement);
        AntDomMacroDef restrictToMacroDef = (AntDomMacroDef)Pair.getFirst(contextMacroOrScriptDef);
        AntDomScriptDef restrictToScriptDef = (AntDomScriptDef)Pair.getSecond(contextMacroOrScriptDef);
        boolean parentIsDataType = parentElement.isDataType();
        for (XmlName xmlName : this.myCustomElements.keySet()) {
            AntDomNamedElement declaringElement = this.myDeclarations.get(xmlName);
            if (!(declaringElement instanceof AntDomMacrodefElement) ? declaringElement instanceof AntDomScriptdefElement && (restrictToScriptDef == null || !restrictToScriptDef.equals(declaringElement.getParentOfType(AntDomScriptDef.class, true))) : restrictToMacroDef == null || !restrictToMacroDef.equals(declaringElement.getParentOfType(AntDomMacroDef.class, true))) continue;
            if (declaringElement != null && (declaringElement.equals(restrictToMacroDef) || declaringElement.equals(restrictToScriptDef))) continue;
            if (parentIsDataType) {
                if (declaringElement instanceof AntDomMacroDef || declaringElement instanceof AntDomScriptDef || declaringElement instanceof AntDomTaskdef) continue;
                if (declaringElement instanceof AntDomTypeDef) {
                    AntDomTypeDef typedef = (AntDomTypeDef)declaringElement;
                    Class<?> clazz = this.lookupClass(xmlName);
                    if (clazz != null && typedef.isTask(clazz)) continue;
                }
            }
            result.add(xmlName);
        }
        HashSet<XmlName> hashSet = result;
        if (hashSet == null) {
            CustomAntElementsRegistry.$$$reportNull$$$0(1);
        }
        return hashSet;
    }

    @Nullable
    private Pair<AntDomMacroDef, AntDomScriptDef> getContextMacroOrScriptDef(AntDomElement element) {
        AntDomMacroDef macrodef = (AntDomMacroDef)element.getParentOfType(AntDomMacroDef.class, false);
        if (macrodef != null) {
            return new Pair((Object)macrodef, null);
        }
        for (AntDomCustomElement custom = (AntDomCustomElement)element.getParentOfType(AntDomCustomElement.class, false); custom != null; custom = (AntDomCustomElement)custom.getParentOfType(AntDomCustomElement.class, true)) {
            AntDomNamedElement declaring = this.getDeclaringElement(custom.getXmlName());
            if (declaring instanceof AntDomMacroDef) {
                return new Pair((Object)((AntDomMacroDef)declaring), null);
            }
            if (!(declaring instanceof AntDomScriptDef)) continue;
            return new Pair(null, (Object)((AntDomScriptDef)declaring));
        }
        return null;
    }

    @Nullable
    public AntDomElement findDeclaringElement(AntDomElement parentElement, XmlName customElementName) {
        AntDomScriptDef scriptDefUsed;
        Pair<AntDomMacroDef, AntDomScriptDef> contextMacroOrScriptDef;
        AntDomMacroDef macrodefUsed;
        AntDomElement declaration = this.myDeclarations.get(customElementName);
        if (declaration == null) {
            return null;
        }
        if (declaration instanceof AntDomMacrodefElement ? (macrodefUsed = (AntDomMacroDef)Pair.getFirst(contextMacroOrScriptDef = this.getContextMacroOrScriptDef(parentElement))) == null || !macrodefUsed.equals(declaration.getParentOfType(AntDomMacroDef.class, true)) : declaration instanceof AntDomScriptdefElement && ((scriptDefUsed = (AntDomScriptDef)Pair.getSecond(contextMacroOrScriptDef = this.getContextMacroOrScriptDef(parentElement))) == null || !scriptDefUsed.equals(declaration.getParentOfType(AntDomScriptDef.class, true)))) {
            return null;
        }
        return declaration;
    }

    public AntDomNamedElement getDeclaringElement(XmlName customElementName) {
        return this.myDeclarations.get(customElementName);
    }

    @Nullable
    public Class<?> lookupClass(XmlName xmlName) {
        ClassProvider provider = this.myCustomElements.get(xmlName);
        return provider == null ? null : provider.lookupClass();
    }

    @Nullable
    @Nls(capitalization=Nls.Capitalization.Sentence)
    public String lookupError(XmlName xmlName) {
        ClassProvider provider = this.myCustomElements.get(xmlName);
        return provider == null ? null : provider.getError();
    }

    public boolean hasTypeLoadingErrors(AntDomTypeDef typedef) {
        String generalError = this.myTypeDefErrors.get(typedef);
        if (generalError != null) {
            return true;
        }
        return StreamEx.ofKeys(this.myDeclarations, typedef::equals).anyMatch(name -> this.lookupError((XmlName)name) != null);
    }

    public List<@NlsSafe String> getTypeLoadingErrors(AntDomTypeDef typedef) {
        String generalError = this.myTypeDefErrors.get(typedef);
        if (generalError != null) {
            return Collections.singletonList(generalError);
        }
        ArrayList<String> errors = null;
        for (Map.Entry<XmlName, AntDomNamedElement> entry : this.myDeclarations.entrySet()) {
            String err;
            if (!typedef.equals(entry.getValue()) || (err = this.lookupError(entry.getKey())) == null) continue;
            if (errors == null) {
                errors = new ArrayList<String>();
            }
            errors.add(err);
        }
        return errors == null ? Collections.emptyList() : errors;
    }

    private void rememberNamedClassLoader(AntDomCustomClasspathComponent typedef, AntDomProject antProject) {
        String loaderRef = typedef.getLoaderRef().getStringValue();
        if (loaderRef != null && !this.myNamedLoaders.containsKey(loaderRef)) {
            this.myNamedLoaders.put(loaderRef, CustomAntElementsRegistry.createClassLoader(CustomAntElementsRegistry.collectUrls(typedef), antProject));
        }
    }

    @NotNull
    private ClassLoader getClassLoader(AntDomCustomClasspathComponent customComponent, AntDomProject antProject) {
        ClassLoader loader;
        String loaderRef = customComponent.getLoaderRef().getStringValue();
        if (loaderRef != null && (loader = this.myNamedLoaders.get(loaderRef)) != null) {
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                CustomAntElementsRegistry.$$$reportNull$$$0(2);
            }
            return classLoader;
        }
        return CustomAntElementsRegistry.createClassLoader(CustomAntElementsRegistry.collectUrls(customComponent), antProject);
    }

    @Nullable
    public static PsiFile loadContentAsFile(PsiFile originalFile, LanguageFileType fileType) {
        VirtualFile vFile = originalFile.getVirtualFile();
        if (vFile == null) {
            return null;
        }
        try {
            return CustomAntElementsRegistry.loadContentAsFile(originalFile.getProject(), vFile.getInputStream(), fileType);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    public static PsiFile loadContentAsFile(Project project, InputStream stream, LanguageFileType fileType) throws IOException {
        StringBuilder builder = new StringBuilder();
        try (InputStream inputStream = stream;){
            int nextByte;
            while ((nextByte = stream.read()) >= 0) {
                builder.append((char)nextByte);
            }
        }
        PsiFileFactory factory = PsiFileFactory.getInstance((Project)project);
        return factory.createFileFromText("_ant_dummy__." + fileType.getDefaultExtension(), (FileType)fileType, (CharSequence)builder, LocalTimeCounter.currentTime(), false, false);
    }

    private void addCustomDefinition(@NotNull AntDomNamedElement declaringTag, String customTagName, String nsUri, ClassProvider classProvider) {
        if (declaringTag == null) {
            CustomAntElementsRegistry.$$$reportNull$$$0(3);
        }
        XmlName xmlName = new XmlName(customTagName, nsUri == null ? "" : nsUri);
        this.myCustomElements.put(xmlName, classProvider);
        this.myDeclarations.put(xmlName, declaringTag);
        ProgressManager.checkCanceled();
    }

    private static boolean isXmlFormat(AntDomTypeDef typedef, @NotNull String resourceOrFileName) {
        String format;
        if (resourceOrFileName == null) {
            CustomAntElementsRegistry.$$$reportNull$$$0(4);
        }
        if ((format = typedef.getFormat().getStringValue()) != null) {
            return "xml".equalsIgnoreCase(format);
        }
        return StringUtil.endsWithIgnoreCase((String)resourceOrFileName, (String)".xml");
    }

    @NotNull
    public static ClassLoader createClassLoader(List<Path> files, AntDomProject antProject) {
        ClassLoader parentLoader = antProject.getClassLoader();
        if (files.isEmpty()) {
            ClassLoader classLoader = parentLoader;
            if (classLoader == null) {
                CustomAntElementsRegistry.$$$reportNull$$$0(5);
            }
            return classLoader;
        }
        return new AntResourcesClassLoader(files, parentLoader, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Path> collectUrls(AntDomClasspathElement typedef) {
        boolean cleanupNeeded = false;
        if (!ourIsBuildingClasspathForCustomTagLoading.get().booleanValue()) {
            ourIsBuildingClasspathForCustomTagLoading.set(Boolean.TRUE);
            cleanupNeeded = true;
        }
        try {
            ArrayList<Path> paths = new ArrayList<Path>();
            List cpFiles = (List)typedef.getClasspath().getValue();
            if (cpFiles != null) {
                CustomAntElementsRegistry.addClasspathEntries(paths, cpFiles);
            }
            HashSet<AntFilesProvider> processed = new HashSet<AntFilesProvider>();
            AntDomElement referencedPath = (AntDomElement)typedef.getClasspathRef().getValue();
            if (referencedPath instanceof AntFilesProvider) {
                CustomAntElementsRegistry.addClasspathEntries(paths, ((AntFilesProvider)((Object)referencedPath)).getFiles(processed));
            }
            Iterator<AntDomElement> it = typedef.getAntChildrenIterator();
            while (it.hasNext()) {
                AntDomElement child = it.next();
                if (!(child instanceof AntFilesProvider)) continue;
                CustomAntElementsRegistry.addClasspathEntries(paths, ((AntFilesProvider)((Object)child)).getFiles(processed));
            }
            ArrayList<Path> arrayList = paths;
            return arrayList;
        }
        finally {
            if (cleanupNeeded) {
                ourIsBuildingClasspathForCustomTagLoading.remove();
            }
        }
    }

    private static void addClasspathEntries(List<Path> paths, List<File> cpFiles) {
        for (File file : cpFiles) {
            Path path;
            if (!CustomAntElementsRegistry.isValidClassPathEntry(file)) continue;
            try {
                path = file.toPath();
            }
            catch (InvalidPathException e) {
                LOG.info((Throwable)e);
                continue;
            }
            paths.add(path);
        }
    }

    private static boolean isValidClassPathEntry(File file) {
        if (file.isFile()) {
            String name = file.getName();
            return StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".jar") || StringUtilRt.endsWithIgnoreCase((CharSequence)name, (CharSequence)".zip");
        }
        return true;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
            case 3: 
            case 4: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 2;
                break;
            }
            case 3: 
            case 4: {
                n2 = 3;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/lang/ant/dom/CustomAntElementsRegistry";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "declaringTag";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resourceOrFileName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getCompletionVariants";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getClassLoader";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/lang/ant/dom/CustomAntElementsRegistry";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createClassLoader";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "addCustomDefinition";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isXmlFormat";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
            case 3: 
            case 4: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
        }
        throw runtimeException;
    }

    private final class CustomTagDefinitionFinder
    extends AntDomRecursiveVisitor {
        private final Set<AntDomElement> myElementsOnThePath = new HashSet<AntDomElement>();
        private final Set<String> processedAntlibs = new HashSet<String>();
        private final AntDomProject myAntProject;

        CustomTagDefinitionFinder(AntDomProject antProject) {
            this.myAntProject = antProject;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void visitAntDomElement(AntDomElement element) {
            ProgressManager.checkCanceled();
            if (element instanceof AntDomCustomElement || this.myElementsOnThePath.contains(element)) {
                return;
            }
            this.myElementsOnThePath.add(element);
            try {
                XmlTag tag = element.getXmlTag();
                if (tag != null) {
                    String[] uris;
                    for (String uri : uris = tag.knownNamespaces()) {
                        ClassLoader loader;
                        InputStream stream;
                        XmlElement xmlElement;
                        if (this.processedAntlibs.contains(uri)) continue;
                        this.processedAntlibs.add(uri);
                        String antLibResource = AntDomAntlib.toAntlibResource(uri);
                        if (antLibResource == null || (xmlElement = element.getXmlElement()) == null || (stream = (loader = this.myAntProject.getClassLoader()).getResourceAsStream(antLibResource)) == null) continue;
                        try {
                            XmlFile xmlFile = (XmlFile)CustomAntElementsRegistry.loadContentAsFile(xmlElement.getProject(), stream, (LanguageFileType)XmlFileType.INSTANCE);
                            this.loadDefinitionsFromAntlib(xmlFile, uri, loader, null, this.myAntProject);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    }
                }
                super.visitAntDomElement(element);
            }
            finally {
                this.myElementsOnThePath.remove(element);
            }
        }

        @Override
        public void visitMacroDef(AntDomMacroDef macrodef) {
            ProgressManager.checkCanceled();
            String customTagName = macrodef.getName().getStringValue();
            if (customTagName != null) {
                String nsUri = macrodef.getUri().getStringValue();
                CustomAntElementsRegistry.this.addCustomDefinition(macrodef, customTagName, nsUri, ClassProvider.EMPTY);
                for (AntDomMacrodefElement element : macrodef.getMacroElements()) {
                    String customSubTagName = element.getName().getStringValue();
                    if (customSubTagName == null) continue;
                    CustomAntElementsRegistry.this.addCustomDefinition(element, customSubTagName, nsUri, ClassProvider.EMPTY);
                }
            }
        }

        @Override
        public void visitScriptDef(AntDomScriptDef scriptdef) {
            ProgressManager.checkCanceled();
            String customTagName = scriptdef.getName().getStringValue();
            if (customTagName != null) {
                String nsUri = scriptdef.getUri().getStringValue();
                ClassLoader classLoader = CustomAntElementsRegistry.this.getClassLoader(scriptdef, this.myAntProject);
                CustomAntElementsRegistry.this.addCustomDefinition(scriptdef, customTagName, nsUri, ClassProvider.EMPTY);
                ReflectedProject reflectedProject = null;
                for (AntDomScriptdefElement element : scriptdef.getScriptdefElements()) {
                    String customSubTagName = element.getName().getStringValue();
                    if (customSubTagName == null) continue;
                    String classname = element.getClassname().getStringValue();
                    if (classname != null) {
                        CustomAntElementsRegistry.this.addCustomDefinition(element, customTagName, nsUri, ClassProvider.create(classname, classLoader));
                        continue;
                    }
                    Class<?> clazz = null;
                    String typeName = element.getElementType().getStringValue();
                    if (typeName != null && (clazz = CustomAntElementsRegistry.this.lookupClass(new XmlName(typeName))) == null) {
                        Map<String, Class<?>> coreTypes;
                        Map<String, Class<?>> coreTasks;
                        if (reflectedProject == null) {
                            reflectedProject = ReflectedProject.getProject(this.myAntProject.getClassLoader());
                        }
                        if ((coreTasks = reflectedProject.getTaskDefinitions()) != null) {
                            clazz = coreTasks.get(typeName);
                        }
                        if (clazz == null && (coreTypes = reflectedProject.getDataTypeDefinitions()) != null) {
                            clazz = coreTypes.get(typeName);
                        }
                    }
                    CustomAntElementsRegistry.this.addCustomDefinition(element, customSubTagName, nsUri, ClassProvider.create(clazz));
                }
            }
        }

        @Override
        public void visitPresetDef(AntDomPresetDef presetdef) {
            ProgressManager.checkCanceled();
            String customTagName = presetdef.getName().getStringValue();
            if (customTagName != null) {
                String nsUri = presetdef.getUri().getStringValue();
                CustomAntElementsRegistry.this.addCustomDefinition(presetdef, customTagName, nsUri, ClassProvider.EMPTY);
            }
        }

        @Override
        public void visitTypeDef(AntDomTypeDef typedef) {
            ProgressManager.checkCanceled();
            CustomAntElementsRegistry.this.rememberNamedClassLoader(typedef, this.myAntProject);
            this.defineCustomElements(typedef, this.myAntProject);
        }

        @Override
        public void visitInclude(AntDomInclude includeTag) {
            ProgressManager.checkCanceled();
            this.processInclude(includeTag);
        }

        @Override
        public void visitImport(AntDomImport importTag) {
            ProgressManager.checkCanceled();
            this.processInclude(importTag);
        }

        private void processInclude(AntDomIncludingDirective directive) {
            AntDomProject slaveProject;
            PsiFileSystemItem item = (PsiFileSystemItem)directive.getFile().getValue();
            if (item instanceof PsiFile && (slaveProject = AntSupport.getAntDomProject((PsiFile)item)) != null) {
                slaveProject.accept(this);
            }
        }

        private void defineCustomElements(AntDomTypeDef typedef, AntDomProject antProject) {
            String uri = typedef.getUri().getStringValue();
            String customTagName = typedef.getName().getStringValue();
            String classname = typedef.getClassName().getStringValue();
            if (classname != null && customTagName != null) {
                CustomAntElementsRegistry.this.addCustomDefinition(typedef, customTagName, uri, ClassProvider.create(classname, CustomAntElementsRegistry.this.getClassLoader(typedef, antProject)));
            } else {
                this.defineCustomElementsFromResources(typedef, uri, antProject, null);
            }
        }

        private void defineCustomElementsFromResources(AntDomTypeDef typedef, String uri, AntDomProject antProject, ClassLoader loader) {
            PropertiesFile propFile;
            XmlFile xmlFile;
            block17: {
                Project project;
                XmlElement xmlElement = antProject.getXmlElement();
                Project project2 = project = xmlElement != null ? xmlElement.getProject() : null;
                if (project == null) {
                    return;
                }
                xmlFile = null;
                propFile = null;
                String resource = typedef.getResource().getStringValue();
                if (resource != null) {
                    InputStream stream;
                    if (loader == null) {
                        loader = CustomAntElementsRegistry.this.getClassLoader(typedef, antProject);
                    }
                    if ((stream = loader.getResourceAsStream(resource)) != null) {
                        try {
                            if (CustomAntElementsRegistry.isXmlFormat(typedef, resource)) {
                                xmlFile = (XmlFile)CustomAntElementsRegistry.loadContentAsFile(project, stream, (LanguageFileType)XmlFileType.INSTANCE);
                                break block17;
                            }
                            propFile = (PropertiesFile)CustomAntElementsRegistry.loadContentAsFile(project, stream, PropertiesFileType.INSTANCE);
                        }
                        catch (IOException e) {
                            LOG.info((Throwable)e);
                        }
                    } else {
                        CustomAntElementsRegistry.this.myTypeDefErrors.put(typedef, "Resource \"" + resource + "\" not found in the classpath");
                    }
                } else {
                    PsiFileSystemItem file = (PsiFileSystemItem)typedef.getFile().getValue();
                    if (file instanceof PsiFile) {
                        if (CustomAntElementsRegistry.isXmlFormat(typedef, file.getName())) {
                            xmlFile = file instanceof XmlFile ? (XmlFile)file : (XmlFile)CustomAntElementsRegistry.loadContentAsFile((PsiFile)file, (LanguageFileType)XmlFileType.INSTANCE);
                        } else {
                            PropertiesFile propertiesFile = propFile = file instanceof PropertiesFile ? (PropertiesFile)file : (PropertiesFile)CustomAntElementsRegistry.loadContentAsFile((PsiFile)file, PropertiesFileType.INSTANCE);
                        }
                    }
                }
            }
            if (propFile != null) {
                if (loader == null) {
                    loader = CustomAntElementsRegistry.this.getClassLoader(typedef, antProject);
                }
                for (IProperty property : propFile.getProperties()) {
                    CustomAntElementsRegistry.this.addCustomDefinition(typedef, property.getUnescapedKey(), uri, ClassProvider.create(property.getUnescapedValue(), loader));
                }
            }
            if (xmlFile != null) {
                if (loader == null) {
                    loader = CustomAntElementsRegistry.this.getClassLoader(typedef, antProject);
                }
                this.loadDefinitionsFromAntlib(xmlFile, uri, loader, typedef, antProject);
            }
        }

        private void loadDefinitionsFromAntlib(XmlFile xmlFile, String uri, ClassLoader loader, @Nullable AntDomTypeDef typedef, AntDomProject antProject) {
            AntDomAntlib antLib = AntSupport.getAntLib((PsiFile)xmlFile);
            if (antLib != null) {
                ArrayList<AntDomTypeDef> defs = new ArrayList<AntDomTypeDef>();
                defs.addAll(antLib.getTaskdefs());
                defs.addAll(antLib.getTypedefs());
                if (!defs.isEmpty()) {
                    for (AntDomTypeDef def : defs) {
                        String tagName = def.getName().getStringValue();
                        String className = def.getClassName().getStringValue();
                        if (tagName != null && className != null) {
                            AntDomTypeDef declaringElement = typedef != null ? typedef : def;
                            CustomAntElementsRegistry.this.addCustomDefinition(declaringElement, tagName, uri, ClassProvider.create(className, loader));
                            continue;
                        }
                        this.defineCustomElementsFromResources(def, uri, antProject, loader);
                    }
                }
            }
        }
    }
}

