/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.mockJDI.values;

import com.intellij.debugger.mockJDI.MockVirtualMachine;
import com.intellij.debugger.mockJDI.values.MockObjectReference;
import com.intellij.debugger.mockJDI.values.MockValue;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.List;

public class MockArrayReference
extends MockObjectReference
implements ArrayReference {
    private final Class<?> myType;

    public MockArrayReference(MockVirtualMachine virtualMachine, Object o, Class<?> type) {
        super(virtualMachine, o);
        this.myType = type;
    }

    @Override
    public int length() {
        return Array.getLength(this.getValue());
    }

    @Override
    public Value getValue(int i) {
        return MockValue.createValue(Array.get(this.getValue(), i), this.myType.getComponentType(), this.myVirtualMachine);
    }

    @Override
    public List<Value> getValues() {
        return this.getValues(0, this.length());
    }

    @Override
    public List<Value> getValues(int from, int to) {
        ArrayList<Value> list = new ArrayList<Value>();
        for (int i = from; i < to; ++i) {
            list.add(this.getValue(i));
        }
        return list;
    }

    @Override
    public void setValue(int i, Value value) {
        throw new UnsupportedOperationException("'setValue' not implemented in " + this.getClass().getName());
    }

    @Override
    public void setValues(List<? extends Value> list) {
        throw new UnsupportedOperationException("'setValues' not implemented in " + this.getClass().getName());
    }

    @Override
    public void setValues(int i, List<? extends Value> list, int i1, int i2) {
        throw new UnsupportedOperationException("'setValues' not implemented in " + this.getClass().getName());
    }
}

