/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.rt.coverage.instrumentation.filters.enumerating;

import com.intellij.rt.coverage.instrumentation.Instrumenter;
import com.intellij.rt.coverage.instrumentation.LineEnumerator;
import com.intellij.rt.coverage.instrumentation.filters.enumerating.LineEnumeratorFilter;
import com.intellij.rt.coverage.instrumentation.kotlin.KotlinUtils;
import com.intellij.rt.coverage.util.ClassNameUtil;
import org.jetbrains.coverage.org.objectweb.asm.Label;
import org.jetbrains.coverage.org.objectweb.asm.MethodVisitor;

public class KotlinLateinitFilter
extends LineEnumeratorFilter {
    private int myState;
    private String myInternalClassName;

    public boolean isApplicable(Instrumenter context, int access, String name, String desc, String signature, String[] exceptions) {
        return KotlinUtils.isKotlinClass(context);
    }

    public void initFilter(MethodVisitor mv, LineEnumerator context) {
        super.initFilter(mv, context);
        this.myState = 0;
        this.myInternalClassName = ClassNameUtil.convertToInternalName(context.getClassName());
    }

    public void visitFieldInsn(int opcode, String owner, String name, String descriptor) {
        super.visitFieldInsn(opcode, owner, name, descriptor);
        if (this.myState == 0 && opcode == 180 && this.myInternalClassName.equals(owner)) {
            this.myState = 1;
            return;
        }
        this.myState = 0;
    }

    public void visitJumpInsn(int opcode, Label label) {
        super.visitJumpInsn(opcode, label);
        if (this.myState == 1 && (opcode == 199 || opcode == 198)) {
            this.myState = 2;
            return;
        }
        this.myState = 0;
    }

    public void visitLdcInsn(Object value) {
        super.visitLdcInsn(value);
        if (this.myState == 2 && value instanceof String) {
            this.myState = 3;
            return;
        }
        this.myState = 0;
    }

    public void visitMethodInsn(int opcode, String owner, String name, String descriptor, boolean isInterface) {
        super.visitMethodInsn(opcode, owner, name, descriptor, isInterface);
        if (this.myState == 3 && opcode == 184 && "kotlin/jvm/internal/Intrinsics".equals(owner) && "throwUninitializedPropertyAccessException".equals(name) && "(Ljava/lang/String;)V".equals(descriptor)) {
            this.myContext.getBranchData().removeLastJump();
        }
        this.myState = 0;
    }
}

