/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.gradle.execution.test.runner;

import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemFinishEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemProgressEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStartEvent;
import com.intellij.openapi.externalSystem.model.task.event.ExternalSystemStatusEvent;
import com.intellij.openapi.externalSystem.model.task.event.TestOperationDescriptor;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.gradle.execution.test.runner.GradleTestsExecutionConsole;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AbstractTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.AfterTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeSuiteEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.BeforeTestEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.OnOutputEvent;
import org.jetbrains.plugins.gradle.execution.test.runner.events.TestEventType;

public class GradleTestEventsProcessor {
    public static void onStatusChange(GradleTestsExecutionConsole console, ExternalSystemProgressEvent<? extends TestOperationDescriptor> event) {
        TestOperationDescriptor descriptor = (TestOperationDescriptor)event.getDescriptor();
        TestEventType eventType = GradleTestEventsProcessor.getEventType(descriptor, event);
        if (eventType == null) {
            return;
        }
        AbstractTestEvent testEvent = null;
        switch (eventType) {
            case BEFORE_SUITE: {
                testEvent = new BeforeSuiteEvent(console);
                break;
            }
            case BEFORE_TEST: {
                testEvent = new BeforeTestEvent(console);
                break;
            }
            case ON_OUTPUT: {
                testEvent = new OnOutputEvent(console);
                break;
            }
            case AFTER_TEST: {
                testEvent = new AfterTestEvent(console);
                break;
            }
            case AFTER_SUITE: {
                testEvent = new AfterSuiteEvent(console);
                break;
            }
        }
        if (testEvent != null) {
            testEvent.process(event);
        }
    }

    private static TestEventType getEventType(@NotNull TestOperationDescriptor descriptor, @NotNull ExternalSystemProgressEvent event) {
        if (descriptor == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(0);
        }
        if (event == null) {
            GradleTestEventsProcessor.$$$reportNull$$$0(1);
        }
        if (event instanceof ExternalSystemStartEvent) {
            if (StringUtil.isEmpty((String)descriptor.getMethodName())) {
                return TestEventType.BEFORE_SUITE;
            }
            return TestEventType.BEFORE_TEST;
        }
        if (event instanceof ExternalSystemFinishEvent) {
            if (StringUtil.isEmpty((String)descriptor.getMethodName())) {
                return TestEventType.AFTER_SUITE;
            }
            return TestEventType.AFTER_TEST;
        }
        if (event instanceof ExternalSystemStatusEvent) {
            return TestEventType.ON_OUTPUT;
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2 = new Object[3];
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[0] = "descriptor";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[0] = "event";
                break;
            }
        }
        objectArray[1] = "org/jetbrains/plugins/gradle/execution/test/runner/GradleTestEventsProcessor";
        objectArray[2] = "getEventType";
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

