/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiResolveHelper;
import com.intellij.psi.codeStyle.ReferenceAdjuster;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.ArrayUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.debugger.fragments.GroovyCodeFragment;
import org.jetbrains.plugins.groovy.lang.groovydoc.psi.api.GrDocComment;
import org.jetbrains.plugins.groovy.lang.psi.GrQualifiedReference;
import org.jetbrains.plugins.groovy.lang.psi.GrReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFileBase;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElement;
import org.jetbrains.plugins.groovy.lang.psi.GroovyRecursiveElementVisitor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrMethodCall;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.expressions.GrReferenceExpression;
import org.jetbrains.plugins.groovy.lang.psi.api.toplevel.imports.GrImportStatement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrCodeReferenceElement;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeArgumentList;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrReferenceElementImpl;
import org.jetbrains.plugins.groovy.lang.psi.impl.GroovyCodeStyleSettingsFacade;
import org.jetbrains.plugins.groovy.lang.psi.impl.PsiImplUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrBindingVariable;
import org.jetbrains.plugins.groovy.lang.psi.util.PsiUtil;

public class GrReferenceAdjuster
implements ReferenceAdjuster {
    public static void shortenAllReferencesIn(@Nullable GroovyPsiElement newTypeElement) {
        if (newTypeElement != null) {
            newTypeElement.accept(new GroovyRecursiveElementVisitor(){

                @Override
                public void visitCodeReferenceElement(@NotNull GrCodeReferenceElement refElement) {
                    if (refElement == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    super.visitCodeReferenceElement(refElement);
                    GrReferenceAdjuster.shortenReference(refElement);
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "refElement", "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster$1", "visitCodeReferenceElement"));
                }
            });
        }
    }

    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(0);
        }
        TextRange range = element.getTextRange();
        GrReferenceAdjuster.process(element.getPsi(), range.getStartOffset(), range.getEndOffset(), addImports, incompleteCode, useFqInJavadoc, useFqInCode);
        return element;
    }

    public ASTNode process(@NotNull ASTNode element, boolean addImports, boolean incompleteCode, Project project) {
        if (element == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(1);
        }
        GroovyCodeStyleSettingsFacade facade = GroovyCodeStyleSettingsFacade.getInstance(project);
        return this.process(element, addImports, incompleteCode, facade.useFqClassNamesInJavadoc(), facade.useFqClassNames());
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(2);
        }
        GrReferenceAdjuster.process(element.getPsi(), startOffset, endOffset, true, true, useFqInJavadoc, useFqInCode);
    }

    public void processRange(@NotNull ASTNode element, int startOffset, int endOffset, Project project) {
        if (element == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(3);
        }
        GroovyCodeStyleSettingsFacade facade = GroovyCodeStyleSettingsFacade.getInstance(project);
        this.processRange(element, startOffset, endOffset, facade.useFqClassNamesInJavadoc(), facade.useFqClassNames());
    }

    private static boolean process(@NotNull PsiElement element, int start, int end, boolean addImports, boolean incomplete, boolean useFqInJavadoc, boolean useFqInCode) {
        if (element == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(4);
        }
        boolean result2 = false;
        if (element instanceof GrQualifiedReference && ((GrQualifiedReference)element).resolve() instanceof PsiClass) {
            result2 = GrReferenceAdjuster.shortenReferenceInner((GrQualifiedReference)element, addImports, incomplete, useFqInJavadoc, useFqInCode);
        } else if (element instanceof GrReferenceExpression && PsiUtil.isSuperReference(((GrReferenceExpression)element).getQualifier())) {
            result2 = GrReferenceAdjuster.shortenReferenceInner((GrReferenceExpression)element, addImports, incomplete, useFqInJavadoc, useFqInCode);
        }
        for (PsiElement child = element.getFirstChild(); child != null; child = child.getNextSibling()) {
            TextRange range = child.getTextRange();
            if (start >= range.getEndOffset() || range.getStartOffset() >= end) continue;
            result2 |= GrReferenceAdjuster.process(child, start, end, addImports, incomplete, useFqInJavadoc, useFqInCode);
        }
        return result2;
    }

    public static <T extends PsiElement> boolean shortenReference(@NotNull GrQualifiedReference<T> ref) {
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(5);
        }
        GroovyCodeStyleSettingsFacade facade = GroovyCodeStyleSettingsFacade.getInstance(ref.getProject());
        boolean result2 = GrReferenceAdjuster.shortenReferenceInner(ref, true, false, facade.useFqClassNamesInJavadoc(), facade.useFqClassNames());
        TextRange range = ref.getTextRange();
        return result2 |= GrReferenceAdjuster.process(ref, range.getStartOffset(), range.getEndOffset(), true, false, facade.useFqClassNamesInJavadoc(), facade.useFqClassNames());
    }

    private static <Qualifier extends PsiElement> boolean shortenReferenceInner(@NotNull GrQualifiedReference<Qualifier> ref, boolean addImports, boolean incomplete, boolean useFqInJavadoc, boolean useFqInCode) {
        GrTypeArgumentList typeArgs;
        Qualifier qualifier;
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(6);
        }
        if ((qualifier = ref.getQualifier()) == null || PsiUtil.isSuperReference(qualifier) || GrReferenceAdjuster.cannotShortenInContext(ref)) {
            return false;
        }
        if (ref instanceof GrReferenceExpression && (typeArgs = ((GrReferenceExpression)ref).getTypeArgumentList()) != null && typeArgs.getTypeArgumentElements().length > 0) {
            return false;
        }
        if (!GrReferenceAdjuster.shorteningIsMeaningfully(ref, useFqInJavadoc, useFqInCode)) {
            return false;
        }
        PsiElement resolved = GrReferenceAdjuster.resolveRef(ref, incomplete);
        if (resolved == null) {
            return false;
        }
        if (!GrReferenceAdjuster.checkCopyWithoutQualifier(ref, addImports, resolved)) {
            return false;
        }
        ref.setQualifier(null);
        return true;
    }

    private static <Qualifier extends PsiElement> boolean checkCopyWithoutQualifier(@NotNull GrQualifiedReference<Qualifier> ref, boolean addImports, @NotNull PsiElement resolved) {
        GroovyFileBase file;
        GrImportStatement added;
        PsiClass clazz;
        String qName;
        GrQualifiedReference<Qualifier> copy;
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(7);
        }
        if (resolved == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(8);
        }
        if ((copy = GrReferenceAdjuster.getCopy(ref)) == null) {
            return false;
        }
        copy.setQualifier(null);
        PsiElement resolvedCopy = copy.resolve();
        if (ref.getManager().areElementsEquivalent(resolved, resolvedCopy)) {
            return true;
        }
        if (resolvedCopy != null && !(resolvedCopy instanceof GrBindingVariable) && !GrReferenceAdjuster.isFromDefaultPackage(resolvedCopy)) {
            return false;
        }
        if (resolved instanceof PsiClass && (qName = (clazz = (PsiClass)resolved).getQualifiedName()) != null && addImports && GrReferenceAdjuster.checkIsInnerClass(clazz, ref) && GrReferenceAdjuster.mayInsertImport(ref) && (added = (file = (GroovyFileBase)ref.getContainingFile()).addImportForClass(clazz)) != null) {
            if (copy.isReferenceTo(resolved)) {
                return true;
            }
            file.removeImport(added);
        }
        return false;
    }

    private static boolean isFromDefaultPackage(@Nullable PsiElement element) {
        String qname;
        if (element instanceof PsiClass && (qname = ((PsiClass)element).getQualifiedName()) != null) {
            String packageName = StringUtil.getPackageName((String)qname);
            if (ArrayUtil.contains((String)packageName, (String[])GroovyFileBase.IMPLICITLY_IMPORTED_PACKAGES)) {
                return true;
            }
            if (ArrayUtil.contains((String)qname, (String[])GroovyFileBase.IMPLICITLY_IMPORTED_CLASSES)) {
                return true;
            }
        }
        return false;
    }

    private static <Qualifier extends PsiElement> boolean checkIsInnerClass(@NotNull PsiClass resolved, GrQualifiedReference<Qualifier> ref) {
        PsiClass containingClass;
        if (resolved == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(9);
        }
        return (containingClass = resolved.getContainingClass()) == null || PsiTreeUtil.isAncestor((PsiElement)containingClass, ref, (boolean)true) || GroovyCodeStyleSettingsFacade.getInstance(containingClass.getProject()).insertInnerClassImports();
    }

    @Nullable
    private static <Qualifier extends PsiElement> PsiElement resolveRef(@NotNull GrQualifiedReference<Qualifier> ref, boolean incomplete) {
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(10);
        }
        if (!incomplete) {
            return ref.resolve();
        }
        PsiResolveHelper helper = JavaPsiFacade.getInstance((Project)ref.getProject()).getResolveHelper();
        if (ref instanceof GrReferenceElement) {
            String classNameText = ((GrReferenceElement)ref).getQualifiedReferenceName();
            if (classNameText == null) {
                return null;
            }
            return helper.resolveReferencedClass(classNameText, ref);
        }
        return null;
    }

    @Nullable
    private static <Qualifier extends PsiElement> GrQualifiedReference<Qualifier> getCopy(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(11);
        }
        if (ref.getParent() instanceof GrMethodCall) {
            GrMethodCall copy = (GrMethodCall)ref.getParent().copy();
            return (GrQualifiedReference)((Object)copy.getInvokedExpression());
        }
        return (GrQualifiedReference)ref.copy();
    }

    private static <Qualifier extends PsiElement> boolean shorteningIsMeaningfully(@NotNull GrQualifiedReference<Qualifier> ref, boolean useFqInJavadoc, boolean useFqInCode) {
        GrDocComment doc;
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(12);
        }
        if (ref instanceof GrReferenceElementImpl && ((GrReferenceElementImpl)ref).isFullyQualified() && ((doc = (GrDocComment)PsiTreeUtil.getParentOfType(ref, GrDocComment.class)) != null ? useFqInJavadoc : useFqInCode)) {
            return false;
        }
        Qualifier qualifier = ref.getQualifier();
        if (qualifier instanceof GrCodeReferenceElement) {
            return true;
        }
        if (qualifier instanceof GrExpression) {
            PsiElement resolved;
            if (qualifier instanceof GrReferenceExpression && PsiUtil.isThisReference(qualifier)) {
                return true;
            }
            if (qualifier instanceof GrReferenceExpression && PsiImplUtil.seemsToBeQualifiedClassName((GrExpression)qualifier) && ((resolved = ((GrReferenceExpression)qualifier).resolve()) instanceof PsiClass || resolved instanceof PsiPackage)) {
                return true;
            }
        }
        return false;
    }

    private static <Qualifier extends PsiElement> boolean cannotShortenInContext(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(13);
        }
        return PsiTreeUtil.getParentOfType(ref, GrImportStatement.class) != null || PsiTreeUtil.getParentOfType(ref, GroovyCodeFragment.class) != null;
    }

    private static <Qualifier extends PsiElement> boolean mayInsertImport(@NotNull GrQualifiedReference<Qualifier> ref) {
        if (ref == null) {
            GrReferenceAdjuster.$$$reportNull$$$0(14);
        }
        return !(ref.getContainingFile() instanceof GroovyCodeFragment) && PsiTreeUtil.getParentOfType(ref, GrImportStatement.class) == null && ref.getContainingFile() instanceof GroovyFileBase;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "element";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "resolved";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/codeStyle/GrReferenceAdjuster";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "process";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "processRange";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[2] = "shortenReference";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[2] = "shortenReferenceInner";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray2;
                objectArray2[2] = "checkCopyWithoutQualifier";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[2] = "checkIsInnerClass";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[2] = "resolveRef";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[2] = "getCopy";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[2] = "shorteningIsMeaningfully";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[2] = "cannotShortenInContext";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[2] = "mayInsertImport";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

