/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.ext.spock;

import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import com.intellij.psi.ResolveState;
import com.intellij.psi.scope.ElementClassHint;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.dgm.GdkMethodHolder;
import org.jetbrains.plugins.groovy.ext.spock.SpockUtils;
import org.jetbrains.plugins.groovy.ext.spock.SpockVariableDescriptor;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.impl.GrAnnotationUtil;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrLightVariable;
import org.jetbrains.plugins.groovy.lang.resolve.NonCodeMembersContributor;
import org.jetbrains.plugins.groovy.lang.resolve.ResolveUtil;

public class SpockMemberContributor
extends NonCodeMembersContributor {
    private static final Pattern UNDERSCORES = Pattern.compile("^__+$");
    private static final String SPOCK_UTIL_MOP_USE = "spock.util.mop.Use";

    @Override
    public void processDynamicElements(@NotNull PsiType qualifierType, @Nullable PsiClass aClass, @NotNull PsiScopeProcessor processor, @NotNull PsiElement place, @NotNull ResolveState state) {
        if (qualifierType == null) {
            SpockMemberContributor.$$$reportNull$$$0(0);
        }
        if (processor == null) {
            SpockMemberContributor.$$$reportNull$$$0(1);
        }
        if (place == null) {
            SpockMemberContributor.$$$reportNull$$$0(2);
        }
        if (state == null) {
            SpockMemberContributor.$$$reportNull$$$0(3);
        }
        if (aClass == null) {
            return;
        }
        ElementClassHint classHint = (ElementClassHint)processor.getHint(ElementClassHint.KEY);
        boolean shouldProcessProperties = ResolveUtil.shouldProcessProperties(classHint);
        boolean shouldProcessMethods = ResolveUtil.shouldProcessMethods(classHint);
        if (!shouldProcessMethods && !shouldProcessProperties) {
            return;
        }
        GrMethod method = (GrMethod)PsiTreeUtil.getParentOfType((PsiElement)place, GrMethod.class);
        if (method == null) {
            return;
        }
        if (shouldProcessProperties && ContainerUtil.exists((Object[])aClass.getSuperTypes(), superType -> {
            PsiClass superClass = superType.resolve();
            if (superClass == null) {
                return false;
            }
            return Objects.equals(superClass.getQualifiedName(), "spock.lang.Specification");
        }) && aClass == method.getContainingClass()) {
            Map<String, SpockVariableDescriptor> cachedValue = SpockUtils.getVariableMap(method);
            String nameHint2 = ResolveUtil.getNameHint(processor);
            if (nameHint2 == null) {
                for (SpockVariableDescriptor spockVar : cachedValue.values()) {
                    if (processor.execute((PsiElement)spockVar.getVariable(), state)) continue;
                    return;
                }
            } else {
                SpockVariableDescriptor spockVar = cachedValue.get(nameHint2);
                if (spockVar != null && spockVar.getNavigationElement() != place) {
                    processor.execute((PsiElement)spockVar.getVariable(), state);
                }
                if (UNDERSCORES.matcher(nameHint2).matches()) {
                    GrLightVariable variable = new GrLightVariable(place.getManager(), nameHint2, (PsiType)PsiType.NULL, List.of(), (PsiElement)method);
                    processor.execute((PsiElement)variable, state);
                }
            }
        }
        if (shouldProcessMethods) {
            SpockMemberContributor.processUseAnnotation(qualifierType, place, processor, state);
        }
    }

    private static void processUseAnnotation(@NotNull PsiType qualifierType, @NotNull PsiElement place, @NotNull PsiScopeProcessor processor, @NotNull ResolveState state) {
        if (qualifierType == null) {
            SpockMemberContributor.$$$reportNull$$$0(4);
        }
        if (place == null) {
            SpockMemberContributor.$$$reportNull$$$0(5);
        }
        if (processor == null) {
            SpockMemberContributor.$$$reportNull$$$0(6);
        }
        if (state == null) {
            SpockMemberContributor.$$$reportNull$$$0(7);
        }
        ArrayList<PsiAnnotation> annotations2 = new ArrayList<PsiAnnotation>();
        List parents = PsiTreeUtil.collectParents((PsiElement)place, PsiModifierListOwner.class, (boolean)true, element -> false);
        for (PsiModifierListOwner parent2 : parents) {
            PsiAnnotation anno;
            PsiModifierList modifierList = parent2.getModifierList();
            if (modifierList == null || (anno = modifierList.findAnnotation(SPOCK_UTIL_MOP_USE)) == null) continue;
            annotations2.add(anno);
        }
        if (annotations2.isEmpty()) {
            return;
        }
        List categoryClasses = ContainerUtil.flatMap(annotations2, annotation -> GrAnnotationUtil.getClassArrayValue(annotation, "value", true));
        if (categoryClasses.isEmpty()) {
            return;
        }
        List holders = ContainerUtil.map((Collection)categoryClasses, categoryClass -> GdkMethodHolder.getHolderForClass(categoryClass, true));
        for (GdkMethodHolder categoryHolder : holders) {
            if (categoryHolder.processMethods(processor, state, qualifierType, place.getProject())) continue;
            return;
        }
    }

    @Override
    public String getParentClassName() {
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "qualifierType";
                break;
            }
            case 1: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processor";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "place";
                break;
            }
            case 3: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
        }
        objectArray2[1] = "org/jetbrains/plugins/groovy/ext/spock/SpockMemberContributor";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "processDynamicElements";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[2] = "processUseAnnotation";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }
}

