/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.lang.psi.dataFlow.reachingDefs;

import com.intellij.util.SmartList;
import com.intellij.util.containers.FList;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.ints.IntArraySet;
import it.unimi.dsi.fastutil.ints.IntCollection;
import it.unimi.dsi.fastutil.ints.IntSet;
import java.io.Serializable;
import java.util.Objects;
import java.util.function.Consumer;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.controlFlow.Instruction;

public final class DefinitionMap {
    public static final DefinitionMap NEUTRAL = new DefinitionMap((Int2ObjectMap<IntSet>)new Int2ObjectOpenHashMap(), null);
    @NotNull
    private final Int2ObjectMap<IntSet> myMap;
    @Nullable
    private final FList<DefinitionMap> closureFrames;

    private DefinitionMap(@NotNull Int2ObjectMap<IntSet> map2, @Nullable FList<DefinitionMap> closureFrames) {
        if (map2 == null) {
            DefinitionMap.$$$reportNull$$$0(0);
        }
        this.myMap = map2;
        this.closureFrames = closureFrames;
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withRegisteredDef(int varIndex, @NotNull Instruction instruction) {
        if (instruction == null) {
            DefinitionMap.$$$reportNull$$$0(1);
        }
        if (varIndex == 0) {
            DefinitionMap definitionMap = this;
            if (definitionMap == null) {
                DefinitionMap.$$$reportNull$$$0(2);
            }
            return definitionMap;
        }
        Int2ObjectOpenHashMap newMap = new Int2ObjectOpenHashMap(this.myMap);
        IntArraySet defs = new IntArraySet(1);
        newMap.put(varIndex, (Object)defs);
        defs.add(instruction.num());
        return new DefinitionMap((Int2ObjectMap<IntSet>)newMap, this.closureFrames);
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withNewClosureContext(@NotNull DefinitionMap map2) {
        if (map2 == null) {
            DefinitionMap.$$$reportNull$$$0(3);
        }
        return new DefinitionMap(this.myMap, (FList<DefinitionMap>)(this.closureFrames != null ? this.closureFrames : FList.emptyList()).prepend((Object)map2));
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withoutClosureContext() {
        assert (this.closureFrames != null);
        assert (!this.closureFrames.isEmpty());
        return new DefinitionMap(this.myMap, (FList<DefinitionMap>)this.closureFrames.getTail());
    }

    @Contract(pure=true)
    @NotNull
    public DefinitionMap withMerged(DefinitionMap other) {
        int key;
        if (other == this || other == NEUTRAL) {
            DefinitionMap definitionMap = this;
            if (definitionMap == null) {
                DefinitionMap.$$$reportNull$$$0(4);
            }
            return definitionMap;
        }
        if (this == NEUTRAL) {
            DefinitionMap definitionMap = other;
            if (definitionMap == null) {
                DefinitionMap.$$$reportNull$$$0(5);
            }
            return definitionMap;
        }
        Int2ObjectOpenHashMap newMap = new Int2ObjectOpenHashMap(this.myMap);
        SmartList toRemove = new SmartList();
        Object object = this.myMap.keySet().iterator();
        while (object.hasNext()) {
            key = (Integer)object.next();
            if (other.myMap.containsKey(key)) continue;
            toRemove.add(key);
        }
        object = toRemove.iterator();
        while (object.hasNext()) {
            key = (Integer)object.next();
            newMap.remove(key);
        }
        for (Int2ObjectMap.Entry entry : other.myMap.int2ObjectEntrySet()) {
            int varIndex = entry.getIntKey();
            IntSet otherVarDefs = (IntSet)entry.getValue();
            IntSet myDefs = (IntSet)newMap.get(varIndex);
            if (myDefs == null) continue;
            IntArraySet newDefs = new IntArraySet(myDefs);
            newDefs.addAll((IntCollection)otherVarDefs);
            newMap.put(varIndex, (Object)newDefs);
        }
        FList<DefinitionMap> actualFrame = this.closureFrames == null ? other.closureFrames : this.closureFrames;
        return new DefinitionMap((Int2ObjectMap<IntSet>)newMap, actualFrame);
    }

    @Nullable
    public IntSet getDefinitions(int varIndex) {
        return (IntSet)this.myMap.get(varIndex);
    }

    public void forEachValue(Consumer<IntSet> procedure) {
        this.myMap.values().forEach(procedure);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefinitionMap map2 = (DefinitionMap)o;
        return Objects.equals(this.myMap, map2.myMap) && Objects.equals(this.closureFrames, map2.closureFrames);
    }

    @Nullable
    public DefinitionMap getTopClosureState() {
        if (this.closureFrames == null || this.closureFrames.getHead() == null) {
            return null;
        }
        return (DefinitionMap)this.closureFrames.getHead();
    }

    public int hashCode() {
        return Objects.hash(this.myMap, System.identityHashCode(this.closureFrames));
    }

    public String toString() {
        return this.myMap + " | frame: " + (Serializable)(this.closureFrames == null ? "null" : Integer.valueOf(this.closureFrames.size()));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "map";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instruction";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/DefinitionMap";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/lang/psi/dataFlow/reachingDefs/DefinitionMap";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "withRegisteredDef";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "withMerged";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "withRegisteredDef";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "withNewClosureContext";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

