/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.groovy.util;

import com.intellij.codeInsight.generation.GenerateMembersUtil;
import com.intellij.codeInsight.generation.OverrideImplementUtil;
import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaTemplateUtil;
import com.intellij.ide.util.MemberChooser;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.util.PsiTypesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.groovy.lang.psi.GroovyFile;
import org.jetbrains.plugins.groovy.lang.psi.GroovyPsiElementFactory;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.GrModifierList;
import org.jetbrains.plugins.groovy.lang.psi.api.auxiliary.modifiers.annotation.GrAnnotation;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.blocks.GrOpenBlock;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.params.GrParameter;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.GrTypeDefinition;
import org.jetbrains.plugins.groovy.lang.psi.api.statements.typedef.members.GrMethod;
import org.jetbrains.plugins.groovy.lang.psi.api.types.GrTypeElement;
import org.jetbrains.plugins.groovy.lang.psi.impl.synthetic.GrTraitMethod;
import org.jetbrains.plugins.groovy.lang.psi.util.GrTraitUtil;
import org.jetbrains.plugins.groovy.util.GroovyChangeContextUtil;
import org.jetbrains.plugins.groovy.util.GroovyOverrideImplementExploreUtil;

public final class GroovyOverrideImplementUtil {
    private static final Logger LOG = Logger.getInstance(GroovyOverrideImplementUtil.class);

    private GroovyOverrideImplementUtil() {
    }

    public static GrMethod generateMethodPrototype(GrTypeDefinition aClass, PsiMethod method, PsiSubstitutor substitutor2) {
        Project project = aClass.getProject();
        boolean isAbstract = method.hasModifierProperty("abstract");
        String templName = isAbstract ? "Implemented Method Body.java" : "Overridden Method Body.java";
        FileTemplate template = FileTemplateManager.getInstance((Project)method.getProject()).getCodeTemplate(templName);
        GrMethod result2 = (GrMethod)GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)substitutor2, (PsiElement)aClass);
        GroovyOverrideImplementUtil.setupModifierList(result2);
        GroovyOverrideImplementUtil.setupOverridingMethodBody(project, method, result2, template, substitutor2);
        GroovyOverrideImplementUtil.setupReturnType(result2, method);
        GroovyOverrideImplementUtil.setupAnnotations(aClass, method, result2);
        GroovyChangeContextUtil.encodeContextInfo(result2);
        return result2;
    }

    public static GrMethod generateTraitMethodPrototype(GrTypeDefinition aClass, GrTraitMethod method, PsiSubstitutor substitutor2) {
        Project project = aClass.getProject();
        GrMethod result2 = (GrMethod)GenerateMembersUtil.substituteGenericMethod((PsiMethod)method, (PsiSubstitutor)substitutor2, (PsiElement)aClass);
        GroovyOverrideImplementUtil.setupModifierList(result2);
        GroovyOverrideImplementUtil.setupTraitMethodBody(project, result2, method);
        GroovyOverrideImplementUtil.setupReturnType(result2, (PsiMethod)method);
        GroovyOverrideImplementUtil.setupAnnotations(aClass, (PsiMethod)method, result2);
        GroovyChangeContextUtil.encodeContextInfo(result2);
        return result2;
    }

    private static void setupReturnType(GrMethod result2, PsiMethod method) {
        if (method instanceof GrMethod && ((GrMethod)method).getReturnTypeElementGroovy() == null) {
            result2.setReturnType(null);
            GrModifierList modifierList = result2.getModifierList();
            if (!modifierList.hasExplicitVisibilityModifiers()) {
                modifierList.setModifierProperty("def", true);
            }
        }
    }

    private static void setupAnnotations(@NotNull GrTypeDefinition aClass, @NotNull PsiMethod method, @NotNull GrMethod result2) {
        if (aClass == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(0);
        }
        if (method == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(1);
        }
        if (result2 == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(2);
        }
        if (OverrideImplementUtil.isInsertOverride((PsiMethod)method, (PsiClass)aClass)) {
            result2.getModifierList().addAnnotation("java.lang.Override");
        }
        GroovyPsiElementFactory factory = GroovyPsiElementFactory.getInstance(method.getProject());
        PsiParameter[] originalParams = method.getParameterList().getParameters();
        GrParameter[] parameters2 = result2.getParameters();
        for (int i = 0; i < parameters2.length; ++i) {
            GrParameter parameter = parameters2[i];
            PsiParameter original = originalParams[i];
            for (PsiAnnotation annotation : original.getModifierList().getAnnotations()) {
                GrModifierList modifierList = parameter.getModifierList();
                String qname = annotation.getQualifiedName();
                if (qname == null || modifierList.hasAnnotation(qname)) continue;
                if (annotation instanceof GrAnnotation) {
                    modifierList.add((PsiElement)annotation);
                    continue;
                }
                modifierList.add(factory.createAnnotationFromText(annotation.getText()));
            }
        }
    }

    private static void setupModifierList(GrMethod result2) {
        GrModifierList modifierList = result2.getModifierList();
        modifierList.setModifierProperty("abstract", false);
        modifierList.setModifierProperty("native", false);
    }

    @Nullable
    private static PsiType getSuperReturnType(@NotNull PsiMethod superMethod) {
        if (superMethod == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(3);
        }
        if (superMethod instanceof GrMethod) {
            GrTypeElement element = ((GrMethod)superMethod).getReturnTypeElementGroovy();
            return element != null ? element.getType() : null;
        }
        return superMethod.getReturnType();
    }

    private static void setupOverridingMethodBody(Project project, PsiMethod method, GrMethod resultMethod, FileTemplate template, PsiSubstitutor substitutor2) {
        PsiType returnType2 = substitutor2.substitute(GroovyOverrideImplementUtil.getSuperReturnType(method));
        String returnTypeText = "";
        if (returnType2 != null) {
            returnTypeText = returnType2.getPresentableText();
        }
        Properties properties = FileTemplateManager.getInstance((Project)project).getDefaultProperties();
        properties.setProperty("RETURN_TYPE", returnTypeText);
        properties.setProperty("DEFAULT_RETURN_VALUE", PsiTypesUtil.getDefaultValueOfType((PsiType)returnType2));
        properties.setProperty("CALL_SUPER", GroovyOverrideImplementUtil.callSuper(method, resultMethod));
        JavaTemplateUtil.setClassAndMethodNameProperties((Properties)properties, (PsiClass)method.getContainingClass(), (PsiMethod)resultMethod);
        try {
            String bodyText = StringUtil.replace((String)template.getText(properties), (String)";", (String)"");
            GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile("\n " + bodyText + "\n", false, null);
            GrOpenBlock block = resultMethod.getBlock();
            block.getNode().addChildren(file.getFirstChild().getNode(), null, block.getRBrace().getNode());
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    private static void setupTraitMethodBody(Project project, GrMethod resultMethod, GrTraitMethod traitMethod) {
        GrParameter[] parameters2;
        PsiClass traitClass = traitMethod.getPrototype().getContainingClass();
        @NlsSafe StringBuilder builder = new StringBuilder();
        builder.append("\nreturn ");
        builder.append(traitClass.getQualifiedName());
        builder.append(".super.");
        builder.append(traitMethod.getName());
        builder.append("(");
        for (GrParameter parameter : parameters2 = resultMethod.getParameters()) {
            builder.append(parameter.getName()).append(",");
        }
        if (parameters2.length > 0) {
            builder.replace(builder.length() - 1, builder.length(), ")\n");
        } else {
            builder.append(")\n");
        }
        GroovyFile file = GroovyPsiElementFactory.getInstance(project).createGroovyFile(builder, false, null);
        GrOpenBlock block = resultMethod.getBlock();
        block.getNode().addChildren(file.getFirstChild().getNode(), null, block.getRBrace().getNode());
    }

    public static void chooseAndOverrideMethods(@NotNull Project project, @NotNull Editor editor, @NotNull GrTypeDefinition aClass) {
        if (project == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(4);
        }
        if (editor == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(5);
        }
        if (aClass == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(6);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        GroovyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, false);
    }

    public static void chooseAndImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull GrTypeDefinition aClass) {
        if (project == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(7);
        }
        if (editor == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(8);
        }
        if (aClass == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(9);
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("codeassists.overrideimplement");
        GroovyOverrideImplementUtil.chooseAndOverrideOrImplementMethods(project, editor, aClass, true);
    }

    public static void chooseAndOverrideOrImplementMethods(@NotNull Project project, @NotNull Editor editor, @NotNull GrTypeDefinition aClass, boolean toImplement) {
        MemberChooser chooser;
        ArrayList<CandidateInfo> secondary;
        if (project == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(10);
        }
        if (editor == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(11);
        }
        if (aClass == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(12);
        }
        LOG.assertTrue(aClass.isValid());
        ApplicationManager.getApplication().assertReadAccessAllowed();
        Collection<CandidateInfo> candidates = GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(aClass, toImplement);
        Collection<CandidateInfo> collection = secondary = toImplement || aClass.isInterface() ? new ArrayList<CandidateInfo>() : GroovyOverrideImplementExploreUtil.getMethodsToOverrideImplement(aClass, true);
        if (toImplement) {
            Iterator<CandidateInfo> iterator2 = candidates.iterator();
            while (iterator2.hasNext()) {
                GrMethod method;
                CandidateInfo candidate = iterator2.next();
                PsiElement element = candidate.getElement();
                if (!(element instanceof GrMethod) || !GrTraitUtil.isTrait((method = (GrMethod)element).getContainingClass()) || GrTraitUtil.isMethodAbstract(method)) continue;
                iterator2.remove();
                secondary.add(candidate);
            }
        }
        if ((chooser = OverrideImplementUtil.showOverrideImplementChooser((Editor)editor, (PsiElement)aClass, (boolean)toImplement, candidates, secondary)) == null) {
            return;
        }
        List selectedElements = chooser.getSelectedElements();
        if (selectedElements == null || selectedElements.isEmpty()) {
            return;
        }
        LOG.assertTrue(aClass.isValid());
        WriteCommandAction.writeCommandAction((Project)project, (PsiFile[])new PsiFile[]{aClass.getContainingFile()}).run(() -> OverrideImplementUtil.overrideOrImplementMethodsInRightPlace((Editor)editor, (PsiClass)aClass, (Collection)selectedElements, (boolean)chooser.isCopyJavadoc(), (boolean)chooser.isInsertOverrideAnnotation()));
    }

    @NotNull
    private static String callSuper(PsiMethod superMethod, PsiMethod overriding) {
        @NonNls StringBuilder buffer = new StringBuilder();
        if (!superMethod.isConstructor() && !PsiType.VOID.equals((Object)superMethod.getReturnType())) {
            buffer.append("return ");
        }
        buffer.append("super");
        PsiParameter[] parms = overriding.getParameterList().getParameters();
        if (!superMethod.isConstructor()) {
            buffer.append(".");
            buffer.append(superMethod.getName());
        }
        buffer.append("(");
        for (int i = 0; i < parms.length; ++i) {
            String name = parms[i].getName();
            if (i > 0) {
                buffer.append(",");
            }
            buffer.append(name);
        }
        buffer.append(")");
        String string = buffer.toString();
        if (string == null) {
            GroovyOverrideImplementUtil.$$$reportNull$$$0(13);
        }
        return string;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 13: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 13: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aClass";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "method";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "superMethod";
                break;
            }
            case 4: 
            case 7: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 5: 
            case 8: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "editor";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementUtil";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/plugins/groovy/util/GroovyOverrideImplementUtil";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "callSuper";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "setupAnnotations";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getSuperReturnType";
                break;
            }
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideMethods";
                break;
            }
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndImplementMethods";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "chooseAndOverrideOrImplementMethods";
                break;
            }
            case 13: {
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 13: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

