/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice;

import groovy.lang.Closure;
import java.io.File;
import java.util.List;
import java.util.Set;
import org.gradle.api.Action;
import org.gradle.api.artifacts.Dependency;
import org.gradle.api.artifacts.LenientConfiguration;
import org.gradle.api.artifacts.ResolveException;
import org.gradle.api.artifacts.ResolvedArtifact;
import org.gradle.api.artifacts.ResolvedConfiguration;
import org.gradle.api.artifacts.ResolvedDependency;
import org.gradle.api.artifacts.UnresolvedDependency;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.result.DependencyResult;
import org.gradle.api.artifacts.result.ResolutionResult;
import org.gradle.api.artifacts.result.ResolvedComponentResult;
import org.gradle.api.attributes.AttributeContainer;
import org.gradle.api.internal.artifacts.ConfigurationResolver;
import org.gradle.api.internal.artifacts.ResolveContext;
import org.gradle.api.internal.artifacts.ResolverResults;
import org.gradle.api.internal.artifacts.configurations.ConfigurationInternal;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ArtifactVisitor;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.SelectedArtifactSet;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.VisitedArtifactSet;
import org.gradle.api.internal.artifacts.repositories.ResolutionAwareRepository;
import org.gradle.api.internal.attributes.AttributeContainerInternal;
import org.gradle.api.internal.provider.DefaultProvider;
import org.gradle.api.internal.tasks.TaskDependencyResolveContext;
import org.gradle.api.provider.Provider;
import org.gradle.api.specs.Spec;

public class ErrorHandlingConfigurationResolver
implements ConfigurationResolver {
    private final ConfigurationResolver delegate;

    public ErrorHandlingConfigurationResolver(ConfigurationResolver delegate) {
        this.delegate = delegate;
    }

    @Override
    public List<ResolutionAwareRepository> getRepositories() {
        return this.delegate.getRepositories();
    }

    @Override
    public void resolveBuildDependencies(ConfigurationInternal configuration2, ResolverResults results) {
        try {
            this.delegate.resolveBuildDependencies(configuration2, results);
        }
        catch (Exception e) {
            results.failed(ErrorHandlingConfigurationResolver.wrapException(e, configuration2));
            BrokenResolvedConfiguration broken = new BrokenResolvedConfiguration(e, configuration2);
            results.artifactsResolved(broken, broken);
        }
    }

    @Override
    public void resolveGraph(ConfigurationInternal configuration2, ResolverResults results) throws ResolveException {
        try {
            this.delegate.resolveGraph(configuration2, results);
        }
        catch (Exception e) {
            results.failed(ErrorHandlingConfigurationResolver.wrapException(e, configuration2));
            BrokenResolvedConfiguration broken = new BrokenResolvedConfiguration(e, configuration2);
            results.artifactsResolved(broken, broken);
            return;
        }
        ErrorHandlingResolutionResult wrappedResult = new ErrorHandlingResolutionResult(results.getResolutionResult(), configuration2);
        results.graphResolved(wrappedResult, results.getResolvedLocalComponents(), results.getVisitedArtifacts());
    }

    @Override
    public void resolveArtifacts(ConfigurationInternal configuration2, ResolverResults results) throws ResolveException {
        try {
            this.delegate.resolveArtifacts(configuration2, results);
        }
        catch (Exception e) {
            BrokenResolvedConfiguration broken = new BrokenResolvedConfiguration(e, configuration2);
            results.artifactsResolved(broken, broken);
            return;
        }
        ErrorHandlingResolvedConfiguration wrappedConfiguration = new ErrorHandlingResolvedConfiguration(results.getResolvedConfiguration(), configuration2);
        results.artifactsResolved(wrappedConfiguration, results.getVisitedArtifacts());
    }

    static ResolveException wrapException(Throwable e, ResolveContext resolveContext) {
        if (e instanceof ResolveException) {
            ResolveException resolveException = (ResolveException)e;
            return ErrorHandlingConfigurationResolver.maybeAddHintToResolveException(resolveContext, resolveException);
        }
        return ErrorHandlingConfigurationResolver.maybeAddHintToResolveException(resolveContext, new ResolveException(resolveContext.getDisplayName(), e));
    }

    private static ResolveException maybeAddHintToResolveException(ResolveContext resolveContext, ResolveException resolveException) {
        if (resolveContext instanceof ConfigurationInternal) {
            ConfigurationInternal config = (ConfigurationInternal)resolveContext;
            return config.maybeAddContext(resolveException);
        }
        return resolveException;
    }

    private static class BrokenResolvedConfiguration
    implements ResolvedConfiguration,
    VisitedArtifactSet,
    SelectedArtifactSet {
        private final Throwable ex;
        private final ConfigurationInternal configuration;

        public BrokenResolvedConfiguration(Throwable ex, ConfigurationInternal configuration2) {
            this.ex = ex;
            this.configuration = configuration2;
        }

        @Override
        public boolean hasError() {
            return true;
        }

        @Override
        public LenientConfiguration getLenientConfiguration() {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public Set<File> getFiles() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            throw ErrorHandlingConfigurationResolver.wrapException(this.ex, this.configuration);
        }

        @Override
        public SelectedArtifactSet select(Spec<? super Dependency> dependencySpec, AttributeContainerInternal requestedAttributes, Spec<? super ComponentIdentifier> componentSpec, boolean allowNoMatchingVariant) {
            return this;
        }

        @Override
        public void visitDependencies(TaskDependencyResolveContext context) {
            context.visitFailure(this.ex);
        }

        @Override
        public void visitArtifacts(ArtifactVisitor visitor, boolean continueOnSelectionFailure) {
            visitor.visitFailure(this.ex);
        }
    }

    private static class ErrorHandlingResolvedConfiguration
    implements ResolvedConfiguration {
        private final ResolvedConfiguration resolvedConfiguration;
        private final ConfigurationInternal configuration;

        public ErrorHandlingResolvedConfiguration(ResolvedConfiguration resolvedConfiguration, ConfigurationInternal configuration2) {
            this.resolvedConfiguration = resolvedConfiguration;
            this.configuration = configuration2;
        }

        @Override
        public boolean hasError() {
            return this.resolvedConfiguration.hasError();
        }

        @Override
        public LenientConfiguration getLenientConfiguration() {
            try {
                return new ErrorHandlingLenientConfiguration(this.resolvedConfiguration.getLenientConfiguration(), this.configuration);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public void rethrowFailure() throws ResolveException {
            try {
                this.resolvedConfiguration.rethrowFailure();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<File> getFiles() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles();
            }
            catch (ResolveException e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) throws ResolveException {
            try {
                return this.resolvedConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }

        @Override
        public Set<ResolvedArtifact> getResolvedArtifacts() throws ResolveException {
            try {
                return this.resolvedConfiguration.getResolvedArtifacts();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.configuration);
            }
        }
    }

    private static class ErrorHandlingResolutionResult
    implements ResolutionResult {
        private final ResolutionResult resolutionResult;
        private final ResolveContext resolveContext;

        public ErrorHandlingResolutionResult(ResolutionResult resolutionResult, ResolveContext configuration2) {
            this.resolutionResult = resolutionResult;
            this.resolveContext = configuration2;
        }

        @Override
        public ResolvedComponentResult getRoot() {
            try {
                return this.resolutionResult.getRoot();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Provider<ResolvedComponentResult> getRootComponent() {
            return new DefaultProvider<ResolvedComponentResult>(this::getRoot);
        }

        @Override
        public void allDependencies(Action<? super DependencyResult> action) {
            this.resolutionResult.allDependencies(action);
        }

        @Override
        public Set<? extends DependencyResult> getAllDependencies() {
            try {
                return this.resolutionResult.getAllDependencies();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public void allDependencies(Closure closure) {
            this.resolutionResult.allDependencies(closure);
        }

        @Override
        public Set<ResolvedComponentResult> getAllComponents() {
            try {
                return this.resolutionResult.getAllComponents();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public void allComponents(Action<? super ResolvedComponentResult> action) {
            this.resolutionResult.allComponents(action);
        }

        @Override
        public void allComponents(Closure closure) {
            this.resolutionResult.allComponents(closure);
        }

        @Override
        public AttributeContainer getRequestedAttributes() {
            return this.resolutionResult.getRequestedAttributes();
        }
    }

    private static class ErrorHandlingLenientConfiguration
    implements LenientConfiguration {
        private final LenientConfiguration lenientConfiguration;
        private final ResolveContext resolveContext;

        private ErrorHandlingLenientConfiguration(LenientConfiguration lenientConfiguration, ResolveContext resolveContext) {
            this.lenientConfiguration = lenientConfiguration;
            this.resolveContext = resolveContext;
        }

        @Override
        public Set<ResolvedArtifact> getArtifacts() {
            try {
                return this.lenientConfiguration.getArtifacts();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<ResolvedArtifact> getArtifacts(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getArtifacts(dependencySpec);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies() {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<ResolvedDependency> getFirstLevelModuleDependencies(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFirstLevelModuleDependencies(dependencySpec);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<ResolvedDependency> getAllModuleDependencies() {
            try {
                return this.lenientConfiguration.getAllModuleDependencies();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<UnresolvedDependency> getUnresolvedModuleDependencies() {
            try {
                return this.lenientConfiguration.getUnresolvedModuleDependencies();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<File> getFiles() {
            try {
                return this.lenientConfiguration.getFiles();
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }

        @Override
        public Set<File> getFiles(Spec<? super Dependency> dependencySpec) {
            try {
                return this.lenientConfiguration.getFiles(dependencySpec);
            }
            catch (Exception e) {
                throw ErrorHandlingConfigurationResolver.wrapException(e, this.resolveContext);
            }
        }
    }
}

