/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.publish.internal.metadata;

import java.io.IOException;
import java.util.List;
import org.gradle.internal.impldep.com.google.gson.stream.JsonWriter;

abstract class JsonWriterScope {
    private final JsonWriter jsonWriter;

    protected JsonWriterScope(JsonWriter jsonWriter) {
        this.jsonWriter = jsonWriter;
    }

    protected void writeArray(String name, List<String> elements) throws IOException {
        this.writeArray(name, () -> {
            for (String element : elements) {
                this.jsonWriter.value(element);
            }
        });
    }

    protected void writeArray(String name, Contents contents) throws IOException {
        this.jsonWriter.name(name);
        this.writeArray(contents);
    }

    protected void writeArray(Contents contents) throws IOException {
        this.jsonWriter.beginArray();
        contents.write();
        this.endArray();
    }

    protected void beginArray(String name) throws IOException {
        this.jsonWriter.name(name);
        this.jsonWriter.beginArray();
    }

    protected void endArray() throws IOException {
        this.jsonWriter.endArray();
    }

    protected void writeObject(String name, Contents contents) throws IOException {
        this.jsonWriter.name(name);
        this.writeObject(contents);
    }

    protected void writeObject(Contents contents) throws IOException {
        this.jsonWriter.beginObject();
        contents.write();
        this.jsonWriter.endObject();
    }

    protected void write(String name, Number number) throws IOException {
        this.jsonWriter.name(name).value(number);
    }

    protected void write(String name, long length) throws IOException {
        this.jsonWriter.name(name).value(length);
    }

    protected void write(String name, boolean value) throws IOException {
        this.jsonWriter.name(name).value(value);
    }

    protected void write(String name, String value) throws IOException {
        this.jsonWriter.name(name).value(value);
    }

    protected static interface Contents {
        public void write() throws IOException;
    }
}

