/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.execution.plan;

import java.util.Collections;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import org.gradle.api.Action;
import org.gradle.api.internal.project.ProjectInternal;
import org.gradle.api.internal.tasks.NodeExecutionContext;
import org.gradle.api.internal.tasks.TaskDependencyContainer;
import org.gradle.api.internal.tasks.WorkNodeAction;
import org.gradle.execution.plan.Node;
import org.gradle.execution.plan.SelfExecutingNode;
import org.gradle.execution.plan.TaskDependencyResolver;
import org.gradle.internal.resources.ResourceLock;

public class ActionNode
extends Node
implements SelfExecutingNode {
    private final WorkNodeAction action;
    private final ProjectInternal owningProject;
    private final ProjectInternal projectToLock;

    public ActionNode(WorkNodeAction action) {
        this.action = action;
        this.owningProject = (ProjectInternal)action.getOwningProject();
        this.projectToLock = this.owningProject != null && action.usesMutableProjectState() ? this.owningProject : null;
    }

    @Override
    @Nullable
    public Throwable getNodeFailure() {
        return null;
    }

    @Override
    public void rethrowNodeFailure() {
    }

    @Override
    public void prepareForExecution() {
    }

    @Override
    public void resolveDependencies(TaskDependencyResolver dependencyResolver, Action<Node> processHardSuccessor) {
        TaskDependencyContainer dependencies = this.action::visitDependencies;
        for (Node node : dependencyResolver.resolveDependenciesFor(null, dependencies)) {
            this.addDependencySuccessor(node);
            processHardSuccessor.execute(node);
        }
    }

    @Override
    public Set<Node> getFinalizers() {
        return Collections.emptySet();
    }

    @Override
    public void resolveMutations() {
    }

    public WorkNodeAction getAction() {
        return this.action;
    }

    @Override
    public boolean isPublicNode() {
        return false;
    }

    @Override
    public boolean requiresMonitoring() {
        return false;
    }

    @Override
    public String toString() {
        return "work action " + this.action;
    }

    @Override
    public int compareTo(Node o) {
        return -1;
    }

    @Override
    @Nullable
    public ResourceLock getProjectToLock() {
        if (this.projectToLock != null) {
            return this.projectToLock.getOwner().getAccessLock();
        }
        return null;
    }

    @Override
    @Nullable
    public ProjectInternal getOwningProject() {
        return this.owningProject;
    }

    public List<ResourceLock> getResourcesToLock() {
        return Collections.emptyList();
    }

    @Override
    public void execute(NodeExecutionContext context) {
        this.action.run(context);
    }
}

