/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.collect;

import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.CheckReturnValue;

public abstract class PersistentList<T> {
    private static final PersistentList<Object> NIL = new PersistentList<Object>(){

        @Override
        public void forEach(Consumer<? super Object> consumer) {
        }

        @Override
        public PersistentList<Object> plus(Object element) {
            return new Cons<Object>(element, this);
        }

        public String toString() {
            return "Nil";
        }
    };

    public static <T> PersistentList<T> of() {
        return NIL;
    }

    public static <T> PersistentList<T> of(T first) {
        return PersistentList.of().plus(first);
    }

    @SafeVarargs
    public static <T> PersistentList<T> of(T first, T second, T ... rest) {
        PersistentList<T> result2 = PersistentList.of();
        for (int i = rest.length - 1; i >= 0; --i) {
            result2 = result2.plus(rest[i]);
        }
        return result2.plus(second).plus(first);
    }

    public abstract void forEach(Consumer<? super T> var1);

    @CheckReturnValue
    public abstract PersistentList<T> plus(T var1);

    private PersistentList() {
    }

    private static class Cons<T>
    extends PersistentList<T> {
        private final T head;
        private final PersistentList<T> tail;

        public Cons(T head, PersistentList<T> tail) {
            this.head = head;
            this.tail = tail;
        }

        @Override
        public void forEach(Consumer<? super T> consumer) {
            consumer.accept(this.head);
            this.tail.forEach(consumer);
        }

        @Override
        public PersistentList<T> plus(T element) {
            return new Cons<T>(element, this);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Cons cons = (Cons)o;
            return this.head.equals(cons.head) && this.tail.equals(cons.tail);
        }

        public int hashCode() {
            return Objects.hash(this.head, this.tail);
        }

        public String toString() {
            return this.tail == NIL ? this.head.toString() : this.head + " : " + this.tail;
        }
    }
}

