/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.filewatch;

import org.gradle.initialization.BuildCancellationToken;
import org.gradle.initialization.ContinuousExecutionGate;
import org.gradle.internal.filewatch.DefaultFileSystemChangeWaiter;
import org.gradle.internal.filewatch.DefaultGatedChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiter;
import org.gradle.internal.filewatch.FileSystemChangeWaiterFactory;
import org.gradle.internal.filewatch.FileWatcherFactory;
import org.gradle.internal.filewatch.PendingChangesListener;

public class DefaultFileSystemChangeWaiterFactory
implements FileSystemChangeWaiterFactory {
    public static final String QUIET_PERIOD_SYSPROP = "org.gradle.internal.filewatch.quietperiod";
    private final FileWatcherFactory fileWatcherFactory;
    private final long quietPeriodMillis;

    public DefaultFileSystemChangeWaiterFactory(FileWatcherFactory fileWatcherFactory) {
        this(fileWatcherFactory, DefaultFileSystemChangeWaiterFactory.getDefaultQuietPeriod());
    }

    private static long getDefaultQuietPeriod() {
        return Long.getLong(QUIET_PERIOD_SYSPROP, 250L);
    }

    public DefaultFileSystemChangeWaiterFactory(FileWatcherFactory fileWatcherFactory, long quietPeriodMillis) {
        this.fileWatcherFactory = fileWatcherFactory;
        this.quietPeriodMillis = quietPeriodMillis;
    }

    @Override
    public FileSystemChangeWaiter createChangeWaiter(PendingChangesListener listener2, BuildCancellationToken cancellationToken, ContinuousExecutionGate continuousExecutionGate) {
        return new DefaultGatedChangeWaiter(new DefaultFileSystemChangeWaiter(this.fileWatcherFactory, listener2, this.quietPeriodMillis, cancellationToken), cancellationToken, continuousExecutionGate);
    }
}

