/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.net.URI;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.operations.BuildOperationContext;
import org.gradle.internal.operations.BuildOperationDescriptor;
import org.gradle.internal.operations.BuildOperationExecutor;
import org.gradle.internal.operations.CallableBuildOperation;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ExternalResourceReadBuildOperationType;
import org.gradle.internal.resource.ExternalResourceReadMetadataBuildOperationType;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractProgressLoggingHandler;
import org.gradle.internal.resource.transfer.ExternalResourceAccessor;
import org.gradle.internal.resource.transfer.ResourceOperation;

public class ProgressLoggingExternalResourceAccessor
extends AbstractProgressLoggingHandler
implements ExternalResourceAccessor {
    private final ExternalResourceAccessor delegate;
    private final BuildOperationExecutor buildOperationExecutor;
    private static final ExternalResourceReadMetadataBuildOperationType.Result METADATA_RESULT = new ExternalResourceReadMetadataBuildOperationType.Result(){};

    public ProgressLoggingExternalResourceAccessor(ExternalResourceAccessor delegate, BuildOperationExecutor buildOperationExecutor) {
        this.delegate = delegate;
        this.buildOperationExecutor = buildOperationExecutor;
    }

    @Override
    @Nullable
    public <T> T withContent(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) throws ResourceException {
        return this.buildOperationExecutor.call(new DownloadOperation<T>(location, revalidate, action));
    }

    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) {
        return this.buildOperationExecutor.call(new MetadataOperation(location, revalidate));
    }

    private BuildOperationDescriptor.Builder createBuildOperationDetails(ExternalResourceName resourceName) {
        ReadOperationDetails operationDetails = new ReadOperationDetails(resourceName.getUri());
        return BuildOperationDescriptor.displayName("Download " + resourceName.getUri()).progressDisplayName(resourceName.getShortDisplayName()).details(operationDetails);
    }

    private class MetadataOperation
    implements CallableBuildOperation<ExternalResourceMetaData> {
        private final ExternalResourceName location;
        private final boolean revalidate;

        public MetadataOperation(ExternalResourceName location, boolean revalidate) {
            this.location = location;
            this.revalidate = revalidate;
        }

        @Override
        public ExternalResourceMetaData call(BuildOperationContext context) {
            try {
                ExternalResourceMetaData externalResourceMetaData = ProgressLoggingExternalResourceAccessor.this.delegate.getMetaData(this.location, this.revalidate);
                return externalResourceMetaData;
            }
            finally {
                context.setResult(METADATA_RESULT);
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return BuildOperationDescriptor.displayName("Metadata of " + this.location.getDisplayName()).details(new MetadataOperationDetails(this.location.getUri()));
        }
    }

    private class DownloadOperation<T>
    implements CallableBuildOperation<T> {
        private final ExternalResourceName location;
        private final boolean revalidate;
        private final ExternalResource.ContentAndMetadataAction<T> action;

        public DownloadOperation(ExternalResourceName location, boolean revalidate, ExternalResource.ContentAndMetadataAction<T> action) {
            this.location = location;
            this.revalidate = revalidate;
            this.action = action;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T call(BuildOperationContext context) {
            ResourceOperation downloadOperation = ProgressLoggingExternalResourceAccessor.this.createResourceOperation(context, ResourceOperation.Type.download);
            try {
                Object object = ProgressLoggingExternalResourceAccessor.this.delegate.withContent(this.location, this.revalidate, (inputStream, metaData) -> {
                    downloadOperation.setContentLength(metaData.getContentLength());
                    AbstractProgressLoggingHandler.ProgressLoggingInputStream stream = new AbstractProgressLoggingHandler.ProgressLoggingInputStream(inputStream, downloadOperation);
                    return this.action.execute(stream, metaData);
                });
                return (T)object;
            }
            finally {
                context.setResult(new ReadOperationResult(downloadOperation.getTotalProcessedBytes()));
            }
        }

        @Override
        public BuildOperationDescriptor.Builder description() {
            return ProgressLoggingExternalResourceAccessor.this.createBuildOperationDetails(this.location);
        }
    }

    private static class ReadOperationResult
    implements ExternalResourceReadBuildOperationType.Result {
        private final long bytesRead;

        private ReadOperationResult(long bytesRead) {
            this.bytesRead = bytesRead;
        }

        @Override
        public long getBytesRead() {
            return this.bytesRead;
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Result{bytesRead=" + this.bytesRead + '}';
        }
    }

    private static class ReadOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceReadBuildOperationType.Details {
        private ReadOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }

    private static class MetadataOperationDetails
    extends AbstractProgressLoggingHandler.LocationDetails
    implements ExternalResourceReadMetadataBuildOperationType.Details {
        private MetadataOperationDetails(URI location) {
            super(location);
        }

        public String toString() {
            return "ExternalResourceReadMetadataBuildOperationType.Details{location=" + this.getLocation() + ", " + '}';
        }
    }
}

