/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.internal.resource.transfer;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import javax.annotation.Nullable;
import org.gradle.api.resources.ResourceException;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.resource.ExternalResource;
import org.gradle.internal.resource.ExternalResourceName;
import org.gradle.internal.resource.ReadableContent;
import org.gradle.internal.resource.ResourceExceptions;
import org.gradle.internal.resource.metadata.DefaultExternalResourceMetaData;
import org.gradle.internal.resource.metadata.ExternalResourceMetaData;
import org.gradle.internal.resource.transfer.AbstractExternalResourceAccessor;
import org.gradle.internal.resource.transfer.AccessorBackedExternalResource;
import org.gradle.internal.resource.transfer.ExternalResourceConnector;
import org.gradle.internal.resource.transfer.ExternalResourceReadResponse;

public class UrlExternalResource
extends AbstractExternalResourceAccessor
implements ExternalResourceConnector {
    public static ExternalResource open(URL url) throws IOException {
        URI uri;
        try {
            uri = url.toURI();
        }
        catch (URISyntaxException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        UrlExternalResource connector = new UrlExternalResource();
        return new AccessorBackedExternalResource(new ExternalResourceName(uri), connector, connector, connector, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @Nullable
    public ExternalResourceMetaData getMetaData(ExternalResourceName location, boolean revalidate) throws ResourceException {
        DefaultExternalResourceMetaData defaultExternalResourceMetaData;
        URL url = location.getUri().toURL();
        URLConnection connection = url.openConnection();
        try {
            defaultExternalResourceMetaData = new DefaultExternalResourceMetaData(location.getUri(), connection.getLastModified(), (long)connection.getContentLength(), connection.getContentType(), null, null);
        }
        catch (Throwable throwable) {
            try {
                connection.getInputStream().close();
                throw throwable;
            }
            catch (FileNotFoundException e) {
                return null;
            }
            catch (Exception e) {
                throw ResourceExceptions.getFailed(location.getUri(), e);
            }
        }
        connection.getInputStream().close();
        return defaultExternalResourceMetaData;
    }

    @Override
    @Nullable
    public ExternalResourceReadResponse openResource(final ExternalResourceName location, boolean revalidate) throws ResourceException {
        try {
            URL url = location.getUri().toURL();
            final URLConnection connection = url.openConnection();
            final InputStream inputStream = connection.getInputStream();
            return new ExternalResourceReadResponse(){

                @Override
                public InputStream openStream() {
                    return inputStream;
                }

                @Override
                public ExternalResourceMetaData getMetaData() {
                    return new DefaultExternalResourceMetaData(location.getUri(), connection.getLastModified(), (long)connection.getContentLength(), connection.getContentType(), null, null);
                }

                @Override
                public void close() throws IOException {
                    inputStream.close();
                }
            };
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (Exception e) {
            throw ResourceExceptions.getFailed(location.getUri(), e);
        }
    }

    @Override
    @Nullable
    public List<String> list(ExternalResourceName parent) throws ResourceException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void upload(ReadableContent resource, ExternalResourceName destination) throws IOException {
        throw new UnsupportedOperationException();
    }
}

