/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.jvm.toolchain.install.internal;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.EmptyFileVisitor;
import org.gradle.api.file.FileTree;
import org.gradle.api.file.FileTreeElement;
import org.gradle.api.file.FileVisitDetails;
import org.gradle.api.internal.file.FileOperations;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.internal.filelock.LockOptionsBuilder;
import org.gradle.initialization.GradleUserHomeDirProvider;
import org.gradle.internal.impldep.com.google.common.io.Files;
import org.gradle.internal.impldep.org.apache.commons.io.FilenameUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdkCacheDirectory {
    private static final Logger LOGGER = LoggerFactory.getLogger(JdkCacheDirectory.class);
    private static final String MARKER_FILE = "provisioned.ok";
    private static final String MAC_OS_JAVA_HOME_FOLDER = "Contents/Home";
    private final FileOperations operations;
    private final File jdkDirectory;
    private final FileLockManager lockManager;

    public JdkCacheDirectory(GradleUserHomeDirProvider homeDirProvider, FileOperations operations, FileLockManager lockManager) {
        this.operations = operations;
        this.jdkDirectory = new File(homeDirProvider.getGradleUserHomeDirectory(), "jdks");
        this.lockManager = lockManager;
        this.jdkDirectory.mkdir();
    }

    public Set<File> listJavaHomes() {
        File[] files = this.jdkDirectory.listFiles();
        if (files != null) {
            return Arrays.stream(files).filter(this.isValidInstallation()).map(this::findJavaHome).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Predicate<File> isValidInstallation() {
        return home -> home.isDirectory() && new File((File)home, MARKER_FILE).exists();
    }

    private File findJavaHome(File potentialHome) {
        if (new File(potentialHome, MAC_OS_JAVA_HOME_FOLDER).exists()) {
            return new File(potentialHome, MAC_OS_JAVA_HOME_FOLDER);
        }
        File[] subfolders = potentialHome.listFiles(File::isDirectory);
        if (subfolders != null) {
            for (File subfolder : subfolders) {
                if (!new File(subfolder, MAC_OS_JAVA_HOME_FOLDER).exists()) continue;
                return new File(subfolder, MAC_OS_JAVA_HOME_FOLDER);
            }
        }
        return potentialHome;
    }

    public File provisionFromArchive(File jdkArchive) {
        File destination = this.unpack(jdkArchive);
        this.markAsReady(destination);
        return this.findJavaHome(destination);
    }

    private void markAsReady(File destination) {
        try {
            new File(destination, MARKER_FILE).createNewFile();
        }
        catch (IOException e) {
            throw new UncheckedIOException("Unable to create .ok file", e);
        }
    }

    private File unpack(File jdkArchive) {
        FileTree fileTree = this.asFileTree(jdkArchive);
        String rootName = this.getRootDirectory(fileTree);
        String installRootName = JdkCacheDirectory.getNameWithoutExtension(jdkArchive);
        File installLocation = new File(this.jdkDirectory, installRootName);
        if (!installLocation.exists()) {
            this.operations.copy(spec -> {
                spec.from(fileTree);
                spec.into(this.jdkDirectory);
                spec.exclude(FileTreeElement::isDirectory);
                spec.eachFile(fileCopyDetails -> {
                    String path = fileCopyDetails.getPath();
                    if (path.startsWith(rootName)) {
                        String newPath = installRootName + path.substring(rootName.length());
                        fileCopyDetails.setPath(newPath);
                    }
                });
            });
            LOGGER.info("Installed {} into {}", (Object)jdkArchive.getName(), (Object)installLocation);
        }
        return installLocation;
    }

    private String getRootDirectory(FileTree fileTree) {
        final AtomicReference rootDirName = new AtomicReference();
        fileTree.visit(new EmptyFileVisitor(){

            @Override
            public void visitDir(FileVisitDetails details) {
                rootDirName.compareAndSet(null, details.getName());
            }
        });
        return (String)rootDirName.get();
    }

    private FileTree asFileTree(File jdkArchive) {
        String extension = FilenameUtils.getExtension((String)jdkArchive.getName());
        if (Objects.equals(extension, "zip")) {
            return this.operations.zipTree(jdkArchive);
        }
        return this.operations.tarTree(this.operations.getResources().gzip(jdkArchive));
    }

    public FileLock acquireWriteLock(File destinationFile, String operationName) {
        return this.lockManager.lock(destinationFile, LockOptionsBuilder.mode(FileLockManager.LockMode.Exclusive), destinationFile.getName(), operationName);
    }

    public File getDownloadLocation(String filename) {
        return new File(this.jdkDirectory, filename);
    }

    private static String getNameWithoutExtension(File file) {
        String input;
        String output = file.getName();
        while (!(input = output).equals(output = Files.getNameWithoutExtension((String)input))) {
        }
        return output;
    }
}

