/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.launcher.daemon.server.api;

import java.util.LinkedList;
import java.util.List;
import org.gradle.launcher.daemon.configuration.DaemonServerConfiguration;
import org.gradle.launcher.daemon.context.DaemonContext;
import org.gradle.launcher.daemon.protocol.Command;
import org.gradle.launcher.daemon.server.api.DaemonCommandAction;
import org.gradle.launcher.daemon.server.api.DaemonConnection;
import org.gradle.launcher.daemon.server.api.DaemonStateControl;

public class DaemonCommandExecution {
    private final DaemonServerConfiguration configuration;
    private final DaemonConnection connection;
    private final Command command;
    private final DaemonContext daemonContext;
    private final DaemonStateControl daemonStateControl;
    private final LinkedList<DaemonCommandAction> actions;
    private Object result;

    public DaemonCommandExecution(DaemonServerConfiguration configuration2, DaemonConnection connection, Command command, DaemonContext daemonContext, DaemonStateControl daemonStateControl, List<DaemonCommandAction> actions) {
        this.configuration = configuration2;
        this.connection = connection;
        this.command = command;
        this.daemonContext = daemonContext;
        this.daemonStateControl = daemonStateControl;
        this.actions = new LinkedList<DaemonCommandAction>(actions);
    }

    public DaemonConnection getConnection() {
        return this.connection;
    }

    public Command getCommand() {
        return this.command;
    }

    public DaemonContext getDaemonContext() {
        return this.daemonContext;
    }

    public DaemonStateControl getDaemonStateControl() {
        return this.daemonStateControl;
    }

    public void setResult(Object result2) {
        this.result = result2;
    }

    public Object getResult() {
        return this.result;
    }

    public boolean proceed() {
        if (this.actions.isEmpty()) {
            return false;
        }
        this.actions.removeFirst().execute(this);
        return true;
    }

    public boolean isSingleUseDaemon() {
        return this.configuration.isSingleUse();
    }

    public String toString() {
        return String.format("DaemonCommandExecution[command = %s, connection = %s]", this.command, this.connection);
    }
}

