/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.process.internal.worker.request;

import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.gradle.internal.UncheckedException;
import org.gradle.internal.dispatch.StreamCompletion;
import org.gradle.internal.logging.events.OutputEventListener;
import org.gradle.internal.remote.internal.hub.StreamFailureHandler;
import org.gradle.process.internal.worker.DefaultWorkerLoggingProtocol;
import org.gradle.process.internal.worker.WorkerProcessException;
import org.gradle.process.internal.worker.request.ResponseProtocol;

public class Receiver
extends DefaultWorkerLoggingProtocol
implements ResponseProtocol,
StreamCompletion,
StreamFailureHandler {
    private static final Object NULL = new Object();
    private static final Object END = new Object();
    private final BlockingQueue<Object> received = new ArrayBlockingQueue<Object>(10);
    private final String baseName;
    private Object next;

    public Receiver(String baseName, OutputEventListener outputEventListener) {
        super(outputEventListener);
        this.baseName = baseName;
    }

    public boolean awaitNextResult() {
        try {
            if (this.next == null) {
                this.next = this.received.take();
            }
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
        return this.next != END;
    }

    public Object getNextResult() {
        this.awaitNextResult();
        Object next = this.next;
        if (next == END) {
            throw new IllegalStateException("No response received.");
        }
        this.next = null;
        if (next instanceof Failure) {
            Failure failure = (Failure)next;
            throw UncheckedException.throwAsUncheckedException(failure.failure);
        }
        return next == NULL ? null : next;
    }

    @Override
    public void handleStreamFailure(Throwable t) {
        this.failed(t);
    }

    @Override
    public void endStream() {
        try {
            this.received.put(END);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void completed(Object result2) {
        try {
            this.received.put(result2 == null ? NULL : result2);
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    @Override
    public void infrastructureFailed(Throwable failure) {
        this.failed(WorkerProcessException.runFailed(this.baseName, failure));
    }

    @Override
    public void failed(Throwable failure) {
        try {
            this.received.put(new Failure(failure));
        }
        catch (InterruptedException e) {
            throw UncheckedException.throwAsUncheckedException(e);
        }
    }

    static class Failure {
        final Throwable failure;

        public Failure(Throwable failure) {
            this.failure = failure;
        }
    }
}

