/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.provider.action;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.gradle.api.Transformer;
import org.gradle.api.internal.StartParameterInternal;
import org.gradle.internal.build.event.BuildEventSubscriptions;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableMap;
import org.gradle.internal.impldep.com.google.common.collect.ImmutableSet;
import org.gradle.tooling.events.test.internal.DefaultDebugOptions;
import org.gradle.tooling.internal.protocol.events.InternalTestDescriptor;
import org.gradle.tooling.internal.protocol.test.InternalDebugOptions;
import org.gradle.tooling.internal.protocol.test.InternalJvmTestRequest;
import org.gradle.tooling.internal.provider.action.SubscribableBuildAction;
import org.gradle.tooling.internal.provider.test.ProviderInternalJvmTestRequest;
import org.gradle.tooling.internal.provider.test.ProviderInternalTestExecutionRequest;
import org.gradle.util.internal.CollectionUtils;

public class TestExecutionRequestAction
extends SubscribableBuildAction {
    private final StartParameterInternal startParameter;
    private final Set<InternalTestDescriptor> testDescriptors;
    private final Set<String> classNames;
    private final Set<InternalJvmTestRequest> internalJvmTestRequests;
    private final InternalDebugOptions debugOptions;
    private final Map<String, List<InternalJvmTestRequest>> taskAndTests;

    public TestExecutionRequestAction(BuildEventSubscriptions clientSubscriptions, StartParameterInternal startParameter, Set<InternalTestDescriptor> testDescriptors, Set<String> providerClassNames, Set<InternalJvmTestRequest> internalJvmTestRequests, InternalDebugOptions debugOptions, Map<String, List<InternalJvmTestRequest>> taskAndTests) {
        super(clientSubscriptions);
        this.startParameter = startParameter;
        this.testDescriptors = testDescriptors;
        this.classNames = providerClassNames;
        this.internalJvmTestRequests = internalJvmTestRequests;
        this.debugOptions = debugOptions;
        this.taskAndTests = taskAndTests;
    }

    public static TestExecutionRequestAction create(BuildEventSubscriptions clientSubscriptions, StartParameterInternal startParameter, ProviderInternalTestExecutionRequest testExecutionRequest) {
        ImmutableSet classNames = ImmutableSet.copyOf(testExecutionRequest.getTestClassNames());
        return new TestExecutionRequestAction(clientSubscriptions, startParameter, (Set<InternalTestDescriptor>)ImmutableSet.copyOf(testExecutionRequest.getTestExecutionDescriptors()), (Set<String>)classNames, TestExecutionRequestAction.getInternalJvmTestRequests(testExecutionRequest, (Set<String>)classNames), TestExecutionRequestAction.getDebugOptions(testExecutionRequest), TestExecutionRequestAction.getTaskAndTests(testExecutionRequest));
    }

    private static Set<InternalJvmTestRequest> getInternalJvmTestRequests(ProviderInternalTestExecutionRequest testExecutionRequest, Set<String> classNames) {
        Collection<InternalJvmTestRequest> internalJvmTestRequests = testExecutionRequest.getInternalJvmTestRequests(Collections.emptyList());
        return ImmutableSet.copyOf(TestExecutionRequestAction.toProviderInternalJvmTestRequest(internalJvmTestRequests, classNames));
    }

    private static InternalDebugOptions getDebugOptions(ProviderInternalTestExecutionRequest testExecutionRequest) {
        return testExecutionRequest.getDebugOptions(new DefaultDebugOptions());
    }

    private static Map<String, List<InternalJvmTestRequest>> getTaskAndTests(ProviderInternalTestExecutionRequest testExecutionRequest) {
        Map<String, List<InternalJvmTestRequest>> taskAndTests = testExecutionRequest.getTaskAndTests(Collections.emptyMap());
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Map.Entry<String, List<InternalJvmTestRequest>> entry : taskAndTests.entrySet()) {
            builder.put((Object)entry.getKey(), TestExecutionRequestAction.toProviderInternalJvmTestRequest((Collection<InternalJvmTestRequest>)entry.getValue(), Collections.emptyList()));
        }
        return builder.build();
    }

    private static List<InternalJvmTestRequest> toProviderInternalJvmTestRequest(Collection<InternalJvmTestRequest> internalJvmTestRequests, Collection<String> testClassNames) {
        if (internalJvmTestRequests.isEmpty()) {
            return CollectionUtils.collect(testClassNames, new Transformer<InternalJvmTestRequest, String>(){

                @Override
                public InternalJvmTestRequest transform(String testClass) {
                    return new ProviderInternalJvmTestRequest(testClass, null);
                }
            });
        }
        return CollectionUtils.collect(internalJvmTestRequests, new Transformer<InternalJvmTestRequest, InternalJvmTestRequest>(){

            @Override
            public InternalJvmTestRequest transform(InternalJvmTestRequest internalTestMethod) {
                return new ProviderInternalJvmTestRequest(internalTestMethod.getClassName(), internalTestMethod.getMethodName());
            }
        });
    }

    @Override
    public StartParameterInternal getStartParameter() {
        return this.startParameter;
    }

    @Override
    public boolean isRunTasks() {
        return true;
    }

    @Override
    public boolean isCreateModel() {
        return false;
    }

    public Set<String> getTestClassNames() {
        return this.classNames;
    }

    public Set<InternalJvmTestRequest> getInternalJvmTestRequests() {
        return this.internalJvmTestRequests;
    }

    public Set<InternalTestDescriptor> getTestExecutionDescriptors() {
        return this.testDescriptors;
    }

    public InternalDebugOptions getDebugOptions() {
        return this.debugOptions;
    }

    public Map<String, List<InternalJvmTestRequest>> getTaskAndTests() {
        return this.taskAndTests;
    }
}

