/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.idea.gradle.dsl.parser.files;

import com.android.tools.idea.gradle.dsl.model.BuildModelContext;
import com.android.tools.idea.gradle.dsl.model.notifications.NotificationTypeReference;
import com.android.tools.idea.gradle.dsl.parser.files.GradleBuildFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleDslFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradlePropertiesFile;
import com.android.tools.idea.gradle.dsl.parser.files.GradleSettingsFile;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GradleDslFileCache {
    @NotNull
    private Project myProject;
    @NotNull
    private Map<String, GradleDslFile> myParsedBuildFiles;
    @NotNull
    private Deque<VirtualFile> myParsingStack;

    public GradleDslFileCache(@NotNull Project project) {
        if (project == null) {
            GradleDslFileCache.$$$reportNull$$$0(0);
        }
        this.myParsedBuildFiles = new HashMap<String, GradleDslFile>();
        this.myParsingStack = new ArrayDeque<VirtualFile>();
        this.myProject = project;
    }

    public void clearAllFiles() {
        this.myParsedBuildFiles.clear();
    }

    @NotNull
    public GradleBuildFile getOrCreateBuildFile(@NotNull VirtualFile file, @NotNull String name, @NotNull BuildModelContext context, boolean isApplied) {
        GradleDslFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(1);
        }
        if (name == null) {
            GradleDslFileCache.$$$reportNull$$$0(2);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(3);
        }
        if ((dslFile = this.myParsedBuildFiles.get(file.getUrl())) == null) {
            if (!this.myParsingStack.contains(file)) {
                this.myParsingStack.push(file);
                dslFile = context.parseBuildFile(this.myProject, file, name, isApplied);
                this.myParsingStack.pop();
                this.myParsedBuildFiles.put(file.getUrl(), dslFile);
            } else {
                dslFile = new GradleBuildFile(file, this.myProject, name, context);
                dslFile.notification(NotificationTypeReference.CIRCULAR_APPLICATION);
            }
        } else if (!(dslFile instanceof GradleBuildFile)) {
            throw new IllegalStateException("Found wrong type for build file in cache!");
        }
        GradleBuildFile gradleBuildFile = (GradleBuildFile)dslFile;
        if (gradleBuildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(4);
        }
        return gradleBuildFile;
    }

    public void putBuildFile(@NotNull String name, @NotNull GradleDslFile buildFile) {
        if (name == null) {
            GradleDslFileCache.$$$reportNull$$$0(5);
        }
        if (buildFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(6);
        }
        this.myParsedBuildFiles.put(name, buildFile);
    }

    @Nullable
    public VirtualFile getCurrentParsingRoot() {
        return this.myParsingStack.isEmpty() ? null : this.myParsingStack.getLast();
    }

    @NotNull
    public GradleSettingsFile getOrCreateSettingsFile(@NotNull VirtualFile settingsFile, @NotNull BuildModelContext context) {
        GradleDslFile dslFile;
        if (settingsFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(7);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(8);
        }
        if ((dslFile = this.myParsedBuildFiles.get(settingsFile.getUrl())) == null) {
            dslFile = new GradleSettingsFile(settingsFile, this.myProject, "settings", context);
            dslFile.parse();
            this.myParsedBuildFiles.put(settingsFile.getUrl(), dslFile);
        } else if (!(dslFile instanceof GradleSettingsFile)) {
            throw new IllegalStateException("Found wrong type for settings file in cache!");
        }
        GradleSettingsFile gradleSettingsFile = (GradleSettingsFile)dslFile;
        if (gradleSettingsFile == null) {
            GradleDslFileCache.$$$reportNull$$$0(9);
        }
        return gradleSettingsFile;
    }

    @Nullable
    public GradlePropertiesFile getOrCreatePropertiesFile(@NotNull VirtualFile file, @NotNull String moduleName, @NotNull BuildModelContext context) {
        GradleDslFile dslFile;
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(10);
        }
        if (moduleName == null) {
            GradleDslFileCache.$$$reportNull$$$0(11);
        }
        if (context == null) {
            GradleDslFileCache.$$$reportNull$$$0(12);
        }
        if ((dslFile = this.myParsedBuildFiles.get(file.getUrl())) == null) {
            try {
                Properties properties = GradleDslFileCache.getProperties(file);
                dslFile = new GradlePropertiesFile(properties, file, this.myProject, moduleName, context);
                this.myParsedBuildFiles.put(file.getUrl(), dslFile);
            }
            catch (IOException e) {
                Logger.getInstance(GradleDslFileCache.class).warn("Failed to process properties file " + file.getPath(), (Throwable)e);
                return null;
            }
        } else if (!(dslFile instanceof GradlePropertiesFile)) {
            throw new IllegalStateException("Found wrong type for properties file in cache!");
        }
        return (GradlePropertiesFile)dslFile;
    }

    private static Properties getProperties(@NotNull VirtualFile file) throws IOException {
        if (file == null) {
            GradleDslFileCache.$$$reportNull$$$0(13);
        }
        Properties properties = new Properties();
        try (InputStreamReader reader = new InputStreamReader(file.getInputStream(), StandardCharsets.UTF_8);){
            properties.load(reader);
        }
        return properties;
    }

    @NotNull
    public List<GradleDslFile> getAllFiles() {
        return new ArrayList<GradleDslFile>(this.myParsedBuildFiles.values());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string;
        switch (n) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 4: 
            case 9: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 4: 
            case 9: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 3: 
            case 8: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "context";
                break;
            }
            case 4: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "buildFile";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settingsFile";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "moduleName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/android/tools/idea/gradle/dsl/parser/files/GradleDslFileCache";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateBuildFile";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "getOrCreateSettingsFile";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateBuildFile";
                break;
            }
            case 4: 
            case 9: {
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "putBuildFile";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreateSettingsFile";
                break;
            }
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getOrCreatePropertiesFile";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getProperties";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 4: 
            case 9: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

