/*
 * Decompiled with CFR 0.152.
 */
package kotlin.reflect.jvm.internal.impl.serialization.deserialization;

import java.util.Set;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.jvm.internal.impl.builtins.StandardNames;
import kotlin.reflect.jvm.internal.impl.descriptors.ClassDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentDescriptor;
import kotlin.reflect.jvm.internal.impl.descriptors.PackageFragmentProviderKt;
import kotlin.reflect.jvm.internal.impl.descriptors.deserialization.ClassDescriptorFactory;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.TypeTable;
import kotlin.reflect.jvm.internal.impl.metadata.deserialization.VersionRequirementTable;
import kotlin.reflect.jvm.internal.impl.name.ClassId;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.ClassData;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializationComponents;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.DeserializedPackageFragment;
import kotlin.reflect.jvm.internal.impl.serialization.deserialization.descriptors.DeserializedClassDescriptor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class ClassDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final DeserializationComponents components;
    @NotNull
    private final Function1<ClassKey, ClassDescriptor> classes;
    @NotNull
    private static final Set<ClassId> BLACK_LIST = SetsKt.setOf((Object)ClassId.topLevel(StandardNames.FqNames.cloneable.toSafe()));

    public ClassDeserializer(@NotNull DeserializationComponents components2) {
        Intrinsics.checkNotNullParameter((Object)components2, (String)"components");
        this.components = components2;
        this.classes = this.components.getStorageManager().createMemoizedFunctionWithNullableValues((Function1)new Function1<ClassKey, ClassDescriptor>(this){
            final /* synthetic */ ClassDeserializer this$0;
            {
                this.this$0 = $receiver;
                super(1);
            }

            @Nullable
            public final ClassDescriptor invoke(@NotNull ClassKey key) {
                Intrinsics.checkNotNullParameter((Object)key, (String)"key");
                return ClassDeserializer.access$createClass(this.this$0, key);
            }
        });
    }

    @Nullable
    public final ClassDescriptor deserializeClass(@NotNull ClassId classId, @Nullable ClassData classData) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return (ClassDescriptor)this.classes.invoke((Object)new ClassKey(classId, classData));
    }

    public static /* synthetic */ ClassDescriptor deserializeClass$default(ClassDeserializer classDeserializer, ClassId classId, ClassData classData, int n, Object object) {
        if ((n & 2) != 0) {
            classData = null;
        }
        return classDeserializer.deserializeClass(classId, classData);
    }

    /*
     * Unable to fully structure code
     */
    private final ClassDescriptor createClass(ClassKey key) {
        block11: {
            block9: {
                block10: {
                    classId = key.getClassId();
                    for (ClassDescriptorFactory factory : this.components.getFictitiousClassDescriptorFactories()) {
                        var5_5 = factory.createClass(classId);
                        if (var5_5 == null) continue;
                        it = var5_5;
                        $i$a$-let-ClassDeserializer$createClass$1 = false;
                        return it;
                    }
                    if (ClassDeserializer.BLACK_LIST.contains(classId)) {
                        return null;
                    }
                    v0 = key.getClassData();
                    if (v0 == null && (v0 = this.components.getClassDataFinder().findClassData(classId)) == null) {
                        return null;
                    }
                    var3_3 = v0;
                    nameResolver = var3_3.component1();
                    classProto = var3_3.component2();
                    metadataVersion = var3_3.component3();
                    sourceElement = var3_3.component4();
                    outerClassId = classId.getOuterClassId();
                    if (outerClassId == null) break block10;
                    var12_11 = ClassDeserializer.deserializeClass$default(this, outerClassId, null, 2, null);
                    v1 = var12_11 instanceof DeserializedClassDescriptor != false ? (DeserializedClassDescriptor)var12_11 : null;
                    if (v1 == null) {
                        return null;
                    }
                    outerClass = v1;
                    v2 = classId.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)v2, (String)"classId.shortClassName");
                    if (!outerClass.hasNestedClass$deserialization(v2)) {
                        return null;
                    }
                    v3 = outerClass.getC();
                    break block11;
                }
                v4 = this.components.getPackageFragmentProvider();
                v5 = classId.getPackageFqName();
                Intrinsics.checkNotNullExpressionValue((Object)v5, (String)"classId.packageFqName");
                fragments = PackageFragmentProviderKt.packageFragments(v4, v5);
                $this$firstOrNull$iv = fragments;
                $i$f$firstOrNull = false;
                for (T element$iv : $this$firstOrNull$iv) {
                    it = (PackageFragmentDescriptor)element$iv;
                    $i$a$-firstOrNull-ClassDeserializer$createClass$outerContext$fragment$1 = false;
                    if (!(it instanceof DeserializedPackageFragment)) ** GOTO lbl-1000
                    v6 = (DeserializedPackageFragment)it;
                    v7 = classId.getShortClassName();
                    Intrinsics.checkNotNullExpressionValue((Object)v7, (String)"classId.shortClassName");
                    if (v6.hasTopLevelClass(v7)) lbl-1000:
                    // 2 sources

                    {
                        v8 = true;
                    } else {
                        v8 = false;
                    }
                    if (!v8) continue;
                    v9 = element$iv;
                    break block9;
                }
                v9 = null;
            }
            v10 = v9;
            if (v10 == null) {
                return null;
            }
            fragment = v10;
            v11 = classProto.getTypeTable();
            Intrinsics.checkNotNullExpressionValue((Object)v11, (String)"classProto.typeTable");
            v12 = new TypeTable(v11);
            v13 = classProto.getVersionRequirementTable();
            Intrinsics.checkNotNullExpressionValue((Object)v13, (String)"classProto.versionRequirementTable");
            v3 = this.components.createContext(fragment, nameResolver, v12, VersionRequirementTable.Companion.create(v13), metadataVersion, null);
        }
        outerContext = v3;
        return new DeserializedClassDescriptor(outerContext, classProto, nameResolver, metadataVersion, sourceElement);
    }

    public static final /* synthetic */ ClassDescriptor access$createClass(ClassDeserializer $this, ClassKey key) {
        return $this.createClass(key);
    }

    private static final class ClassKey {
        @NotNull
        private final ClassId classId;
        @Nullable
        private final ClassData classData;

        public ClassKey(@NotNull ClassId classId, @Nullable ClassData classData) {
            Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
            this.classId = classId;
            this.classData = classData;
        }

        @NotNull
        public final ClassId getClassId() {
            return this.classId;
        }

        @Nullable
        public final ClassData getClassData() {
            return this.classData;
        }

        public boolean equals(@Nullable Object other) {
            return other instanceof ClassKey && Intrinsics.areEqual((Object)this.classId, (Object)((ClassKey)other).classId);
        }

        public int hashCode() {
            return this.classId.hashCode();
        }
    }

    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Set<ClassId> getBLACK_LIST() {
            return BLACK_LIST;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

