/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.kotlin;

import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.builtins.FunctionTypesKt;
import org.jetbrains.kotlin.builtins.KotlinBuiltIns;
import org.jetbrains.kotlin.builtins.SuspendFunctionTypesKt;
import org.jetbrains.kotlin.descriptors.CallableDescriptor;
import org.jetbrains.kotlin.descriptors.ClassDescriptor;
import org.jetbrains.kotlin.descriptors.ClassKind;
import org.jetbrains.kotlin.descriptors.ClassifierDescriptor;
import org.jetbrains.kotlin.descriptors.ConstructorDescriptor;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.PropertyGetterDescriptor;
import org.jetbrains.kotlin.descriptors.TypeAliasDescriptor;
import org.jetbrains.kotlin.descriptors.TypeParameterDescriptor;
import org.jetbrains.kotlin.load.kotlin.JvmDescriptorTypeWriter;
import org.jetbrains.kotlin.load.kotlin.JvmTypeFactory;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfiguration;
import org.jetbrains.kotlin.load.kotlin.TypeMappingConfigurationImpl;
import org.jetbrains.kotlin.load.kotlin.TypeMappingMode;
import org.jetbrains.kotlin.load.kotlin.TypeSignatureMappingKt;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.SpecialNames;
import org.jetbrains.kotlin.resolve.InlineClassesUtilsKt;
import org.jetbrains.kotlin.types.ExpandedTypeUtilsKt;
import org.jetbrains.kotlin.types.IntersectionTypeConstructor;
import org.jetbrains.kotlin.types.KotlinType;
import org.jetbrains.kotlin.types.TypeConstructor;
import org.jetbrains.kotlin.types.TypeProjection;
import org.jetbrains.kotlin.types.TypeUtils;
import org.jetbrains.kotlin.types.Variance;
import org.jetbrains.kotlin.types.checker.SimpleClassicTypeSystemContext;
import org.jetbrains.kotlin.types.error.ErrorUtils;
import org.jetbrains.kotlin.types.typeUtil.TypeUtilsKt;
import org.jetbrains.kotlin.utils.FunctionsKt;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000L\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\u001a\u001c\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\f\b\u0002\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u001a\u000e\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t\u001as\u0010\n\u001a\u0002H\u000b\"\b\b\u0000\u0010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u0002H\u000b0\u00052\u000e\u0010\u0013\u001a\n\u0012\u0004\u0012\u0002H\u000b\u0018\u00010\u00142 \b\u0002\u0010\u0015\u001a\u001a\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u0002H\u000b\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u00170\u0016\u00a2\u0006\u0002\u0010\u0018\u00a8\u0006\u0019"}, d2={"computeInternalName", "", "klass", "Lorg/jetbrains/kotlin/descriptors/ClassDescriptor;", "typeMappingConfiguration", "Lorg/jetbrains/kotlin/load/kotlin/TypeMappingConfiguration;", "hasVoidReturnType", "", "descriptor", "Lorg/jetbrains/kotlin/descriptors/CallableDescriptor;", "mapType", "T", "", "kotlinType", "Lorg/jetbrains/kotlin/types/KotlinType;", "factory", "Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;", "mode", "Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;", "descriptorTypeWriter", "Lorg/jetbrains/kotlin/load/kotlin/JvmDescriptorTypeWriter;", "writeGenericType", "Lkotlin/Function3;", "", "(Lorg/jetbrains/kotlin/types/KotlinType;Lorg/jetbrains/kotlin/load/kotlin/JvmTypeFactory;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingMode;Lorg/jetbrains/kotlin/load/kotlin/TypeMappingConfiguration;Lorg/jetbrains/kotlin/load/kotlin/JvmDescriptorTypeWriter;Lkotlin/jvm/functions/Function3;)Ljava/lang/Object;", "descriptors.jvm"})
public final class DescriptorBasedTypeSignatureMappingKt {
    @NotNull
    public static final <T> T mapType(@NotNull KotlinType kotlinType, @NotNull JvmTypeFactory<T> factory, @NotNull TypeMappingMode mode, @NotNull TypeMappingConfiguration<? extends T> typeMappingConfiguration, @Nullable JvmDescriptorTypeWriter<T> descriptorTypeWriter, @NotNull Function3<? super KotlinType, ? super T, ? super TypeMappingMode, Unit> writeGenericType) {
        T jvmType;
        Intrinsics.checkNotNullParameter((Object)kotlinType, (String)"kotlinType");
        Intrinsics.checkNotNullParameter(factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)mode, (String)"mode");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
        Intrinsics.checkNotNullParameter(writeGenericType, (String)"writeGenericType");
        KotlinType kotlinType2 = typeMappingConfiguration.preprocessType(kotlinType);
        if (kotlinType2 != null) {
            KotlinType newType = kotlinType2;
            boolean bl = false;
            return DescriptorBasedTypeSignatureMappingKt.mapType(newType, factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        if (FunctionTypesKt.isSuspendFunctionType(kotlinType)) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(SuspendFunctionTypesKt.transformSuspendFunctionToRuntimeFunctionType(kotlinType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        SimpleClassicTypeSystemContext $this$mapType_u24lambda_u2d1 = SimpleClassicTypeSystemContext.INSTANCE;
        boolean bl = false;
        kotlinType2 = TypeSignatureMappingKt.mapBuiltInType($this$mapType_u24lambda_u2d1, kotlinType, factory, mode);
        if (kotlinType2 != null) {
            KotlinType builtInType = kotlinType2;
            boolean bl2 = false;
            KotlinType jvmType2 = TypeSignatureMappingKt.boxTypeIfNeeded(factory, builtInType, mode.getNeedPrimitiveBoxing());
            writeGenericType.invoke((Object)kotlinType, (Object)jvmType2, (Object)mode);
            return (T)jvmType2;
        }
        TypeConstructor constructor = kotlinType.getConstructor();
        if (constructor instanceof IntersectionTypeConstructor) {
            KotlinType kotlinType3 = ((IntersectionTypeConstructor)constructor).getAlternativeType();
            if (kotlinType3 == null) {
                kotlinType3 = typeMappingConfiguration.commonSupertype(((IntersectionTypeConstructor)constructor).getSupertypes());
            }
            KotlinType intersectionType = kotlinType3;
            return DescriptorBasedTypeSignatureMappingKt.mapType(TypeUtilsKt.replaceArgumentsWithStarProjections(intersectionType), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        ClassifierDescriptor classifierDescriptor = constructor.getDeclarationDescriptor();
        if (classifierDescriptor == null) {
            throw new UnsupportedOperationException("no descriptor for type constructor of " + kotlinType);
        }
        ClassifierDescriptor descriptor2 = classifierDescriptor;
        if (ErrorUtils.isError(descriptor2)) {
            jvmType = factory.createObjectType("error/NonExistentClass");
            typeMappingConfiguration.processErrorType(kotlinType, (ClassDescriptor)descriptor2);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                jvmDescriptorTypeWriter.writeClass(jvmType);
            }
            return jvmType;
        }
        if (descriptor2 instanceof ClassDescriptor && KotlinBuiltIns.isArray(kotlinType)) {
            if (kotlinType.getArguments().size() != 1) {
                throw new UnsupportedOperationException("arrays must have one type argument");
            }
            TypeProjection memberProjection = kotlinType.getArguments().get(0);
            KotlinType kotlinType4 = memberProjection.getType();
            Intrinsics.checkNotNullExpressionValue((Object)kotlinType4, (String)"memberProjection.type");
            KotlinType memberType = kotlinType4;
            Object arrayElementType = null;
            if (memberProjection.getProjectionKind() == Variance.IN_VARIANCE) {
                arrayElementType = factory.createObjectType("java/lang/Object");
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter2;
                    JvmDescriptorTypeWriter<Object> $this$mapType_u24lambda_u2d3 = jvmDescriptorTypeWriter2 = jvmDescriptorTypeWriter;
                    boolean bl3 = false;
                    $this$mapType_u24lambda_u2d3.writeArrayType();
                    $this$mapType_u24lambda_u2d3.writeClass(arrayElementType);
                    $this$mapType_u24lambda_u2d3.writeArrayEnd();
                }
            } else {
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter != null) {
                    jvmDescriptorTypeWriter.writeArrayType();
                }
                Variance variance = memberProjection.getProjectionKind();
                Intrinsics.checkNotNullExpressionValue((Object)((Object)variance), (String)"memberProjection.projectionKind");
                arrayElementType = DescriptorBasedTypeSignatureMappingKt.mapType(memberType, factory, mode.toGenericArgumentMode(variance, true), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
                JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter3 = descriptorTypeWriter;
                if (jvmDescriptorTypeWriter3 != null) {
                    jvmDescriptorTypeWriter3.writeArrayEnd();
                }
            }
            return factory.createFromString('[' + factory.toString(arrayElementType));
        }
        if (descriptor2 instanceof ClassDescriptor) {
            T t;
            KotlinType expandedType;
            if (InlineClassesUtilsKt.isInlineClass(descriptor2) && !mode.getNeedInlineClassWrapping() && (expandedType = (KotlinType)ExpandedTypeUtilsKt.computeExpandedTypeForInlineClass(SimpleClassicTypeSystemContext.INSTANCE, kotlinType)) != null) {
                return DescriptorBasedTypeSignatureMappingKt.mapType(expandedType, factory, mode.wrapInlineClassesMode(), typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
            }
            if (mode.isForAnnotationParameter() && KotlinBuiltIns.isKClass((ClassDescriptor)descriptor2)) {
                t = factory.getJavaLangClassType();
            } else {
                ClassDescriptor classDescriptor = ((ClassDescriptor)descriptor2).getOriginal();
                Intrinsics.checkNotNullExpressionValue((Object)classDescriptor, (String)"descriptor.original");
                t = typeMappingConfiguration.getPredefinedTypeForClass(classDescriptor);
                if (t == null) {
                    ClassDescriptor classDescriptor2;
                    boolean bl4 = false;
                    if (((ClassDescriptor)descriptor2).getKind() == ClassKind.ENUM_ENTRY) {
                        DeclarationDescriptor declarationDescriptor = ((ClassDescriptor)descriptor2).getContainingDeclaration();
                        Intrinsics.checkNotNull((Object)declarationDescriptor, (String)"null cannot be cast to non-null type org.jetbrains.kotlin.descriptors.ClassDescriptor");
                        classDescriptor2 = (ClassDescriptor)declarationDescriptor;
                    } else {
                        classDescriptor2 = (ClassDescriptor)descriptor2;
                    }
                    ClassDescriptor enumClassIfEnumEntry = classDescriptor2;
                    ClassDescriptor classDescriptor3 = enumClassIfEnumEntry.getOriginal();
                    Intrinsics.checkNotNullExpressionValue((Object)classDescriptor3, (String)"enumClassIfEnumEntry.original");
                    t = factory.createObjectType(DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor3, typeMappingConfiguration));
                }
            }
            jvmType = t;
            writeGenericType.invoke((Object)kotlinType, jvmType, (Object)mode);
            return jvmType;
        }
        if (descriptor2 instanceof TypeParameterDescriptor) {
            KotlinType upperBound = TypeUtilsKt.getRepresentativeUpperBound((TypeParameterDescriptor)descriptor2);
            KotlinType kotlinType5 = kotlinType.isMarkedNullable() ? TypeUtilsKt.makeNullable(upperBound) : upperBound;
            Function3<Object, Object, Object, Unit> function3 = FunctionsKt.getDO_NOTHING_3();
            Object type2 = DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType5, factory, mode, typeMappingConfiguration, null, function3);
            JvmDescriptorTypeWriter<Object> jvmDescriptorTypeWriter = descriptorTypeWriter;
            if (jvmDescriptorTypeWriter != null) {
                Name name = descriptor2.getName();
                Intrinsics.checkNotNullExpressionValue((Object)name, (String)"descriptor.getName()");
                jvmDescriptorTypeWriter.writeTypeVariable(name, type2);
            }
            return (T)type2;
        }
        if (descriptor2 instanceof TypeAliasDescriptor && mode.getMapTypeAliases()) {
            return DescriptorBasedTypeSignatureMappingKt.mapType(((TypeAliasDescriptor)descriptor2).getExpandedType(), factory, mode, typeMappingConfiguration, descriptorTypeWriter, writeGenericType);
        }
        throw new UnsupportedOperationException("Unknown type " + kotlinType);
    }

    public static /* synthetic */ Object mapType$default(KotlinType kotlinType, JvmTypeFactory jvmTypeFactory, TypeMappingMode typeMappingMode, TypeMappingConfiguration typeMappingConfiguration, JvmDescriptorTypeWriter jvmDescriptorTypeWriter, Function3 function3, int n, Object object) {
        if ((n & 0x20) != 0) {
            function3 = FunctionsKt.getDO_NOTHING_3();
        }
        return DescriptorBasedTypeSignatureMappingKt.mapType(kotlinType, jvmTypeFactory, typeMappingMode, typeMappingConfiguration, jvmDescriptorTypeWriter, function3);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean hasVoidReturnType(@NotNull CallableDescriptor descriptor2) {
        Intrinsics.checkNotNullParameter((Object)descriptor2, (String)"descriptor");
        if (descriptor2 instanceof ConstructorDescriptor) {
            return true;
        }
        KotlinType kotlinType = descriptor2.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType);
        if (!KotlinBuiltIns.isUnit(kotlinType)) return false;
        KotlinType kotlinType2 = descriptor2.getReturnType();
        Intrinsics.checkNotNull((Object)kotlinType2);
        if (TypeUtils.isNullableType(kotlinType2)) return false;
        if (descriptor2 instanceof PropertyGetterDescriptor) return false;
        return true;
    }

    @NotNull
    public static final String computeInternalName(@NotNull ClassDescriptor klass, @NotNull TypeMappingConfiguration<?> typeMappingConfiguration) {
        Intrinsics.checkNotNullParameter((Object)klass, (String)"klass");
        Intrinsics.checkNotNullParameter(typeMappingConfiguration, (String)"typeMappingConfiguration");
        String string2 = typeMappingConfiguration.getPredefinedFullInternalNameForClass(klass);
        if (string2 != null) {
            String it = string2;
            boolean bl = false;
            return it;
        }
        DeclarationDescriptor declarationDescriptor = klass.getContainingDeclaration();
        Intrinsics.checkNotNullExpressionValue((Object)declarationDescriptor, (String)"klass.containingDeclaration");
        DeclarationDescriptor container = declarationDescriptor;
        String string3 = SpecialNames.safeIdentifier(klass.getName()).getIdentifier();
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"safeIdentifier(klass.name).identifier");
        String name = string3;
        if (container instanceof PackageFragmentDescriptor) {
            String string4;
            FqName fqName2 = ((PackageFragmentDescriptor)container).getFqName();
            if (fqName2.isRoot()) {
                string4 = name;
            } else {
                StringBuilder stringBuilder = new StringBuilder();
                String string5 = fqName2.asString();
                Intrinsics.checkNotNullExpressionValue((Object)string5, (String)"fqName.asString()");
                string4 = stringBuilder.append(StringsKt.replace$default((String)string5, (char)'.', (char)'/', (boolean)false, (int)4, null)).append('/').append(name).toString();
            }
            return string4;
        }
        ClassDescriptor classDescriptor = container instanceof ClassDescriptor ? (ClassDescriptor)container : null;
        if (classDescriptor == null) {
            throw new IllegalArgumentException("Unexpected container: " + container + " for " + klass);
        }
        ClassDescriptor containerClass = classDescriptor;
        String string6 = typeMappingConfiguration.getPredefinedInternalNameForClass(containerClass);
        if (string6 == null) {
            string6 = DescriptorBasedTypeSignatureMappingKt.computeInternalName(containerClass, typeMappingConfiguration);
        }
        String containerInternalName = string6;
        return containerInternalName + '$' + name;
    }

    public static /* synthetic */ String computeInternalName$default(ClassDescriptor classDescriptor, TypeMappingConfiguration typeMappingConfiguration, int n, Object object) {
        if ((n & 2) != 0) {
            typeMappingConfiguration = TypeMappingConfigurationImpl.INSTANCE;
        }
        return DescriptorBasedTypeSignatureMappingKt.computeInternalName(classDescriptor, typeMappingConfiguration);
    }
}

