/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.language;

import java.util.ArrayList;
import java.util.List;

class UnicodeBasedLangIdentifier {
    private static final int DEFAULT_MAX_CHECK_LENGTH = 50;
    private static final float THRESHOLD = 0.5f;
    private final int maxCheckLength;

    UnicodeBasedLangIdentifier() {
        this(50);
    }

    UnicodeBasedLangIdentifier(int maxCheckLength) {
        this.maxCheckLength = maxCheckLength;
    }

    List<String> getDominantLangCodes(String str) {
        int arabicChars = 0;
        int cyrillicChars = 0;
        int cjkChars = 0;
        int khmerChars = 0;
        int tamilChars = 0;
        int greekChars = 0;
        int devanagariChars = 0;
        int thaiChars = 0;
        int hebrewChars = 0;
        int hangulChars = 0;
        int significantChars = 0;
        for (int i2 = 0; i2 < Math.min(str.length(), this.maxCheckLength); ++i2) {
            char val = str.charAt(i2);
            if (!Character.isWhitespace((int)val) && !Character.isDigit((int)val) && val != '.') {
                ++significantChars;
            }
            if (val >= '\u0600' && val <= '\u06ff') {
                ++arabicChars;
            }
            if (val >= '\u0400' && val <= '\u04ff') {
                ++cyrillicChars;
            }
            if (val >= '\u4e00' && val <= '\u9fff' || val >= '\u3040' && val <= '\u309f' || val >= '\u30a0' && val <= '\u30ff') {
                ++cjkChars;
            }
            if (val >= '\u1780' && val <= '\u17ff') {
                ++khmerChars;
            }
            if (val >= '\u0b82' && val <= '\u0bfa') {
                ++tamilChars;
            }
            if (val >= '\u0370' && val <= '\u03ff' || val >= '\u1f00' && val <= '\u1fff') {
                ++greekChars;
            }
            if (val >= '\u0900' && val <= '\u097f') {
                ++devanagariChars;
            }
            if (val >= '\u0e00' && val <= '\u0e7f') {
                ++thaiChars;
            }
            if (val >= '\u0590' && val <= '\u05ff' || val >= '\ufb1d' && val <= '\ufb40') {
                ++hebrewChars;
            }
            if (!(val >= '\uac00' && val <= '\ud7af' || val >= '\u1100' && val <= '\u11ff' || val >= '\u3130' && val <= '\u318f' || val >= '\ua960' && val <= '\ua97f') && (val < '\ud7b0' || val > '\ud7ff')) continue;
            ++hangulChars;
        }
        ArrayList<String> langCodes = new ArrayList<String>();
        if ((float)arabicChars / (float)significantChars >= 0.5f) {
            langCodes.add("ar");
            langCodes.add("fa");
        }
        if ((float)cyrillicChars / (float)significantChars >= 0.5f) {
            langCodes.add("ru");
            langCodes.add("uk");
            langCodes.add("be");
        }
        if ((float)cjkChars / (float)significantChars >= 0.5f) {
            langCodes.add("zh");
            langCodes.add("ja");
        }
        if ((float)khmerChars / (float)significantChars >= 0.5f) {
            langCodes.add("km");
        }
        if ((float)tamilChars / (float)significantChars >= 0.5f) {
            langCodes.add("ta");
        }
        if ((float)greekChars / (float)significantChars >= 0.5f) {
            langCodes.add("el");
        }
        if ((float)devanagariChars / (float)significantChars >= 0.5f) {
            langCodes.add("hi");
            langCodes.add("mr");
        }
        if ((float)thaiChars / (float)significantChars >= 0.5f) {
            langCodes.add("th");
        }
        if ((float)hebrewChars / (float)significantChars >= 0.5f) {
            langCodes.add("he");
        }
        if ((float)hangulChars / (float)significantChars >= 0.5f) {
            langCodes.add("ko");
        }
        return langCodes;
    }
}

