/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.rules;

import com.hankcs.algorithm.AhoCorasickDoubleArrayTrie;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import org.languagetool.AnalyzedSentence;
import org.languagetool.JLanguageTool;
import org.languagetool.Tag;
import org.languagetool.rules.Categories;
import org.languagetool.rules.Rule;
import org.languagetool.rules.RuleMatch;

public abstract class AbstractDashRule
extends Rule {
    public AbstractDashRule(ResourceBundle messages) {
        super(messages);
        this.setCategory(Categories.TYPOGRAPHY.getCategory(messages));
        this.setTags(Collections.singletonList(Tag.picky));
    }

    @Override
    public String getId() {
        return "DASH_RULE";
    }

    @Override
    public abstract String getDescription();

    public abstract String getMessage();

    protected abstract AhoCorasickDoubleArrayTrie<String> getCompoundsData();

    @Override
    public int estimateContextForSureMatch() {
        return 2;
    }

    @Override
    public RuleMatch[] match(AnalyzedSentence sentence) throws IOException {
        ArrayList<RuleMatch> matches = new ArrayList<RuleMatch>();
        String text2 = sentence.getText();
        List<AhoCorasickDoubleArrayTrie.Hit<String>> hits = this.getCompoundsData().parseText(text2);
        HashSet<Integer> startPositions = new HashSet<Integer>();
        Collections.reverse(hits);
        for (AhoCorasickDoubleArrayTrie.Hit<String> hit : hits) {
            if (startPositions.contains(hit.begin) || hit.begin > 0 && !this.isBoundary(text2.substring(hit.begin - 1, hit.begin)) || hit.end < text2.length() && !this.isBoundary(text2.substring(hit.end, hit.end + 1))) continue;
            RuleMatch match = new RuleMatch(this, sentence, hit.begin, hit.end, hit.begin, hit.end, this.getMessage(), null, false, "");
            String covered = text2.substring(hit.begin, hit.end);
            match.setSuggestedReplacement(covered.replaceAll(" ?[\u2013\u2014] ?", "-"));
            matches.add(match);
            startPositions.add(hit.begin);
        }
        return matches.toArray(new RuleMatch[0]);
    }

    protected boolean isBoundary(String s) {
        return !s.matches("[a-zA-Z]");
    }

    /*
     * WARNING - void declaration
     */
    protected static AhoCorasickDoubleArrayTrie<String> loadCompoundFile(String path) {
        ArrayList<void> words = new ArrayList<void>();
        List<String> lines = JLanguageTool.getDataBroker().getFromResourceDirAsLines(path);
        for (String string : lines) {
            void var4_4;
            if (string.isEmpty() || string.charAt(0) == '#' || string.endsWith("+") || string.endsWith("?")) continue;
            if (string.endsWith("*") || string.endsWith("$")) {
                String string2 = AbstractDashRule.removeLastCharacter(string);
            }
            words.add(var4_4);
        }
        HashMap<String, String> map2 = new HashMap<String, String>();
        for (String string : words) {
            String variant1 = string.replace("-", "\u2013");
            map2.put(variant1, variant1);
            String variant2 = string.replace("-", "\u2014");
            map2.put(variant2, variant2);
            String variant3 = string.replace("-", " \u2013 ");
            map2.put(variant3, variant3);
            String variant4 = string.replace("-", " \u2014 ");
            map2.put(variant4, variant4);
        }
        AhoCorasickDoubleArrayTrie<String> ahoCorasickDoubleArrayTrie = new AhoCorasickDoubleArrayTrie<String>();
        ahoCorasickDoubleArrayTrie.build(map2);
        return ahoCorasickDoubleArrayTrie;
    }

    private static String removeLastCharacter(String str) {
        return str.substring(0, str.length() - 1);
    }
}

