/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.kotlin.commonNative.debugger;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.breakpoints.XLineBreakpointType;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrSymbolicBreakpointType;
import com.jetbrains.kotlin.commonNative.KonanBundle;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.breakpoints.KotlinFunctionBreakpointTypeKt;
import org.jetbrains.kotlin.idea.project.TargetPlatformDetector;
import org.jetbrains.kotlin.platform.TargetPlatform;
import org.jetbrains.kotlin.platform.konan.NativePlatformKt;
import org.jetbrains.kotlin.psi.KtFile;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0018\u0010\f\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016J\r\u0010\r\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0010\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0011\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0012\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\r\u0010\u0013\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\b\u0010\u0014\u001a\u00020\tH\u0016J\r\u0010\u0015\u001a\u00070\u000e\u00a2\u0006\u0002\b\u000fH\u0016J\u0018\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH\u0002\u00a8\u0006\u0017"}, d2={"Lcom/jetbrains/kotlin/commonNative/debugger/KonanFunctionBreakpointType;", "Lcom/intellij/xdebugger/breakpoints/XLineBreakpointType;", "Lcom/jetbrains/cidr/execution/debugger/breakpoints/CidrSymbolicBreakpointType$Properties;", "()V", "canPutAt", "", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "line", "", "project", "Lcom/intellij/openapi/project/Project;", "createBreakpointProperties", "getDisabledIcon", "Ljavax/swing/Icon;", "Lorg/jetbrains/annotations/NotNull;", "getEnabledIcon", "getInactiveDependentIcon", "getMutedDisabledIcon", "getMutedEnabledIcon", "getPriority", "getSuspendNoneIcon", "isKtFileWithNativePlatform", "kotlin-ultimate.common-native"})
public final class KonanFunctionBreakpointType
extends XLineBreakpointType<CidrSymbolicBreakpointType.Properties> {
    public int getPriority() {
        return 120;
    }

    public boolean canPutAt(@NotNull VirtualFile file2, int line, @NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return this.isKtFileWithNativePlatform(file2, project2) && KotlinFunctionBreakpointTypeKt.isFunctionBreakpointApplicable(file2, line, project2);
    }

    @NotNull
    public CidrSymbolicBreakpointType.Properties createBreakpointProperties(@NotNull VirtualFile file2, int line) {
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        return new CidrSymbolicBreakpointType.Properties();
    }

    private final boolean isKtFileWithNativePlatform(VirtualFile file2, Project project2) {
        PsiFile psiFile2 = PsiManager.getInstance((Project)project2).findFile(file2);
        if (!(psiFile2 instanceof KtFile)) {
            psiFile2 = null;
        }
        KtFile ktFile = (KtFile)psiFile2;
        if (ktFile == null) {
            return false;
        }
        KtFile psiFile3 = ktFile;
        return NativePlatformKt.isNative((TargetPlatform)TargetPlatformDetector.getPlatform(psiFile3));
    }

    @NotNull
    public Icon getEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_method_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_disabled_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_disabled_method_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getSuspendNoneIcon() {
        Icon icon2 = AllIcons.Debugger.Db_no_suspend_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_no_suspend_method_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getMutedEnabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_muted_method_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getMutedDisabledIcon() {
        Icon icon2 = AllIcons.Debugger.Db_muted_disabled_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_mut\u2026isabled_method_breakpoint");
        return icon2;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        Icon icon2 = AllIcons.Debugger.Db_dep_method_breakpoint;
        Intrinsics.checkNotNullExpressionValue((Object)icon2, (String)"AllIcons.Debugger.Db_dep_method_breakpoint");
        return icon2;
    }

    public KonanFunctionBreakpointType() {
        super("kotlin-native-function", KonanBundle.message("function.breakpoint.tab.title", new Object[0]));
    }
}

