/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.mpp;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.CommandLineState;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.configurations.PtyCommandLine;
import com.intellij.execution.filters.ConsoleFilterProvider;
import com.intellij.execution.filters.DefaultConsoleFiltersProvider;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.process.BaseProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.jetbrains.cidr.execution.CidrLauncher;
import com.jetbrains.cidr.execution.RunParameters;
import com.jetbrains.cidr.system.LocalHost;
import com.jetbrains.kotlin.commonNative.KonanInstaller;
import com.jetbrains.kotlin.commonNative.KonanInstallerKt;
import com.jetbrains.kotlin.commonNative.debugger.KonanLocalDebugProcess;
import com.jetbrains.mpp.KonanCommandLineState;
import com.jetbrains.mpp.KonanRunConfiguration;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0018\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0014J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\r\u001a\u00020\u000eH\u0014J\b\u0010\u0013\u001a\u00020\u0003H\u0016J\b\u0010\u0007\u001a\u00020\bH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0014"}, d2={"Lcom/jetbrains/mpp/KonanLauncher;", "Lcom/jetbrains/cidr/execution/CidrLauncher;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/openapi/project/Project;)V", "createCommandLine", "Lcom/intellij/execution/configurations/GeneralCommandLine;", "usePty", "", "configuration", "Lcom/jetbrains/mpp/KonanRunConfiguration;", "createDebugProcess", "Lcom/intellij/xdebugger/XDebugProcess;", "state", "Lcom/intellij/execution/configurations/CommandLineState;", "session", "Lcom/intellij/xdebugger/XDebugSession;", "createProcess", "Lcom/intellij/execution/process/ProcessHandler;", "getProject", "kotlin-ultimate.ultimate-native"})
public final class KonanLauncher
extends CidrLauncher {
    private final Project project;

    @NotNull
    protected ProcessHandler createProcess(@NotNull CommandLineState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        CommandLineState commandLineState = state;
        if (!(commandLineState instanceof KonanCommandLineState)) {
            commandLineState = null;
        }
        KonanCommandLineState konanCommandLineState = (KonanCommandLineState)commandLineState;
        if (konanCommandLineState == null) {
            throw (Throwable)new IllegalStateException(Reflection.getOrCreateKotlinClass(KonanLauncher.class) + " is supposed to launch only " + Reflection.getOrCreateKotlinClass(KonanCommandLineState.class));
        }
        KonanCommandLineState konanState = konanCommandLineState;
        boolean usePty = this.usePty();
        GeneralCommandLine cl = this.createCommandLine(usePty, konanState.getConfiguration());
        BaseProcessHandler baseProcessHandler = LocalHost.INSTANCE.createProcess(cl, true, usePty);
        Intrinsics.checkNotNullExpressionValue((Object)baseProcessHandler, (String)"LocalHost.INSTANCE.createProcess(cl, true, usePty)");
        return (ProcessHandler)baseProcessHandler;
    }

    @NotNull
    protected XDebugProcess createDebugProcess(@NotNull CommandLineState state, @NotNull XDebugSession session) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)session, (String)"session");
        CommandLineState commandLineState = state;
        if (!(commandLineState instanceof KonanCommandLineState)) {
            commandLineState = null;
        }
        KonanCommandLineState konanCommandLineState = (KonanCommandLineState)commandLineState;
        if (konanCommandLineState == null) {
            throw (Throwable)new IllegalStateException(Reflection.getOrCreateKotlinClass(KonanLauncher.class) + " is supposed to launch only " + Reflection.getOrCreateKotlinClass(KonanCommandLineState.class));
        }
        KonanCommandLineState konanState = konanCommandLineState;
        RunParameters runParameters = (RunParameters)KonanInstallerKt.createRunParameters(konanState.getConfiguration());
        TextConsoleBuilder textConsoleBuilder = konanState.getConsoleBuilder();
        Intrinsics.checkNotNullExpressionValue((Object)textConsoleBuilder, (String)"konanState.consoleBuilder");
        return (XDebugProcess)new KonanLocalDebugProcess(runParameters, session, textConsoleBuilder, (ConsoleFilterProvider)new DefaultConsoleFiltersProvider());
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean usePty() {
        Application application = ApplicationManager.getApplication();
        if (PtyCommandLine.isEnabled()) return true;
        Application application2 = application;
        Intrinsics.checkNotNullExpressionValue((Object)application2, (String)"application");
        if (application2.isInternal()) return true;
        if (!application.isUnitTestMode()) return false;
        return true;
    }

    private final GeneralCommandLine createCommandLine(boolean usePty, KonanRunConfiguration configuration2) throws ExecutionException {
        Object object = ApplicationManager.getApplication().runReadAction(new ThrowableComputable(usePty, configuration2){
            final /* synthetic */ boolean $usePty;
            final /* synthetic */ KonanRunConfiguration $configuration;

            /*
             * WARNING - void declaration
             */
            public final GeneralCommandLine compute() {
                void var1_1;
                GeneralCommandLine cl = this.$usePty ? (GeneralCommandLine)new PtyCommandLine() : new GeneralCommandLine();
                new KonanInstaller(this.$configuration).configureCommandLine(cl);
                return var1_1;
            }
            {
                this.$usePty = bl;
                this.$configuration = konanRunConfiguration;
            }
        });
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"ApplicationManager.getAp\u2026            cl\n        })");
        return (GeneralCommandLine)object;
    }

    public KonanLauncher(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        this.project = project2;
    }
}

