/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.console;

import com.intellij.codeInsight.lookup.LookupManager;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.DocumentEx;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.console.CommandHistory;
import org.jetbrains.kotlin.console.HistoryKeyListener$WhenMappings;
import org.jetbrains.kotlin.console.HistoryUpdateListener;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u00012\u00020\u0002:\u0001\u0019B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0016J\u0010\u0010\u0013\u001a\u00020\u00102\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0010\u0010\u0016\u001a\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u0018H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lorg/jetbrains/kotlin/console/HistoryKeyListener;", "Ljava/awt/event/KeyAdapter;", "Lorg/jetbrains/kotlin/console/HistoryUpdateListener;", "project", "Lcom/intellij/openapi/project/Project;", "consoleEditor", "Lcom/intellij/openapi/editor/ex/EditorEx;", "history", "Lorg/jetbrains/kotlin/console/CommandHistory;", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/editor/ex/EditorEx;Lorg/jetbrains/kotlin/console/CommandHistory;)V", "historyPos", "", "prevCaretOffset", "unfinishedCommand", "", "keyReleased", "", "e", "Ljava/awt/event/KeyEvent;", "moveHistoryCursor", "move", "Lorg/jetbrains/kotlin/console/HistoryKeyListener$HistoryMove;", "onNewEntry", "entry", "Lorg/jetbrains/kotlin/console/CommandHistory$Entry;", "HistoryMove", "kotlin.repl"})
public final class HistoryKeyListener
extends KeyAdapter
implements HistoryUpdateListener {
    private int historyPos;
    private int prevCaretOffset;
    private String unfinishedCommand;
    private final Project project;
    private final EditorEx consoleEditor;
    private final CommandHistory history;

    @Override
    public void onNewEntry(@NotNull CommandHistory.Entry entry) {
        Intrinsics.checkNotNullParameter((Object)entry, (String)"entry");
        this.historyPos = this.history.getSize();
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    @Override
    public void keyReleased(@NotNull KeyEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        switch (e.getKeyCode()) {
            case 38: {
                this.moveHistoryCursor(HistoryMove.UP);
                break;
            }
            case 40: {
                this.moveHistoryCursor(HistoryMove.DOWN);
                break;
            }
            case 37: 
            case 39: {
                CaretModel caretModel = this.consoleEditor.getCaretModel();
                Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"consoleEditor.caretModel");
                this.prevCaretOffset = caretModel.getOffset();
                break;
            }
        }
    }

    private final void moveHistoryCursor(HistoryMove move2) {
        if (this.history.getSize() == 0) {
            return;
        }
        LookupManager lookupManager = LookupManager.getInstance((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)lookupManager, (String)"LookupManager.getInstance(project)");
        if (lookupManager.getActiveLookup() != null) {
            return;
        }
        CaretModel caretModel = this.consoleEditor.getCaretModel();
        Intrinsics.checkNotNullExpressionValue((Object)caretModel, (String)"consoleEditor.caretModel");
        CaretModel caret = caretModel;
        DocumentEx documentEx = this.consoleEditor.getDocument();
        Intrinsics.checkNotNullExpressionValue((Object)documentEx, (String)"consoleEditor.document");
        DocumentEx document = documentEx;
        int curOffset = caret.getOffset();
        int curLine = document.getLineNumber(curOffset);
        int totalLines = document.getLineCount();
        boolean isMultiline2 = totalLines > 1;
        switch (HistoryKeyListener$WhenMappings.$EnumSwitchMapping$0[move2.ordinal()]) {
            case 1: {
                if (curLine != 0 || isMultiline2 && this.prevCaretOffset != 0) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                if (this.historyPos == this.history.getSize()) {
                    String string = document.getText();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"document.text");
                    this.unfinishedCommand = string;
                }
                int n = this.historyPos - 1;
                int n2 = 0;
                this.historyPos = Math.max(n, n2);
                WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, document, caret){
                    final /* synthetic */ HistoryKeyListener this$0;
                    final /* synthetic */ DocumentEx $document;
                    final /* synthetic */ CaretModel $caret;

                    public final void run() {
                        this.$document.setText((CharSequence)HistoryKeyListener.access$getHistory$p(this.this$0).get(HistoryKeyListener.access$getHistoryPos$p(this.this$0)).getEntryText());
                        EditorUtil.scrollToTheEnd((Editor)((Editor)HistoryKeyListener.access$getConsoleEditor$p(this.this$0)));
                        HistoryKeyListener.access$setPrevCaretOffset$p(this.this$0, 0);
                        this.$caret.moveToOffset(0);
                    }
                    {
                        this.this$0 = historyKeyListener;
                        this.$document = documentEx;
                        this.$caret = caretModel;
                    }
                });
                break;
            }
            case 2: {
                if (this.historyPos == this.history.getSize()) {
                    return;
                }
                if (curLine != totalLines - 1 || isMultiline2 && this.prevCaretOffset != document.getTextLength()) {
                    this.prevCaretOffset = curOffset;
                    return;
                }
                int n = this.historyPos + 1;
                int n3 = this.history.getSize();
                this.historyPos = Math.min(n, n3);
                WriteCommandAction.runWriteCommandAction((Project)this.project, (Runnable)new Runnable(this, document){
                    final /* synthetic */ HistoryKeyListener this$0;
                    final /* synthetic */ DocumentEx $document;

                    public final void run() {
                        this.$document.setText((CharSequence)(HistoryKeyListener.access$getHistoryPos$p(this.this$0) == HistoryKeyListener.access$getHistory$p(this.this$0).getSize() ? HistoryKeyListener.access$getUnfinishedCommand$p(this.this$0) : HistoryKeyListener.access$getHistory$p(this.this$0).get(HistoryKeyListener.access$getHistoryPos$p(this.this$0)).getEntryText()));
                        HistoryKeyListener.access$setPrevCaretOffset$p(this.this$0, this.$document.getTextLength());
                        EditorUtil.scrollToTheEnd((Editor)((Editor)HistoryKeyListener.access$getConsoleEditor$p(this.this$0)));
                    }
                    {
                        this.this$0 = historyKeyListener;
                        this.$document = documentEx;
                    }
                });
            }
        }
    }

    public HistoryKeyListener(@NotNull Project project2, @NotNull EditorEx consoleEditor, @NotNull CommandHistory history) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)consoleEditor, (String)"consoleEditor");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        this.project = project2;
        this.consoleEditor = consoleEditor;
        this.history = history;
        this.prevCaretOffset = -1;
        this.unfinishedCommand = "";
    }

    public static final /* synthetic */ CommandHistory access$getHistory$p(HistoryKeyListener $this) {
        return $this.history;
    }

    public static final /* synthetic */ int access$getHistoryPos$p(HistoryKeyListener $this) {
        return $this.historyPos;
    }

    public static final /* synthetic */ void access$setHistoryPos$p(HistoryKeyListener $this, int n) {
        $this.historyPos = n;
    }

    public static final /* synthetic */ EditorEx access$getConsoleEditor$p(HistoryKeyListener $this) {
        return $this.consoleEditor;
    }

    public static final /* synthetic */ int access$getPrevCaretOffset$p(HistoryKeyListener $this) {
        return $this.prevCaretOffset;
    }

    public static final /* synthetic */ void access$setPrevCaretOffset$p(HistoryKeyListener $this, int n) {
        $this.prevCaretOffset = n;
    }

    public static final /* synthetic */ String access$getUnfinishedCommand$p(HistoryKeyListener $this) {
        return $this.unfinishedCommand;
    }

    public static final /* synthetic */ void access$setUnfinishedCommand$p(HistoryKeyListener $this, String string) {
        $this.unfinishedCommand = string;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0082\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lorg/jetbrains/kotlin/console/HistoryKeyListener$HistoryMove;", "", "(Ljava/lang/String;I)V", "UP", "DOWN", "kotlin.repl"})
    private static final class HistoryMove
    extends Enum<HistoryMove> {
        public static final /* enum */ HistoryMove UP;
        public static final /* enum */ HistoryMove DOWN;
        private static final /* synthetic */ HistoryMove[] $VALUES;

        static {
            HistoryMove[] historyMoveArray = new HistoryMove[2];
            HistoryMove[] historyMoveArray2 = historyMoveArray;
            historyMoveArray[0] = UP = new HistoryMove();
            historyMoveArray[1] = DOWN = new HistoryMove();
            $VALUES = historyMoveArray;
        }

        public static HistoryMove[] values() {
            return (HistoryMove[])$VALUES.clone();
        }

        public static HistoryMove valueOf(String string) {
            return Enum.valueOf(HistoryMove.class, string);
        }
    }
}

