/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.artifacts;

import com.intellij.openapi.application.PathManager;
import com.intellij.util.io.PathKt;
import java.io.File;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.artifacts.AdditionalKotlinArtifacts;
import org.jetbrains.kotlin.idea.artifacts.LazyZipUnpacker;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinMavenUtils;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u001a\n\u0002\u0010\u000e\n\u0002\b\f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001fH\u0007J \u0010!\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010$\u001a\u00020\u001fH\u0002J \u0010%\u001a\u00020\u00042\u0006\u0010\"\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\b\b\u0002\u0010&\u001a\u00020\u001fJ \u0010'\u001a\u00020\u00042\u0006\u0010(\u001a\u00020\u001f2\u0006\u0010#\u001a\u00020\u001f2\u0006\u0010\"\u001a\u00020\u001fH\u0002J\u0010\u0010)\u001a\u00020\u001f2\u0006\u0010*\u001a\u00020\u001fH\u0007R!\u0010\u0003\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u0012\u0004\b\u0005\u0010\u0002\u001a\u0004\b\u0006\u0010\u0007R!\u0010\n\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\r\u0010\t\u0012\u0004\b\u000b\u0010\u0002\u001a\u0004\b\f\u0010\u0007R!\u0010\u000e\u001a\u00020\u00048FX\u0087\u0084\u0002\u00a2\u0006\u0012\n\u0004\b\u0011\u0010\t\u0012\u0004\b\u000f\u0010\u0002\u001a\u0004\b\u0010\u0010\u0007R\u001b\u0010\u0012\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0014\u0010\t\u001a\u0004\b\u0013\u0010\u0007R\u001b\u0010\u0015\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\t\u001a\u0004\b\u0016\u0010\u0007R\u001b\u0010\u0018\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001a\u0010\t\u001a\u0004\b\u0019\u0010\u0007R\u001b\u0010\u001b\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001d\u0010\t\u001a\u0004\b\u001c\u0010\u0007\u00a8\u0006+"}, d2={"Lorg/jetbrains/kotlin/idea/artifacts/AdditionalKotlinArtifacts;", "", "()V", "compilerTestDataDir", "Ljava/io/File;", "getCompilerTestDataDir$annotations", "getCompilerTestDataDir", "()Ljava/io/File;", "compilerTestDataDir$delegate", "Lkotlin/Lazy;", "jpsPluginTestDataDir", "getJpsPluginTestDataDir$annotations", "getJpsPluginTestDataDir", "jpsPluginTestDataDir$delegate", "jsIrRuntimeDir", "getJsIrRuntimeDir$annotations", "getJsIrRuntimeDir", "jsIrRuntimeDir$delegate", "jsr305", "getJsr305", "jsr305$delegate", "junit3", "getJunit3", "junit3$delegate", "kotlinStdlibCommon", "getKotlinStdlibCommon", "kotlinStdlibCommon$delegate", "kotlinStdlibCommonSources", "getKotlinStdlibCommonSources", "kotlinStdlibCommonSources$delegate", "compilerTestData", "", "compilerTestDataPath", "downloadAndUnpack", "libraryFileName", "artifactId", "dirName", "downloadArtifact", "extension", "getLibraryFile", "groupId", "jpsPluginTestData", "jpsTestDataPath", "kotlin.base.plugin"})
public final class AdditionalKotlinArtifacts {
    @NotNull
    private static final Lazy kotlinStdlibCommon$delegate;
    @NotNull
    private static final Lazy kotlinStdlibCommonSources$delegate;
    @NotNull
    private static final Lazy jsr305$delegate;
    @NotNull
    private static final Lazy junit3$delegate;
    @NotNull
    private static final Lazy compilerTestDataDir$delegate;
    @NotNull
    private static final Lazy jpsPluginTestDataDir$delegate;
    @NotNull
    private static final Lazy jsIrRuntimeDir$delegate;
    @NotNull
    public static final AdditionalKotlinArtifacts INSTANCE;

    private final File getLibraryFile(String groupId2, String artifactId2, String libraryFileName) {
        String string = KotlinMavenUtils.INSTANCE.findLibraryVersion(libraryFileName);
        if (string == null) {
            String string2 = "Cannot find library version for library " + libraryFileName;
            throw new IllegalStateException(string2.toString());
        }
        String version2 = string;
        File file2 = KotlinMavenUtils.INSTANCE.findArtifactOrFail(groupId2, artifactId2, version2).toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"KotlinMavenUtils.findArt\u2026factId, version).toFile()");
        return file2;
    }

    @NotNull
    public final File getKotlinStdlibCommon() {
        Lazy lazy = kotlinStdlibCommon$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getKotlinStdlibCommonSources() {
        Lazy lazy = kotlinStdlibCommonSources$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getJsr305() {
        Lazy lazy = jsr305$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @NotNull
    public final File getJunit3() {
        Lazy lazy = junit3$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = this;
        Object var3_3 = null;
        return (File)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getCompilerTestDataDir$annotations() {
    }

    @NotNull
    public static final File getCompilerTestDataDir() {
        Lazy lazy = compilerTestDataDir$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = INSTANCE;
        Object var2_2 = null;
        return (File)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final String compilerTestData(@NotNull String compilerTestDataPath) {
        Intrinsics.checkNotNullParameter((Object)compilerTestDataPath, (String)"compilerTestDataPath");
        String string = FilesKt.resolve((File)AdditionalKotlinArtifacts.getCompilerTestDataDir(), (String)compilerTestDataPath).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"compilerTestDataDir.reso\u2026stDataPath).canonicalPath");
        return string;
    }

    @JvmStatic
    public static /* synthetic */ void getJpsPluginTestDataDir$annotations() {
    }

    @NotNull
    public static final File getJpsPluginTestDataDir() {
        Lazy lazy = jpsPluginTestDataDir$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = INSTANCE;
        Object var2_2 = null;
        return (File)lazy.getValue();
    }

    @JvmStatic
    public static /* synthetic */ void getJsIrRuntimeDir$annotations() {
    }

    @NotNull
    public static final File getJsIrRuntimeDir() {
        Lazy lazy = jsIrRuntimeDir$delegate;
        AdditionalKotlinArtifacts additionalKotlinArtifacts = INSTANCE;
        Object var2_2 = null;
        return (File)lazy.getValue();
    }

    @JvmStatic
    @NotNull
    public static final String jpsPluginTestData(@NotNull String jpsTestDataPath) {
        Intrinsics.checkNotNullParameter((Object)jpsTestDataPath, (String)"jpsTestDataPath");
        String string = FilesKt.resolve((File)AdditionalKotlinArtifacts.getJpsPluginTestDataDir(), (String)jpsTestDataPath).getCanonicalPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jpsPluginTestDataDir.res\u2026stDataPath).canonicalPath");
        return string;
    }

    private final File downloadAndUnpack(String libraryFileName, String artifactId2, String dirName) {
        File jar = AdditionalKotlinArtifacts.downloadArtifact$default(this, libraryFileName, artifactId2, null, 4, null);
        return new LazyZipUnpacker(FilesKt.resolve((File)FilesKt.resolve((File)new File(PathManager.getCommunityHomePath()), (String)"out"), (String)dirName)).lazyUnpack(jar);
    }

    @NotNull
    public final File downloadArtifact(@NotNull String libraryFileName, @NotNull String artifactId2, @NotNull String extension) {
        Path jar;
        Path it2;
        Intrinsics.checkNotNullParameter((Object)libraryFileName, (String)"libraryFileName");
        Intrinsics.checkNotNullParameter((Object)artifactId2, (String)"artifactId");
        Intrinsics.checkNotNullParameter((Object)extension, (String)"extension");
        String string = KotlinMavenUtils.INSTANCE.findLibraryVersion(libraryFileName);
        if (string == null) {
            String string2 = "Can't get '" + libraryFileName + "' version";
            throw new IllegalStateException(string2.toString());
        }
        String version2 = string;
        Path path2 = KotlinMavenUtils.INSTANCE.findArtifact("org.jetbrains.kotlin", artifactId2, version2);
        if (path2 != null) {
            Path path3;
            Path it2 = path3 = path2;
            boolean bl = false;
            File file2 = it2.toFile();
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"it.toFile()");
            return file2;
        }
        Path it3 = it2 = Paths.get(PathManager.getCommunityHomePath(), new String[0]).resolve("out").resolve(artifactId2 + "-" + version2 + "." + extension);
        boolean bl = false;
        Path path4 = it3;
        Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"it");
        Files.createDirectories(path4.getParent(), new FileAttribute[0]);
        Path path5 = jar = it2;
        Intrinsics.checkNotNullExpressionValue((Object)path5, (String)"jar");
        if (!PathKt.exists((Path)path5)) {
            InputStream stream = new URL("https://cache-redirector.jetbrains.com/maven.pkg.jetbrains.space/kotlin/p/kotlin/kotlin-ide-plugin-dependencies/org/jetbrains/kotlin/" + artifactId2 + "/" + version2 + "/" + artifactId2 + "-" + version2 + "." + extension).openStream();
            Files.copy(stream, jar, new CopyOption[0]);
            boolean bl2 = PathKt.exists((Path)jar);
            if (!bl2) {
                boolean bl3 = false;
                String string3 = jar + " should be downloaded";
                throw new IllegalStateException(string3.toString());
            }
        }
        File file3 = jar.toFile();
        Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"jar.toFile()");
        return file3;
    }

    public static /* synthetic */ File downloadArtifact$default(AdditionalKotlinArtifacts additionalKotlinArtifacts, String string, String string2, String string3, int n, Object object) {
        if ((n & 4) != 0) {
            string3 = "jar";
        }
        return additionalKotlinArtifacts.downloadArtifact(string, string2, string3);
    }

    private AdditionalKotlinArtifacts() {
    }

    static {
        AdditionalKotlinArtifacts additionalKotlinArtifacts;
        INSTANCE = additionalKotlinArtifacts = new AdditionalKotlinArtifacts();
        kotlinStdlibCommon$delegate = LazyKt.lazy((Function0)kotlinStdlibCommon.2.INSTANCE);
        kotlinStdlibCommonSources$delegate = LazyKt.lazy((Function0)kotlinStdlibCommonSources.2.INSTANCE);
        jsr305$delegate = LazyKt.lazy((Function0)jsr305.2.INSTANCE);
        junit3$delegate = LazyKt.lazy((Function0)junit3.2.INSTANCE);
        compilerTestDataDir$delegate = LazyKt.lazy((Function0)compilerTestDataDir.2.INSTANCE);
        jpsPluginTestDataDir$delegate = LazyKt.lazy((Function0)jpsPluginTestDataDir.2.INSTANCE);
        jsIrRuntimeDir$delegate = LazyKt.lazy((Function0)jsIrRuntimeDir.2.INSTANCE);
    }

    public static final /* synthetic */ File access$getLibraryFile(AdditionalKotlinArtifacts $this, String groupId2, String artifactId2, String libraryFileName) {
        return $this.getLibraryFile(groupId2, artifactId2, libraryFileName);
    }

    public static final /* synthetic */ File access$downloadAndUnpack(AdditionalKotlinArtifacts $this, String libraryFileName, String artifactId2, String dirName) {
        return $this.downloadAndUnpack(libraryFileName, artifactId2, dirName);
    }
}

