/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.compiler.configuration;

import java.util.Set;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinIdePluginVersion;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\u0018\u0000 \u00102\u00020\u0001:\u0001\u0010B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tR\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\nR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000e\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinIdePluginVersion;", "", "rawVersion", "", "platformVersion", "isAndroidStudio", "", "kotlinCompilerVersion", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "(Ljava/lang/String;Ljava/lang/String;ZLorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;)V", "()Z", "getKotlinCompilerVersion", "()Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "getPlatformVersion", "()Ljava/lang/String;", "getRawVersion", "Companion", "kotlin.base.plugin"})
public final class KotlinIdePluginVersion {
    @NotNull
    private final String rawVersion;
    @NotNull
    private final String platformVersion;
    private final boolean isAndroidStudio;
    @NotNull
    private final IdeKotlinVersion kotlinCompilerVersion;
    private static final String ANDROID_STUDIO_PLATFORM_IDENTIFIER = "AS";
    private static final Set<String> PLATFORM_IDENTIFIERS;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final String getRawVersion() {
        return this.rawVersion;
    }

    @NotNull
    public final String getPlatformVersion() {
        return this.platformVersion;
    }

    public final boolean isAndroidStudio() {
        return this.isAndroidStudio;
    }

    @NotNull
    public final IdeKotlinVersion getKotlinCompilerVersion() {
        return this.kotlinCompilerVersion;
    }

    public KotlinIdePluginVersion(@NotNull String rawVersion, @NotNull String platformVersion, boolean isAndroidStudio, @NotNull IdeKotlinVersion kotlinCompilerVersion) {
        Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
        Intrinsics.checkNotNullParameter((Object)platformVersion, (String)"platformVersion");
        Intrinsics.checkNotNullParameter((Object)kotlinCompilerVersion, (String)"kotlinCompilerVersion");
        this.rawVersion = rawVersion;
        this.platformVersion = platformVersion;
        this.isAndroidStudio = isAndroidStudio;
        this.kotlinCompilerVersion = kotlinCompilerVersion;
    }

    static {
        Companion = new Companion(null);
        PLATFORM_IDENTIFIERS = SetsKt.setOf((Object[])new String[]{"IJ", "AC", ANDROID_STUDIO_PLATFORM_IDENTIFIER});
    }

    public static final /* synthetic */ Set access$getPLATFORM_IDENTIFIERS$cp() {
        return PLATFORM_IDENTIFIERS;
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J$\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\b2\u0006\u0010\n\u001a\u00020\u0004\u00f8\u0001\u0000\u00f8\u0001\u0001\u00f8\u0001\u0002\u00a2\u0006\u0004\b\u000b\u0010\fJ\u0012\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\n\u001a\u00020\u0004H\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00040\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u0082\u0002\u000f\n\u0002\b\u0019\n\u0002\b!\n\u0005\b\u00a1\u001e0\u0001\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinIdePluginVersion$Companion;", "", "()V", "ANDROID_STUDIO_PLATFORM_IDENTIFIER", "", "PLATFORM_IDENTIFIERS", "", "parse", "Lkotlin/Result;", "Lorg/jetbrains/kotlin/idea/compiler/configuration/KotlinIdePluginVersion;", "rawVersion", "parse-IoAF18A", "(Ljava/lang/String;)Ljava/lang/Object;", "parseVersionSuffix", "kotlin.base.plugin"})
    public static final class Companion {
        @NotNull
        public final Object parse-IoAF18A(@NotNull String rawVersion) {
            Intrinsics.checkNotNullParameter((Object)rawVersion, (String)"rawVersion");
            String platformReleaseBranchName = StringsKt.substringBefore$default((String)rawVersion, (char)'-', null, (int)2, null);
            Integer n = StringsKt.toIntOrNull((String)platformReleaseBranchName);
            if (n == null) {
                Result.Companion companion = Result.Companion;
                Throwable throwable = new IllegalArgumentException("Invalid platform branch name: " + rawVersion);
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            int platformReleaseBranchInt = n;
            if (platformReleaseBranchInt < 100 || platformReleaseBranchInt >= 1000) {
                String message2 = "Invalid platform branch name, should be in [100; 1000), got " + platformReleaseBranchName + ": " + rawVersion;
                Result.Companion companion = Result.Companion;
                Throwable throwable = new IllegalArgumentException(message2);
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String platformVersion = String.valueOf(2000 + platformReleaseBranchInt / 10) + "." + String.valueOf(platformReleaseBranchInt % 10);
            String string = this.parseVersionSuffix(rawVersion);
            if (string == null) {
                Result.Companion companion = Result.Companion;
                Throwable throwable = new IllegalArgumentException("Cannot find version suffix: " + rawVersion);
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
            }
            String versionSuffix = string;
            boolean isAndroidStudio = StringsKt.startsWith$default((String)versionSuffix, (String)KotlinIdePluginVersion.ANDROID_STUDIO_PLATFORM_IDENTIFIER, (boolean)false, (int)2, null);
            String string2 = rawVersion;
            int n2 = platformReleaseBranchName.length() + 1;
            int n3 = rawVersion.length() - versionSuffix.length() - 1;
            String string3 = string2.substring(n2, n3);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"this as java.lang.String\u2026ing(startIndex, endIndex)");
            String rawKotlinVersion = string3;
            Object object = IdeKotlinVersion.Companion.parse-IoAF18A(rawKotlinVersion);
            Throwable throwable = Result.exceptionOrNull-impl((Object)object);
            if (throwable != null) {
                Throwable it = throwable;
                boolean bl = false;
                Result.Companion companion = Result.Companion;
                return Result.constructor-impl((Object)ResultKt.createFailure((Throwable)it));
            }
            IdeKotlinVersion kotlinCompilerVersion = (IdeKotlinVersion)object;
            KotlinIdePluginVersion version2 = new KotlinIdePluginVersion(rawVersion, platformVersion, isAndroidStudio, kotlinCompilerVersion);
            throwable = Result.Companion;
            return Result.constructor-impl((Object)version2);
        }

        private final String parseVersionSuffix(String rawVersion) {
            int lastIndex = StringsKt.lastIndexOf$default((CharSequence)rawVersion, (char)'-', (int)0, (boolean)false, (int)6, null);
            if (lastIndex < 0) {
                return null;
            }
            parseVersionSuffix.1 $fun$isValidSuffix$1 = parseVersionSuffix.1.INSTANCE;
            String string = rawVersion;
            int n = lastIndex + 1;
            String string2 = string.substring(n);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            String shortSuffix = string2;
            if ($fun$isValidSuffix$1.invoke(shortSuffix)) {
                return shortSuffix;
            }
            int beforeLastIndex = StringsKt.lastIndexOf$default((CharSequence)rawVersion, (char)'-', (int)(lastIndex - 1), (boolean)false, (int)4, null);
            if (beforeLastIndex < 0) {
                return null;
            }
            String string3 = rawVersion;
            int n2 = beforeLastIndex + 1;
            String string4 = string3.substring(n2);
            Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"this as java.lang.String).substring(startIndex)");
            String longSuffix = string4;
            if ($fun$isValidSuffix$1.invoke(longSuffix)) {
                return longSuffix;
            }
            return null;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

