/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.configuration;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.NonBlockingReadAction;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.search.FileTypeIndex;
import com.intellij.psi.search.GlobalSearchScope;
import java.util.LinkedHashSet;
import java.util.Set;
import java.util.concurrent.Callable;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference1;
import kotlin.jvm.internal.MutablePropertyReference1Impl;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.KotlinFileType;
import org.jetbrains.kotlin.idea.compiler.configuration.IdeKotlinVersion;
import org.jetbrains.kotlin.idea.compiler.configuration.KotlinJpsPluginSettings;
import org.jetbrains.kotlin.idea.configuration.BuildSystemType;
import org.jetbrains.kotlin.idea.configuration.BuildSystemTypeKt;
import org.jetbrains.kotlin.idea.core.KotlinPluginDisposable;
import org.jetbrains.kotlin.psi.UserDataProperty;

@Metadata(mv={1, 5, 1}, k=2, d1={"\u00002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000b2\u0006\u0010\r\u001a\u00020\u000e\u001a\u0010\u0010\u000f\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e\u001a\u000e\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003\u001a\u000e\u0010\u0013\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0003\u001a-\u0010\u0014\u001a\u0002H\u0015\"\u0004\b\u0000\u0010\u0015*\u00020\u000e2\b\b\u0002\u0010\u0016\u001a\u00020\u00112\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u0002H\u00150\u0018\u00a2\u0006\u0002\u0010\u0019\"3\u0010\u0002\u001a\u0004\u0018\u00010\u0001*\u00020\u00032\b\u0010\u0000\u001a\u0004\u0018\u00010\u00018F@FX\u0086\u008e\u0002\u00a2\u0006\u0012\n\u0004\b\b\u0010\t\u001a\u0004\b\u0004\u0010\u0005\"\u0004\b\u0006\u0010\u0007\u00a8\u0006\u001a"}, d2={"<set-?>", "", "externalCompilerVersion", "Lcom/intellij/openapi/module/Module;", "getExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", "setExternalCompilerVersion", "(Lcom/intellij/openapi/module/Module;Ljava/lang/String;)V", "externalCompilerVersion$delegate", "Lorg/jetbrains/kotlin/psi/UserDataProperty;", "findExternalKotlinCompilerVersions", "", "Lorg/jetbrains/kotlin/idea/compiler/configuration/IdeKotlinVersion;", "project", "Lcom/intellij/openapi/project/Project;", "findLatestExternalKotlinCompilerVersion", "hasKotlinFilesInSources", "", "module", "hasKotlinFilesOnlyInTests", "syncNonBlockingReadAction", "T", "smartMode", "task", "Lkotlin/Function0;", "(Lcom/intellij/openapi/project/Project;ZLkotlin/jvm/functions/Function0;)Ljava/lang/Object;", "kotlin.idea"})
public final class ProjectUtilsKt {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    @Nullable
    private static final UserDataProperty externalCompilerVersion$delegate;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.mutableProperty1((MutablePropertyReference1)new MutablePropertyReference1Impl(ProjectUtilsKt.class, "externalCompilerVersion", "getExternalCompilerVersion(Lcom/intellij/openapi/module/Module;)Ljava/lang/String;", 1))};
        Key key = Key.create((String)"EXTERNAL_COMPILER_VERSION");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"Key.create(\"EXTERNAL_COMPILER_VERSION\")");
        externalCompilerVersion$delegate = new UserDataProperty(key);
    }

    public static final boolean hasKotlinFilesOnlyInTests(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return !ProjectUtilsKt.hasKotlinFilesInSources(module2) && FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module2.getModuleScope(true));
    }

    public static final boolean hasKotlinFilesInSources(@NotNull Module module2) {
        Intrinsics.checkNotNullParameter((Object)module2, (String)"module");
        return FileTypeIndex.containsFileOfType((FileType)((FileType)KotlinFileType.INSTANCE), (GlobalSearchScope)module2.getModuleScope(false));
    }

    @Nullable
    public static final String getExternalCompilerVersion(@NotNull Module $this$externalCompilerVersion) {
        Intrinsics.checkNotNullParameter((Object)$this$externalCompilerVersion, (String)"$this$externalCompilerVersion");
        return (String)externalCompilerVersion$delegate.getValue((UserDataHolder)$this$externalCompilerVersion, $$delegatedProperties[0]);
    }

    public static final void setExternalCompilerVersion(@NotNull Module $this$externalCompilerVersion, @Nullable String string) {
        Intrinsics.checkNotNullParameter((Object)$this$externalCompilerVersion, (String)"$this$externalCompilerVersion");
        externalCompilerVersion$delegate.setValue((UserDataHolder)$this$externalCompilerVersion, $$delegatedProperties[0], (Object)string);
    }

    @Nullable
    public static final IdeKotlinVersion findLatestExternalKotlinCompilerVersion(@NotNull Project project2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        return (IdeKotlinVersion)CollectionsKt.maxOrNull((Iterable)ProjectUtilsKt.findExternalKotlinCompilerVersions(project2));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final Set<IdeKotlinVersion> findExternalKotlinCompilerVersions(@NotNull Project project2) {
        void hasJpsModules;
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        LinkedHashSet<IdeKotlinVersion> result2 = new LinkedHashSet<IdeKotlinVersion>();
        Ref.BooleanRef booleanRef = new Ref.BooleanRef();
        booleanRef.element = false;
        boolean $i$f$runReadAction = false;
        ApplicationManager.getApplication().runReadAction(new Computable(project2, (Ref.BooleanRef)hasJpsModules, result2){
            final /* synthetic */ Project $project$inlined;
            final /* synthetic */ Ref.BooleanRef $hasJpsModules$inlined;
            final /* synthetic */ LinkedHashSet $result$inlined;
            {
                this.$project$inlined = project2;
                this.$hasJpsModules$inlined = booleanRef;
                this.$result$inlined = linkedHashSet;
            }

            public final T compute() {
                boolean bl = false;
                ModuleManager moduleManager = ModuleManager.getInstance((Project)this.$project$inlined);
                Intrinsics.checkNotNullExpressionValue((Object)moduleManager, (String)"ModuleManager.getInstance(project)");
                Module[] moduleArray = moduleManager.getModules();
                int n = moduleArray.length;
                for (int i = 0; i < n; ++i) {
                    IdeKotlinVersion externalVersion;
                    IdeKotlinVersion ideKotlinVersion;
                    Module module2;
                    Module module3 = module2 = moduleArray[i];
                    Intrinsics.checkNotNullExpressionValue((Object)module3, (String)"module");
                    if (BuildSystemTypeKt.getBuildSystemType(module3) == BuildSystemType.JPS) {
                        if (this.$hasJpsModules$inlined.element) continue;
                        this.$hasJpsModules$inlined.element = true;
                        continue;
                    }
                    if (ProjectUtilsKt.getExternalCompilerVersion(module2) != null) {
                        String string;
                        IdeKotlinVersion.Companion companion = IdeKotlinVersion.Companion;
                        String p1 = string;
                        boolean bl2 = false;
                        ideKotlinVersion = companion.opt(p1);
                    } else {
                        ideKotlinVersion = externalVersion = null;
                    }
                    if (externalVersion == null) continue;
                    this.$result$inlined.add(externalVersion);
                }
                return (T)Unit.INSTANCE;
            }
        });
        if (hasJpsModules.element) {
            IdeKotlinVersion projectGlobalVersion;
            IdeKotlinVersion ideKotlinVersion;
            String string = KotlinJpsPluginSettings.Companion.jpsVersion(project2);
            if (string != null) {
                String string2 = string;
                IdeKotlinVersion.Companion companion = IdeKotlinVersion.Companion;
                String p1 = string2;
                boolean bl = false;
                ideKotlinVersion = companion.opt(p1);
            } else {
                ideKotlinVersion = projectGlobalVersion = null;
            }
            if (projectGlobalVersion != null) {
                result2.add(projectGlobalVersion);
            }
        }
        return result2;
    }

    public static final <T> T syncNonBlockingReadAction(@NotNull Project $this$syncNonBlockingReadAction, boolean smartMode, @NotNull Function0<? extends T> task2) {
        NonBlockingReadAction nonBlockingReadAction;
        Intrinsics.checkNotNullParameter((Object)$this$syncNonBlockingReadAction, (String)"$this$syncNonBlockingReadAction");
        Intrinsics.checkNotNullParameter(task2, (String)"task");
        NonBlockingReadAction it = nonBlockingReadAction = ReadAction.nonBlocking((Callable)new Callable(task2){
            final /* synthetic */ Function0 $task;

            public final T call() {
                return (T)this.$task.invoke();
            }
            {
                this.$task = function0;
            }
        }).expireWith((Disposable)KotlinPluginDisposable.Companion.getInstance($this$syncNonBlockingReadAction));
        boolean bl = false;
        return (T)(smartMode ? it.inSmartMode($this$syncNonBlockingReadAction) : it).executeSynchronously();
    }

    public static /* synthetic */ Object syncNonBlockingReadAction$default(Project project2, boolean bl, Function0 function0, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return ProjectUtilsKt.syncNonBlockingReadAction(project2, bl, function0);
    }
}

