/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger;

import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.io.PathKt;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.idea.caches.project.MultiplatformUtilKt;
import org.jetbrains.kotlin.idea.debugger.CompoundVirtualFileFinder;
import org.jetbrains.kotlin.idea.util.ProjectRootsUtil;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinder;
import org.jetbrains.kotlin.load.kotlin.VirtualFileFinderFactory;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\f\u001a\u0004\u0018\u00010\rJ\n\u0010\u000e\u001a\u0004\u0018\u00010\rH\u0002J\n\u0010\u000f\u001a\u0004\u0018\u00010\rH\u0002J\u0012\u0010\u0010\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\r2\u0006\u0010\t\u001a\u00020\nH\u0002J\u000e\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0002J\b\u0010\u0015\u001a\u00020\u0016H\u0002J\u0012\u0010\u0017\u001a\u0004\u0018\u00010\r2\u0006\u0010\u0006\u001a\u00020\u0007H\u0002R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0015\u0010\t\u001a\t\u0018\u00010\n\u00a2\u0006\u0002\b\u000bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/ClassBytecodeFinder;", "", "project", "Lcom/intellij/openapi/project/Project;", "jvmName", "Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "(Lcom/intellij/openapi/project/Project;Lorg/jetbrains/kotlin/resolve/jvm/JvmClassName;Lcom/intellij/openapi/vfs/VirtualFile;)V", "module", "Lcom/intellij/openapi/module/Module;", "Lorg/jetbrains/annotations/Nullable;", "find", "", "findInCompilerOutput", "findInLibraries", "findInModuleOutput", "findInSingleModuleOutput", "findTopLevelClassNameVariants", "", "", "getFinderForLibrary", "Lorg/jetbrains/kotlin/load/kotlin/VirtualFileFinder;", "readFile", "Companion", "kotlin.jvm-debugger.util"})
public final class ClassBytecodeFinder {
    private final Module module;
    private final Project project;
    private final JvmClassName jvmName;
    private final VirtualFile file;
    @Deprecated
    private static final Logger LOG;
    @NotNull
    private static final Companion Companion;

    @Nullable
    public final byte[] find() {
        byte[] byArray = this.findInCompilerOutput();
        if (byArray == null) {
            byArray = this.findInLibraries();
        }
        return byArray;
    }

    private final byte[] findInLibraries() {
        if (!ProjectRootsUtil.isLibrarySourceFile(this.project, this.file)) {
            return null;
        }
        String string = this.jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"jvmName.internalName");
        String classFileName = StringsKt.substringAfterLast$default((String)string, (char)'/', null, (int)2, null);
        VirtualFileFinder fileFinder = this.getFinderForLibrary();
        for (String variant : this.findTopLevelClassNameVariants()) {
            VirtualFile classFile;
            ClassId classId = ClassId.fromString((String)variant);
            Intrinsics.checkNotNullExpressionValue((Object)classId, (String)"ClassId.fromString(variant)");
            VirtualFile variantClassFile = fileFinder.findVirtualFileWithHeader(classId);
            if (variantClassFile != null && Intrinsics.areEqual((Object)variant, (Object)this.jvmName.getInternalName())) {
                return this.readFile(variantClassFile);
            }
            VirtualFile virtualFile2 = variantClassFile;
            Object packageDir = virtualFile2 != null ? virtualFile2.getParent() : null;
            if (packageDir == null || (classFile = packageDir.findChild(classFileName + ".class")) == null) continue;
            return this.readFile(classFile);
        }
        return null;
    }

    private final byte[] readFile(VirtualFile file2) {
        try {
            return file2.contentsToByteArray(false);
        }
        catch (IOException e) {
            LOG.debug("Can't read class file " + this.jvmName, (Throwable)e);
            return null;
        }
    }

    private final VirtualFileFinder getFinderForLibrary() {
        VirtualFileFinder virtualFileFinder2;
        Collection collection;
        VirtualFileFinderFactory fileFinderFactory = VirtualFileFinderFactory.SERVICE.getInstance(this.project);
        List fileFinders = new ArrayList();
        if (this.module != null) {
            collection = fileFinders;
            GlobalSearchScope globalSearchScope = GlobalSearchScope.moduleWithLibrariesScope((Module)this.module);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.moduleWithLibrariesScope(module)");
            virtualFileFinder2 = fileFinderFactory.create(globalSearchScope);
            collection.add(virtualFileFinder2);
            collection = fileFinders;
            GlobalSearchScope globalSearchScope2 = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)this.module);
            Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope2, (String)"GlobalSearchScope.module\u2026AndLibrariesScope(module)");
            virtualFileFinder2 = fileFinderFactory.create(globalSearchScope2);
            collection.add(virtualFileFinder2);
        }
        collection = fileFinders;
        GlobalSearchScope globalSearchScope = GlobalSearchScope.allScope((Project)this.project);
        Intrinsics.checkNotNullExpressionValue((Object)globalSearchScope, (String)"GlobalSearchScope.allScope(project)");
        virtualFileFinder2 = fileFinderFactory.create(globalSearchScope);
        collection.add(virtualFileFinder2);
        return new CompoundVirtualFileFinder(fileFinders);
    }

    private final List<String> findTopLevelClassNameVariants() {
        String string;
        Collection collection;
        List result2 = new ArrayList();
        String string2 = this.jvmName.getInternalName();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"jvmName.internalName");
        String jdiName = StringsKt.replace$default((String)string2, (char)'/', (char)'.', (boolean)false, (int)4, null);
        int index2 = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)1, (boolean)false, (int)4, null);
        while (index2 >= 0) {
            collection = result2;
            string = StringsKt.take((String)jdiName, (int)index2);
            collection.add(string);
            index2 = StringsKt.indexOf$default((CharSequence)jdiName, (char)'$', (int)(index2 + 1), (boolean)false, (int)4, null);
        }
        collection = result2;
        string = this.jvmName.getInternalName();
        collection.add(string);
        return result2;
    }

    private final byte[] findInCompilerOutput() {
        if (!ProjectRootsUtil.isProjectSourceFile$default(this.project, this.file, false, 4, null)) {
            return null;
        }
        if (this.module != null) {
            return this.findInModuleOutput(this.module);
        }
        return null;
    }

    private final byte[] findInModuleOutput(Module module2) {
        byte[] byArray = this.findInSingleModuleOutput(module2);
        if (byArray != null) {
            byte[] byArray2;
            byte[] it = byArray2 = byArray;
            boolean bl = false;
            return it;
        }
        for (Module implementing : MultiplatformUtilKt.getImplementingModules(module2)) {
            byte[] byArray3;
            byte[] byArray4 = this.findInSingleModuleOutput(implementing);
            if (byArray4 == null) continue;
            byte[] it = byArray3 = byArray4;
            boolean bl = false;
            return it;
        }
        return null;
    }

    private final byte[] findInSingleModuleOutput(Module module2) {
        Object[] objectArray = CompilerPaths.getOutputPaths((Module[])new Module[]{module2});
        Intrinsics.checkNotNullExpressionValue((Object)objectArray, (String)"CompilerPaths.getOutputPaths(arrayOf(module))");
        for (String outputRoot : ArraysKt.toList((Object[])objectArray)) {
            Path path2;
            Path path3 = path2 = Path.of(outputRoot, this.jvmName.getInternalName() + ".class");
            Intrinsics.checkNotNullExpressionValue((Object)path3, (String)"path");
            if (!PathKt.isFile((Path)path3)) continue;
            try {
                return PathKt.readBytes((Path)path2);
            }
            catch (IOException e) {
                LOG.debug("Can't read class file " + this.jvmName, (Throwable)e);
                return null;
            }
        }
        return null;
    }

    public ClassBytecodeFinder(@NotNull Project project2, @NotNull JvmClassName jvmName, @NotNull VirtualFile file2) {
        Intrinsics.checkNotNullParameter((Object)project2, (String)"project");
        Intrinsics.checkNotNullParameter((Object)jvmName, (String)"jvmName");
        Intrinsics.checkNotNullParameter((Object)file2, (String)"file");
        this.project = project2;
        this.jvmName = jvmName;
        this.file = file2;
        this.module = ProjectFileIndex.getInstance((Project)this.project).getModuleForFile(this.file);
    }

    static {
        Companion = new Companion(null);
        Logger logger = Logger.getInstance(ClassBytecodeFinder.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"Logger.getInstance(Class\u2026tecodeFinder::class.java)");
        LOG = logger;
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0016\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0013\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/ClassBytecodeFinder$Companion;", "", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "Lorg/jetbrains/annotations/NotNull;", "kotlin.jvm-debugger.util"})
    private static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

