/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.idea.debugger.coroutine.proxy;

import com.intellij.debugger.engine.DebuggerManagerThreadImpl;
import com.intellij.debugger.engine.SuspendContextImpl;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadOnlyProperty;
import kotlin.reflect.KProperty;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.idea.debugger.coroutine.CoroutinesInfoFromJsonAndReferencesProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoCache;
import org.jetbrains.kotlin.idea.debugger.coroutine.data.CoroutineInfoData;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineDebugProbesProxyKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineInfoProvider;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineLibraryAgent2Proxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.CoroutineNoLibraryProxy;
import org.jetbrains.kotlin.idea.debugger.coroutine.proxy.mirror.DebugProbesImpl;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.CoroutineUtilsKt;
import org.jetbrains.kotlin.idea.debugger.coroutine.util.ProvidersKt;
import org.jetbrains.kotlin.idea.debugger.evaluate.DefaultExecutionContext;

@Metadata(mv={1, 5, 1}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u0000 \r2\u00020\u0001:\u0001\rB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0006\u0010\u0007\u001a\u00020\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u000e"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy;", "", "suspendContext", "Lcom/intellij/debugger/engine/SuspendContextImpl;", "(Lcom/intellij/debugger/engine/SuspendContextImpl;)V", "getSuspendContext", "()Lcom/intellij/debugger/engine/SuspendContextImpl;", "dumpCoroutines", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/data/CoroutineInfoCache;", "findProvider", "Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineInfoProvider;", "executionContext", "Lorg/jetbrains/kotlin/idea/debugger/evaluate/DefaultExecutionContext;", "Companion", "kotlin.jvm-debugger.coroutines"})
public final class CoroutineDebugProbesProxy {
    @NotNull
    private final SuspendContextImpl suspendContext;
    private static final ReadOnlyProperty log$delegate;
    @NotNull
    public static final Companion Companion;

    @NotNull
    public final synchronized CoroutineInfoCache dumpCoroutines() {
        DebuggerManagerThreadImpl.assertIsManagerThread();
        CoroutineInfoCache coroutineInfoCache = new CoroutineInfoCache(null, null, 3, null);
        try {
            DefaultExecutionContext defaultExecutionContext = CoroutineUtilsKt.executionContext(this.suspendContext);
            if (defaultExecutionContext == null) {
                return coroutineInfoCache.fail();
            }
            DefaultExecutionContext executionContext2 = defaultExecutionContext;
            CoroutineInfoProvider coroutineInfoProvider = this.findProvider(executionContext2);
            if (coroutineInfoProvider == null) {
                return coroutineInfoCache.ok();
            }
            CoroutineInfoProvider libraryAgentProxy = coroutineInfoProvider;
            List<CoroutineInfoData> infoList = libraryAgentProxy.dumpCoroutinesInfo();
            coroutineInfoCache.ok(infoList);
        }
        catch (Throwable e) {
            CoroutineDebugProbesProxy.Companion.getLog().error("Exception is thrown by calling dumpCoroutines.", e);
            coroutineInfoCache.fail();
        }
        return coroutineInfoCache;
    }

    private final CoroutineInfoProvider findProvider(DefaultExecutionContext executionContext2) {
        CoroutineInfoProvider coroutineInfoProvider;
        DebugProbesImpl debugProbesImpl = DebugProbesImpl.Companion.instance(executionContext2);
        if (debugProbesImpl != null && debugProbesImpl.isInstalled()) {
            CoroutinesInfoFromJsonAndReferencesProvider coroutinesInfoFromJsonAndReferencesProvider = CoroutinesInfoFromJsonAndReferencesProvider.Companion.instance(executionContext2, debugProbesImpl);
            coroutineInfoProvider = coroutinesInfoFromJsonAndReferencesProvider != null ? (CoroutineInfoProvider)coroutinesInfoFromJsonAndReferencesProvider : (CoroutineInfoProvider)new CoroutineLibraryAgent2Proxy(executionContext2, debugProbesImpl);
        } else {
            coroutineInfoProvider = CoroutineDebugProbesProxyKt.standaloneCoroutineDebuggerEnabled() ? (CoroutineInfoProvider)new CoroutineNoLibraryProxy(executionContext2) : null;
        }
        return coroutineInfoProvider;
    }

    @NotNull
    public final SuspendContextImpl getSuspendContext() {
        return this.suspendContext;
    }

    public CoroutineDebugProbesProxy(@NotNull SuspendContextImpl suspendContext) {
        Intrinsics.checkNotNullParameter((Object)suspendContext, (String)"suspendContext");
        this.suspendContext = suspendContext;
    }

    static {
        Companion = new Companion(null);
        log$delegate = ProvidersKt.getLogger();
    }

    @Metadata(mv={1, 5, 1}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lorg/jetbrains/kotlin/idea/debugger/coroutine/proxy/CoroutineDebugProbesProxy$Companion;", "", "()V", "log", "Lcom/intellij/openapi/diagnostic/Logger;", "getLog", "()Lcom/intellij/openapi/diagnostic/Logger;", "log$delegate", "Lkotlin/properties/ReadOnlyProperty;", "kotlin.jvm-debugger.coroutines"})
    public static final class Companion {
        static final /* synthetic */ KProperty[] $$delegatedProperties;

        static {
            $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl(Companion.class, "log", "getLog()Lcom/intellij/openapi/diagnostic/Logger;", 0))};
        }

        private final Logger getLog() {
            return (Logger)log$delegate.getValue((Object)Companion, $$delegatedProperties[0]);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

